/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.internal.qvt.oml.project.QvtProjectUtil;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtElement;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtNamespace;
import org.eclipse.m2m.internal.qvt.oml.project.model.IQvtProject;
import org.eclipse.m2m.internal.qvt.oml.project.model.QvtModelException;
import org.eclipse.m2m.internal.qvt.oml.ui.QVTUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.ui.QvtPluginImages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.Messages;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.QvtProjectLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceDestinationChooser
extends ElementTreeSelectionDialog {
    private IQvtNamespace selectedNamespace;

    private SourceDestinationChooser(Shell parent, Object initialSelection) {
        super(parent, SourceDestinationChooser.createWorkbenchDelegatingProvider(), (ITreeContentProvider)new ContentProviderImpl());
        this.setComparator((ViewerComparator)new ResourceComparator(1));
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        if (initialSelection != null) {
            this.setInitialSelection(initialSelection);
        }
        this.setAllowMultiple(false);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer viewer = super.createTreeViewer(parent);
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IProject project = (IProject)SourceDestinationChooser.adaptObject(element, IProject.class);
                if (project != null) {
                    return QvtProjectUtil.isQvtProject((IProject)project);
                }
                return true;
            }
        });
        viewer.expandToLevel(2);
        return viewer;
    }

    <T> T getSelectedElement(Class<T> type) {
        ISelection selection = this.getTreeViewer().getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return SourceDestinationChooser.adaptObject(structuredSelection.getFirstElement(), type);
        }
        return null;
    }

    public static IContainer chooseSourceContainer(Shell shell, IContainer initialSourceContainer) {
        IContainer initialSelection = initialSourceContainer != null && initialSourceContainer.getType() != 4 ? new SourceContainer(initialSourceContainer) : initialSourceContainer;
        SourceDestinationChooser dialog = new SourceDestinationChooser(shell, initialSelection);
        dialog.setTitle(Messages.SourceDestinationChooser_SourceContainerSelectionTitle);
        dialog.setMessage(Messages.SourceDestinationChooser_ChooseSourceFolder);
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                IProject project = (IProject)SourceDestinationChooser.adaptObject(element, IProject.class);
                return project != null || element instanceof SourceContainer;
            }
        });
        dialog.setValidator(dialog.createSourceContainerValidator());
        if (dialog.open() == 0 && dialog.selectedNamespace != null) {
            try {
                IResource resource = dialog.selectedNamespace.getQvtProject().getDefaultNamespace().getUnderlyingResource();
                assert (resource instanceof IContainer);
                return resource instanceof IContainer ? (IContainer)resource : null;
            }
            catch (QvtModelException e) {
                QVTUIPlugin.log(e);
            }
        }
        return null;
    }

    public static IQvtNamespace chooseNamespaceFolder(Shell shell) {
        SourceDestinationChooser dialog = new SourceDestinationChooser(shell, null);
        dialog.setTitle(Messages.SourceDestinationChooser_NamespaceSelectionTitle);
        dialog.setMessage(Messages.SourceDestinationChooser_ChooseCUNamespaceFolder);
        dialog.setValidator(dialog.createNamespaceValidator());
        dialog.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof SourceContainer) {
                    return true;
                }
                IContainer container = (IContainer)SourceDestinationChooser.adaptObject(element, IContainer.class);
                if (container == null) {
                    return false;
                }
                return container.getType() == 4 || container.getType() == 2 && QvtProjectUtil.isNamespaceFolder((IFolder)((IFolder)container));
            }
        });
        if (dialog.open() == 0) {
            return dialog.selectedNamespace;
        }
        return null;
    }

    private ISelectionStatusValidator createNamespaceValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0) {
                    return QVTUIPlugin.createStatus(4, Messages.SourceDestinationChooser_NoNamespaceSelected, null);
                }
                IQvtNamespace namespace = SourceDestinationChooser.this.computeQvtNamespaceSelection();
                IStatus status = null;
                status = namespace == null ? QVTUIPlugin.createStatus(4, "Not a namespace selection", null) : ("".equals(namespace.getName()) ? QVTUIPlugin.createStatus(0, "The default namespace will be applied", null) : QVTUIPlugin.createStatus(0, "", null));
                if (status.isOK()) {
                    SourceDestinationChooser.this.selectedNamespace = namespace;
                }
                return status;
            }
        };
    }

    private ISelectionStatusValidator createSourceContainerValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0) {
                    return QVTUIPlugin.createStatus(4, Messages.SourceDestinationChooser_NoSourceContainerSelected, null);
                }
                IContainer container = SourceDestinationChooser.this.getSelectedElement(IContainer.class);
                IQvtNamespace namespace = SourceDestinationChooser.this.computeQvtNamespaceSelection();
                IStatus status = null;
                if (namespace == null || !"".equals(namespace.getName()) || container instanceof IProject && !container.getFullPath().equals((Object)namespace.getFullPath())) {
                    status = QVTUIPlugin.createStatus(4, "Not a source container selection", null);
                } else if (container != null) {
                    status = !container.exists() ? QVTUIPlugin.createStatus(4, "Source container does not exist", null) : QVTUIPlugin.createStatus(0, "", null);
                }
                if (status.isOK()) {
                    SourceDestinationChooser.this.selectedNamespace = namespace;
                } else {
                    SourceDestinationChooser.this.selectedNamespace = null;
                }
                return status;
            }
        };
    }

    private IQvtNamespace computeQvtNamespaceSelection() {
        IQvtProject project = null;
        IContainer container = this.getSelectedElement(IContainer.class);
        if (container != null) {
            project = QvtProjectUtil.getQvtProject((IProject)container.getProject());
        }
        if (project != null) {
            try {
                IQvtElement qvtSelection = project.findElement((IResource)container, true);
                if (qvtSelection != null) {
                    if (qvtSelection.getElementType() == 1) {
                        return ((IQvtProject)qvtSelection).getDefaultNamespace();
                    }
                    if (qvtSelection.getElementType() == 2) {
                        return (IQvtNamespace)qvtSelection;
                    }
                }
            }
            catch (QvtModelException e) {
                QVTUIPlugin.log(e);
            }
        }
        return null;
    }

    private static ILabelProvider createWorkbenchDelegatingProvider() {
        return new LabelProvideImpl((ILabelProvider)new QvtProjectLabelProvider());
    }

    private static <T> T adaptObject(Object adaptee, Class<T> adapterType) {
        if (adapterType.isInstance(adaptee)) {
            return adapterType.cast(adaptee);
        }
        if (adaptee instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)adaptee;
            return adapterType.cast(adaptable.getAdapter(adapterType));
        }
        return null;
    }

    private static QVTOBuilderConfig getBuilderConfig(Object element) {
        try {
            IProject project;
            IResource resource = SourceDestinationChooser.adaptObject(element, IResource.class);
            if (resource != null && QvtProjectUtil.isQvtProject((IProject)(project = resource.getProject()))) {
                return QVTOBuilderConfig.getConfig((IProject)project);
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    private static class ContentProviderImpl
    extends WorkbenchContentProvider {
        private ContentProviderImpl() {
        }

        public Object[] getChildren(Object element) {
            IContainer sourceContainer;
            QVTOBuilderConfig config;
            Object[] regularChildren = super.getChildren(element);
            IProject project = (IProject)SourceDestinationChooser.adaptObject(element, IProject.class);
            if (project != null && (config = SourceDestinationChooser.getBuilderConfig(project)) != null && (sourceContainer = config.getSourceContainer()).getType() != 4) {
                ArrayList<SourceContainer> children = new ArrayList<SourceContainer>(regularChildren.length + 1);
                children.add(new SourceContainer(sourceContainer));
                return children.toArray();
            }
            return super.getChildren(element);
        }

        public Object getParent(Object element) {
            SourceContainer container = (SourceContainer)SourceDestinationChooser.adaptObject(element, SourceContainer.class);
            if (container != null) {
                return container.resource.getProject();
            }
            return super.getParent(element);
        }
    }

    private static class LabelProvideImpl
    extends LabelProvider {
        private ILabelProvider delegate;
        private ILabelProvider provider = new WorkbenchLabelProvider();

        protected LabelProvideImpl(ILabelProvider delegate) {
            this.delegate = delegate;
            assert (delegate != null);
            assert (this.provider != null);
        }

        public Image getImage(Object element) {
            Image image = this.delegate.getImage(element);
            if (image != null) {
                return image;
            }
            return this.provider.getImage(element);
        }

        public String getText(Object element) {
            IContainer sourceContainer;
            QVTOBuilderConfig config;
            IContainer resource;
            if (element instanceof IContainer && (resource = (IContainer)element).getType() != 4 && (config = SourceDestinationChooser.getBuilderConfig(resource)) != null && (sourceContainer = config.getSourceContainer()).getType() != 4 && resource.equals((Object)sourceContainer)) {
                return resource.getProjectRelativePath().toString();
            }
            String text = this.delegate.getText(element);
            if (text != null) {
                return text;
            }
            return this.provider.getText(element);
        }
    }

    private static class SourceContainer
    implements IAdaptable,
    IWorkbenchAdapter {
        private final IContainer resource;

        SourceContainer(IContainer resource) {
            this.resource = resource;
        }

        public Object[] getChildren(Object o) {
            try {
                if (this.resource.exists()) {
                    return this.resource.members();
                }
            }
            catch (CoreException e) {
                QVTUIPlugin.log(e.getStatus());
            }
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return QvtPluginImages.getInstance().getImageDescriptor("src_container");
        }

        public String getLabel(Object o) {
            return this.resource.getProjectRelativePath().toString();
        }

        public Object getParent(Object o) {
            return this.resource.getProject();
        }

        public Object getAdapter(Class adapter) {
            return SourceDestinationChooser.adaptObject(this.resource, adapter);
        }

        public boolean equals(Object o) {
            if (o instanceof SourceContainer) {
                SourceContainer another = (SourceContainer)o;
                return this.resource.equals((Object)another.resource);
            }
            return false;
        }

        public int hashCode() {
            return this.resource.getFullPath().hashCode();
        }
    }
}

