/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.metrics.tck.application.http;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.data.MetricData;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.telemetry.metrics.tck.application.BasicHttpClient;
import org.eclipse.microprofile.telemetry.metrics.tck.application.TestLibraries;
import org.eclipse.microprofile.telemetry.metrics.tck.application.exporter.InMemoryMetricExporter;
import org.eclipse.microprofile.telemetry.metrics.tck.application.exporter.InMemoryMetricExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HttpHistogramTest
extends Arquillian {
    private static final AttributeKey<String> HTTP_REQUEST_METHOD = AttributeKey.stringKey((String)"http.request.method");
    private static final AttributeKey<String> URL_SCHEME = AttributeKey.stringKey((String)"url.scheme");
    private static final AttributeKey<String> HTTP_RESPONSE_STATUS_CODE = AttributeKey.stringKey((String)"http.response.status_code");
    private static final AttributeKey<String> NETWORK_PROTOCOL_NAME = AttributeKey.stringKey((String)"network.protocol.name");
    private static final AttributeKey<String> HTTP_ROUTE = AttributeKey.stringKey((String)"http.route");
    private static final AttributeKey<String> ERROR_TYPE = AttributeKey.stringKey((String)"error.type");
    @Inject
    OpenTelemetry openTelemetry;
    @ArquillianResource
    private URL url;
    @Inject
    private InMemoryMetricExporter metricExporter;
    private BasicHttpClient basicClient;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemoryMetricExporter.class, InMemoryMetricExporterProvider.class, BasicHttpClient.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableMetricExporterProvider.class, new Class[]{InMemoryMetricExporterProvider.class})).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.metrics.exporter=in-memory\notel.logs.exporter=none\notel.traces.exporter=none\notel.metric.export.interval=3000"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.metricExporter != null) {
            this.metricExporter.reset();
            this.basicClient = new BasicHttpClient(this.url);
        }
    }

    @Test
    void collectsHttpRouteFromEndAttributes() {
        this.basicClient.get("/fail");
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Assert.fail((String)"The test thread was interrupted");
        }
        List<MetricData> items = this.metricExporter.getFinishedMetricItems();
        HashMap<AttributeKey<String>, String> successfulHTTPMethod = new HashMap<AttributeKey<String>, String>();
        successfulHTTPMethod.put(HTTP_REQUEST_METHOD, "GET");
        successfulHTTPMethod.put(URL_SCHEME, "http");
        successfulHTTPMethod.put(HTTP_RESPONSE_STATUS_CODE, "200");
        successfulHTTPMethod.put(NETWORK_PROTOCOL_NAME, "HTTP");
        successfulHTTPMethod.put(HTTP_ROUTE, this.url.getPath().replaceAll("ArquillianServletRunner.*", ""));
        HashMap<AttributeKey<String>, String> failingHTTPMethod = new HashMap<AttributeKey<String>, String>();
        failingHTTPMethod.put(HTTP_REQUEST_METHOD, "GET");
        failingHTTPMethod.put(URL_SCHEME, "http");
        failingHTTPMethod.put(HTTP_RESPONSE_STATUS_CODE, "500");
        failingHTTPMethod.put(NETWORK_PROTOCOL_NAME, "HTTP");
        failingHTTPMethod.put(HTTP_ROUTE, this.url.getPath() + "fail");
        failingHTTPMethod.put(ERROR_TYPE, "500");
        this.testMetricItem(successfulHTTPMethod, items);
        this.testMetricItem(failingHTTPMethod, items);
    }

    private void testMetricItem(Map<AttributeKey<String>, String> keyAndExpectedValue, List<MetricData> items) {
        Assert.assertTrue((boolean)items.stream().flatMap(md -> md.getHistogramData().getPoints().stream()).anyMatch(point -> keyAndExpectedValue.entrySet().stream().allMatch(entry -> {
            String attribute = (String)point.getAttributes().get((AttributeKey)entry.getKey());
            return attribute != null && (attribute.equals(entry.getValue()) || ((AttributeKey)entry.getKey()).equals(HTTP_ROUTE) && ((String)entry.getValue()).contains((CharSequence)keyAndExpectedValue.get(HTTP_ROUTE)));
        })), (String)("failed to find a metric with all items in this attribute map: " + this.dumpTestedMap(keyAndExpectedValue) + "\n Dumping all attributes: " + this.dumpMetricItems(items)));
    }

    private String dumpTestedMap(Map<AttributeKey<String>, String> keyAndExpectedValue) {
        return keyAndExpectedValue.entrySet().stream().map(entry -> ((AttributeKey)entry.getKey()).toString() + "=" + (String)entry.getValue()).collect(Collectors.joining(", "));
    }

    private String dumpMetricItems(List<MetricData> items) {
        return items.stream().flatMap(md -> md.getHistogramData().getPoints().stream()).map(point -> point.getAttributes().toString()).collect(Collectors.joining(", "));
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }

    @Path(value="/")
    public static class SpanResource {
        @GET
        @Path(value="/fail")
        public Response span() {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

