/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck.providers;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

@Priority(value=5002)
public class TestResponseExceptionMapper
implements ResponseExceptionMapper<Throwable> {
    public static final String MESSAGE = "A 200 OK was received, but I'm throwing an exception";
    private static boolean handlesCalled = false;
    private static boolean headerPassedToHandlesMethod = false;
    private static boolean throwableCalled = false;

    public Throwable toThrowable(Response response) {
        throwableCalled = true;
        return new WebApplicationException(MESSAGE);
    }

    public boolean handles(int status, MultivaluedMap<String, Object> headers) {
        handlesCalled = true;
        headerPassedToHandlesMethod = "true".equals(headers.getFirst((Object)"CustomHeader"));
        return status == 200;
    }

    public static void reset() {
        handlesCalled = false;
        headerPassedToHandlesMethod = false;
        throwableCalled = false;
    }

    public static boolean isHandlesCalled() {
        return handlesCalled;
    }

    public static boolean isHeaderPassedToHandlesMethod() {
        return headerPassedToHandlesMethod;
    }

    public static boolean isThrowableCalled() {
        return throwableCalled;
    }
}

