/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

@RunAsClient
public class EntityPartTest
extends Arquillian {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(EntityPart.class.getSimpleName() + ".war"))).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void uploadFile() throws Exception {
        try (FileManagerClient client = EntityPartTest.createClient();){
            byte[] content;
            try (InputStream in = EntityPartTest.class.getResourceAsStream("/multipart/test-file1.txt");){
                Assert.assertNotNull((Object)in, (String)"Could not find /multipart/test-file1.txt");
                content = in.readAllBytes();
            }
            List<EntityPart> files = List.of(EntityPart.withFileName((String)"test-file1.txt").content((InputStream)new ByteArrayInputStream(content)).mediaType(MediaType.APPLICATION_OCTET_STREAM_TYPE).build());
            try (Response response = client.uploadFile(files);){
                Assert.assertEquals((int)201, (int)response.getStatus());
                JsonArray jsonArray = (JsonArray)response.readEntity(JsonArray.class);
                Assert.assertNotNull((Object)jsonArray);
                Assert.assertEquals((int)jsonArray.size(), (int)1);
                JsonObject json = jsonArray.getJsonObject(0);
                Assert.assertEquals((String)json.getString("name"), (String)"test-file1.txt");
                Assert.assertEquals((String)json.getString("fileName"), (String)"test-file1.txt");
                Assert.assertEquals((String)json.getString("content"), (String)"This is a test file for file 1.\n");
            }
        }
    }

    @Test
    public void uploadMultipleFiles() throws Exception {
        try (FileManagerClient client = EntityPartTest.createClient();){
            LinkedHashMap<String, byte[]> entityPartContent = new LinkedHashMap<String, byte[]>(2);
            try (InputStream in = EntityPartTest.class.getResourceAsStream("/multipart/test-file1.txt");){
                Assert.assertNotNull((Object)in, (String)"Could not find /multipart/test-file1.txt");
                entityPartContent.put("test-file1.txt", in.readAllBytes());
            }
            in = EntityPartTest.class.getResourceAsStream("/multipart/test-file2.txt");
            try {
                Assert.assertNotNull((Object)in, (String)"Could not find /multipart/test-file2.txt");
                entityPartContent.put("test-file2.txt", in.readAllBytes());
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            List<EntityPart> files = entityPartContent.entrySet().stream().map(entry -> {
                try {
                    return EntityPart.withName((String)((String)entry.getKey())).fileName((String)entry.getKey()).content(entry.getValue()).mediaType(MediaType.APPLICATION_OCTET_STREAM_TYPE).build();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).collect(Collectors.toList());
            try (Response response = client.uploadFile(files);){
                Assert.assertEquals((int)201, (int)response.getStatus());
                JsonArray jsonArray = (JsonArray)response.readEntity(JsonArray.class);
                Assert.assertNotNull((Object)jsonArray);
                Assert.assertEquals((int)jsonArray.size(), (int)2);
                for (JsonValue value : jsonArray) {
                    JsonObject json = value.asJsonObject();
                    if (json.getString("name").equals("test-file1.txt")) {
                        Assert.assertEquals((String)json.getString("fileName"), (String)"test-file1.txt");
                        Assert.assertEquals((String)json.getString("content"), (String)"This is a test file for file 1.\n");
                        continue;
                    }
                    if (json.getString("name").equals("test-file2.txt")) {
                        Assert.assertEquals((String)json.getString("fileName"), (String)"test-file2.txt");
                        Assert.assertEquals((String)json.getString("content"), (String)"This is a test file for file 2.\n");
                        continue;
                    }
                    Assert.fail((String)String.format("Unexpected entry %s in JSON response: %n%s", json, jsonArray));
                }
            }
        }
    }

    private static FileManagerClient createClient() {
        return (FileManagerClient)((RestClientBuilder)RestClientBuilder.newBuilder().baseUri("http://localhost:8080").register((Object)new FileManagerFilter())).build(FileManagerClient.class);
    }

    @Consumes(value={"multipart/form-data"})
    @Produces(value={"multipart/form-data"})
    public static interface FileManagerClient
    extends AutoCloseable {
        @POST
        @Path(value="upload")
        public Response uploadFile(List<EntityPart> var1) throws IOException;
    }

    public static class FileManagerFilter
    implements ClientRequestFilter {
        public void filter(ClientRequestContext requestContext) throws IOException {
            if (requestContext.getMethod().equals("POST")) {
                List entityParts = (List)requestContext.getEntity();
                JsonArrayBuilder jsonBuilder = Json.createArrayBuilder();
                for (EntityPart part : entityParts) {
                    JsonObjectBuilder jsonPartBuilder = Json.createObjectBuilder();
                    jsonPartBuilder.add("name", part.getName());
                    if (!part.getFileName().isPresent()) {
                        throw new BadRequestException("No file name for entity part " + part);
                    }
                    jsonPartBuilder.add("fileName", (String)part.getFileName().get());
                    jsonPartBuilder.add("content", (String)part.getContent(String.class));
                    jsonBuilder.add(jsonPartBuilder);
                }
                requestContext.abortWith(Response.status((int)201).entity((Object)jsonBuilder.build()).build());
            } else {
                requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid request").build());
            }
        }
    }
}

