/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.temporal.ChronoUnit;
import java.util.stream.IntStream;
import org.eclipse.microprofile.lra.tck.TckTestBase;
import org.eclipse.microprofile.lra.tck.participant.api.AfterLRAListener;
import org.eclipse.microprofile.lra.tck.participant.api.AfterLRAParticipant;
import org.eclipse.microprofile.lra.tck.participant.api.GenericLRAException;
import org.eclipse.microprofile.lra.tck.participant.api.LraResource;
import org.eclipse.microprofile.lra.tck.participant.api.ParticipatingTckResource;
import org.eclipse.microprofile.lra.tck.service.LRAMetricAssertions;
import org.eclipse.microprofile.lra.tck.service.LRATestService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TckTests
extends TckTestBase {
    @Inject
    private LRAMetricAssertions lraMetric;
    @Inject
    private LRATestService lraTestService;

    @Deployment(name="tcktests")
    public static WebArchive deploy() {
        return TckTestBase.deploy(TckTests.class.getSimpleName().toLowerCase());
    }

    @Test
    public void cancelLRA() throws WebApplicationException {
        try {
            URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
            this.lraClient.cancelLRA(lra);
            Assert.assertTrue((String)("LRA '" + lra + "' should not be active but is not marked as finished"), (boolean)this.lraTestService.isLRAFinished(lra));
        }
        catch (GenericLRAException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Test
    public void closeLRA() throws WebApplicationException {
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        this.lraClient.closeLRA(lra);
        Assert.assertTrue((String)("LRA '" + lra + "' should not be active anymore but is not marked as finished"), (boolean)this.lraTestService.isLRAFinished(lra));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nestedActivity() throws WebApplicationException {
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        WebTarget resourcePath = this.tckSuiteTarget.path("lraresource").path("nestedActivity");
        try (Response response = null;){
            response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
            Assert.assertEquals((String)("Response status to ' " + resourcePath.getUri() + "' does not match."), (long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
            Object parentId = response.getHeaders().getFirst((Object)"Long-Running-Action");
            Assert.assertNotNull((String)("Expecting to get parent LRA id as response from " + resourcePath.getUri()), (Object)parentId);
            Assert.assertEquals((String)("The nested activity should return the parent LRA id. The call to " + resourcePath.getUri()), (Object)parentId, (Object)lra.toString());
            URI nestedLraId = URI.create((String)response.readEntity(String.class));
            this.lraClient.closeLRA(lra);
            Assert.assertTrue((String)("Nested LRA id '" + lra + "' should be listed in the list of the active LRAs (from call to " + resourcePath.getUri() + ")"), (boolean)this.lraTestService.isLRAFinished(nestedLraId));
        }
    }

    @Test
    public void completeMultiLevelNestedActivity() throws WebApplicationException {
        this.multiLevelNestedActivity(CompletionType.complete, 1);
    }

    @Test
    public void compensateMultiLevelNestedActivity() throws WebApplicationException {
        this.multiLevelNestedActivity(CompletionType.compensate, 1);
    }

    @Test
    public void mixedMultiLevelNestedActivity() throws WebApplicationException {
        this.multiLevelNestedActivity(CompletionType.mixed, 2);
    }

    @Test
    public void joinLRAViaHeader() throws WebApplicationException {
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        WebTarget resourcePath = this.tckSuiteTarget.path("lraresource").path("work");
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response, resourcePath);
        Assert.assertFalse((String)("LRA '" + lra + "' should be active as it is not closed yet but it is marked as finished"), (boolean)this.lraTestService.isLRAFinished(lra));
        this.lraClient.closeLRA(lra);
        this.lraTestService.waitForCallbacks(lra);
        this.lraMetric.assertCompletedEquals("Wrong completion count for call " + resourcePath.getUri() + ". Expecting the method LRA was completed after joining the existing LRA " + lra, 1, lra, LraResource.class);
        Assert.assertTrue((String)("LRA '" + lra + "' should not be active anymore as it was closed yet but is not marked as finished"), (boolean)this.lraTestService.isLRAFinished(lra));
    }

    @Test
    public void join() throws WebApplicationException {
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        WebTarget resourcePath = this.tckSuiteTarget.path("lraresource").path("work");
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response, resourcePath);
        this.lraClient.closeLRA(lra);
        Assert.assertTrue((String)("LRA '" + lra + "' should be active as it is not closed yet but it is marked as finished"), (boolean)this.lraTestService.isLRAFinished(lra));
    }

    @Test
    public void testAfterLRAParticipant() throws WebApplicationException, InterruptedException {
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        WebTarget resourcePath = this.tckSuiteTarget.path("after-lra-participant").path("work");
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response, resourcePath);
        this.lraClient.closeLRA(lra);
        this.lraTestService.waitForCallbacks(lra);
        this.lraMetric.assertFinished("testAfterLRAParticipant: LRA did not finish", lra, AfterLRAParticipant.class);
        this.lraMetric.assertClosed("testAfterLRAParticipant: end synchronization was not invoked on resource " + resourcePath.getUri(), lra, AfterLRAParticipant.class);
    }

    @Test
    public void testAfterLRAListener() {
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        WebTarget resourcePath = this.tckSuiteTarget.path("after-lra-listener").path("work");
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response, resourcePath);
        this.lraClient.closeLRA(lra);
        this.lraTestService.waitForCallbacks(lra);
        this.lraMetric.assertFinished("testAfterLRAListener: LRA did not finish", lra, AfterLRAListener.class);
        this.lraMetric.assertClosed("testAfterLRAListener: end synchronization was not invoked on resource " + resourcePath.getUri(), lra, AfterLRAListener.class);
    }

    @Test
    public void leaveLRA() throws WebApplicationException {
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        WebTarget resourcePath = this.tckSuiteTarget.path("lraresource").path("work");
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response, resourcePath);
        resourcePath = this.tckSuiteTarget.path("lraresource").path("work");
        response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response, resourcePath);
        resourcePath = this.tckSuiteTarget.path("lraresource").path("leave");
        response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response, resourcePath);
        this.lraClient.closeLRA(lra);
        this.lraTestService.waitForCallbacks(lra);
        this.lraMetric.assertNotCompleted("Wrong completion count when participant left the LRA. Expecting the completed count hasn't change between start and end of the test. The test call went to LRA resource at " + resourcePath.getUri(), lra, LraResource.class);
    }

    @Test
    public void dependentLRA() throws WebApplicationException {
        WebTarget resourcePath = this.tckSuiteTarget.path("lraresource").path("startViaApi");
        Response response = resourcePath.request().put(Entity.text((Object)""));
        Object lraHeader = response.getHeaders().getFirst((Object)"Long-Running-Action");
        String lraId = this.checkStatusReadAndCloseResponse(Response.Status.OK, response, resourcePath);
        Assert.assertNull((String)("JAX-RS response to PUT request should not have returned the header Long-Running-Action. The test call went to " + resourcePath.getUri()), (Object)lraHeader);
        Assert.assertNotNull((String)("JAX-RS response to PUT request should have returned content of LRA id. The test call went to " + resourcePath.getUri()), (Object)lraId);
        this.lraClient.closeLRA(URI.create(lraId));
    }

    @Test
    public void timeLimit() {
        WebTarget resourcePath = this.tckSuiteTarget.path("lraresource").path("/timeLimit");
        Response response = resourcePath.request().get();
        URI lraId = URI.create(this.checkStatusReadAndCloseResponse(Response.Status.OK, response, resourcePath));
        this.lraTestService.waitForCallbacks(lraId);
        this.lraMetric.assertNotCompleted("The LRA should have timed out but complete was called instead of compensate. Expecting the number of complete call before test matches the ones after LRA timed out. The test call went to " + resourcePath.getUri(), lraId, LraResource.class);
        this.lraMetric.assertCompensatedEquals("The LRA should have timed out and compensate should be called. Expecting the number of compensate call before test is one less lower than the ones after LRA timed out. The test call went to " + resourcePath.getUri(), 1, lraId, LraResource.class);
    }

    @Test
    public void timeLimitWithPreConditionFailed() {
        WebTarget resourcePath = this.tckSuiteTarget.path("lraresource").path("/timeLimit2");
        Response response = resourcePath.request().get();
        MatcherAssert.assertThat((String)"Expected 412 or 410 response", (Object)response.getStatus(), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)Response.Status.PRECONDITION_FAILED.getStatusCode()), (Matcher)Matchers.is((Object)Response.Status.GONE.getStatusCode())));
        response.close();
    }

    @Test
    public void acceptCloseTest() throws WebApplicationException, InterruptedException {
        this.joinAndEnd(true, "lraresource", "acceptWork");
    }

    @Test
    public void acceptCancelTest() throws WebApplicationException, InterruptedException {
        this.joinAndEnd(false, "lraresource", "acceptWork");
    }

    private void joinAndEnd(boolean close, String path, String path2) throws WebApplicationException, InterruptedException {
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        WebTarget resourcePath = this.tckSuiteTarget.path(path).path(path2);
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response, resourcePath);
        if (close) {
            this.lraClient.closeLRA(lra);
        } else {
            this.lraClient.cancelLRA(lra);
        }
        this.lraTestService.waitForRecovery(lra);
        if (close) {
            this.lraMetric.assertCompletedEquals(String.format("acceptTest with close: participant (%s) was not asked to complete (expecting only one call)", resourcePath.getUri()), 1, lra, LraResource.class);
            this.lraMetric.assertNotCompensated(String.format("acceptTest with close: participant (%s) was asked to compensate", resourcePath.getUri()), lra, LraResource.class);
        } else {
            this.lraMetric.assertCompensatedEquals(String.format("acceptTest with cancel: participant (%s) was not asked to compensate (expecting only one call)", resourcePath.getUri()), 1, lra, LraResource.class);
            this.lraMetric.assertNotCompleted(String.format("acceptTest with cancel: participant (%s) was asked to complete", resourcePath.getUri()), lra, LraResource.class);
        }
        Assert.assertTrue((String)("acceptTest: LRA " + lra + " did not finish"), (boolean)this.lraTestService.isLRAFinished(lra));
    }

    @Test
    public void noLRATest() throws WebApplicationException {
        WebTarget resourcePath = this.tckSuiteTarget.path("nolraresource").path("work");
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        Response response = resourcePath.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        String lraId = this.checkStatusReadAndCloseResponse(Response.Status.OK, response, resourcePath);
        Assert.assertEquals((String)"While calling non-LRA method the resource returns not expected LRA id", (Object)lraId, (Object)lra.toString());
        this.lraClient.cancelLRA(lra);
        this.lraTestService.waitForCallbacks(lra);
        this.lraMetric.assertNotCompleted("Completed should not be called on the LRA aware service. The number of completed count for before and after test does not match. The test call went to " + resourcePath.getUri(), lra, LraResource.class);
        this.lraMetric.assertCompensatedEquals("Compensated service should be called on LRA aware service. The number of compensated count after test is bigger for one. The test call went to " + resourcePath.getUri(), 1, lra, LraResource.class);
    }

    @Test
    public void joinWithOneResourceSameMethodTwiceWithCancel() throws WebApplicationException {
        this.joinWithOneResource("joinWithOneResourceSameMethodTwiceWithCancel", false, "/join-with-existing-lra", "/join-with-existing-lra");
    }

    @Test
    public void joinWithOneResourceDifferentMethodTwiceWithCancel() throws WebApplicationException {
        this.joinWithOneResource("joinWithOneResourceDifferentMethodTwiceWithCancel", false, "/join-with-existing-lra", "/join-with-existing-lra2");
    }

    @Test
    public void joinWithOneResourceSameMethodTwiceWithClose() throws WebApplicationException {
        this.joinWithOneResource("joinWithOneResourceSameMethodTwiceWithClose", true, "/join-with-existing-lra", "/join-with-existing-lra");
    }

    @Test
    public void joinWithOneResourceDifferentMethodTwiceWithClose() throws WebApplicationException {
        this.joinWithOneResource("joinWithOneResourceDifferentMethodTwiceWithClose", true, "/join-with-existing-lra", "/join-with-existing-lra2");
    }

    @Test
    public void joinWithTwoResourcesWithClose() throws WebApplicationException {
        this.joinWithTwoResources(true);
    }

    @Test
    public void joinWithTwoResourcesWithCancel() throws WebApplicationException {
        this.joinWithTwoResources(false);
    }

    private void joinWithOneResource(String methodName, boolean close, String resource1Method, String resource2Method) throws WebApplicationException {
        WebTarget resource1Path = this.tckSuiteTarget.path("participating-tck-resource").path(resource1Method);
        WebTarget resource2Path = this.tckSuiteTarget.path("participating-tck-resource").path(resource2Method);
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        Response response1 = resource1Path.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response1, resource1Path);
        Response response2 = resource2Path.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response2, resource2Path);
        if (close) {
            this.lraClient.closeLRA(lra);
            this.lraTestService.waitForCallbacks(lra);
            this.lraMetric.assertCompleted(methodName + ": resource should have completed", lra, ParticipatingTckResource.class);
            this.lraMetric.assertNotCompensated(methodName + ": resource should have completed with no compensations", lra, ParticipatingTckResource.class);
        } else {
            this.lraClient.cancelLRA(lra);
            this.lraTestService.waitForCallbacks(lra);
            this.lraMetric.assertCompensated(methodName + ": resource should have compensated", lra, ParticipatingTckResource.class);
            this.lraMetric.assertNotCompleted(methodName + ": resource should have compensated with no completions", lra, ParticipatingTckResource.class);
        }
    }

    private void joinWithTwoResources(boolean close) throws WebApplicationException {
        WebTarget resource1Path = this.tckSuiteTarget.path("lraresource").path("work");
        WebTarget resource2Path = this.tckSuiteTarget.path("participating-tck-resource").path("/join-with-existing-lra");
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        Response response1 = resource1Path.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response1, resource1Path);
        Response response2 = resource2Path.request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        this.checkStatusAndCloseResponse(Response.Status.OK, response2, resource2Path);
        if (close) {
            this.lraClient.closeLRA(lra);
            this.lraTestService.waitForCallbacks(lra);
            this.lraMetric.assertCompletedEquals("joinWithTwoResourcesWithClose: LRAResource should have completed once", 1, lra, LraResource.class);
            this.lraMetric.assertCompleted("joinWithTwoResourcesWithClose: ParticipatingTckResource should have completed", lra, ParticipatingTckResource.class);
        } else {
            this.lraClient.cancelLRA(lra);
            this.lraTestService.waitForCallbacks(lra);
            this.lraMetric.assertCompensatedEquals("joinWithTwoResourcesWithClose: LRAResource should have compensated once", 1, lra, LraResource.class);
            this.lraMetric.assertCompensated("joinWithTwoResourcesWithClose: ParticipatingTckResource should have compensated", lra, ParticipatingTckResource.class);
        }
    }

    private void multiLevelNestedActivity(CompletionType how, int nestedCnt) throws WebApplicationException {
        WebTarget resourcePath = this.tckSuiteTarget.path("lraresource").path("multiLevelNestedActivity");
        if (how == CompletionType.mixed && nestedCnt <= 1) {
            how = CompletionType.complete;
        }
        URI lra = this.lraClient.startLRA(null, this.lraClientId(), this.lraTimeout(), ChronoUnit.MILLIS);
        String lraId = lra.toString();
        Response response = resourcePath.queryParam("nestedCnt", new Object[]{nestedCnt}).request().header("Long-Running-Action", (Object)lra).put(Entity.text((Object)""));
        String lraStr = this.checkStatusReadAndCloseResponse(Response.Status.OK, response, resourcePath);
        Assert.assertNotNull((String)("expecting a LRA string returned from " + resourcePath.getUri()), (Object)lraStr);
        String[] lraArray = lraStr.split(",");
        URI[] uris = new URI[lraArray.length];
        IntStream.range(0, uris.length).forEach(i -> {
            try {
                uris[i] = new URI(lraArray[i]);
            }
            catch (URISyntaxException e) {
                Assert.fail((String)String.format("%s (multiLevelNestedActivity): returned an invalid URI: %s", resourcePath.getUri().toString(), e.getMessage()));
            }
        });
        Assert.assertEquals((String)("multiLevelNestedActivity: step 1 (the test call went to " + resourcePath.getUri() + ")"), (long)(nestedCnt + 1), (long)lraArray.length);
        Assert.assertEquals((String)("multiLevelNestedActivity: step 2 (the test call went to " + resourcePath.getUri() + ")"), (Object)lraId, (Object)lraArray[0]);
        Assert.assertFalse((String)("multiLevelNestedActivity: top level LRA should be active (path called " + resourcePath.getUri() + ")"), (boolean)this.lraTestService.isLRAFinished(URI.create(lraArray[0])));
        IntStream.range(1, uris.length).parallel().forEach(i -> this.lraTestService.waitForCallbacks(uris[i]));
        this.lraMetric.assertCompletedAllEquals("multiLevelNestedActivity: step 3 (called test path " + resourcePath.getUri() + ")", nestedCnt);
        this.lraMetric.assertCompensatedAllEquals("multiLevelNestedActivity: step 4 (called test path " + resourcePath.getUri() + ")", 0);
        if (how == CompletionType.compensate) {
            this.lraClient.cancelLRA(lra);
        } else if (how == CompletionType.complete) {
            this.lraClient.closeLRA(lra);
        } else {
            this.tckSuiteTarget.path("lraresource").path("/cancel").request().header("Long-Running-Action", (Object)uris[1]).put(Entity.text((Object)""));
            this.lraClient.closeLRA(lra);
        }
        IntStream.rangeClosed(0, nestedCnt).forEach(i -> Assert.assertTrue((String)String.format("multiLevelNestedActivity: %s LRA still active (resource path was %s)", i == 0 ? "top level" : "nested", resourcePath.getUri()), (boolean)this.lraTestService.isLRAFinished(URI.create(lraArray[i]))));
        this.lraTestService.waitForCallbacks(lra);
        if (how == CompletionType.complete) {
            this.lraMetric.assertCompletedAllEquals("multiLevelNestedActivity: step 5 (called test path " + resourcePath.getUri() + ")", 2 * nestedCnt);
            this.lraMetric.assertCompensatedAllEquals("multiLevelNestedActivity: step 6 (called test path " + resourcePath.getUri() + ")", 0);
        } else if (how == CompletionType.compensate) {
            this.lraMetric.assertCompletedAllEquals("multiLevelNestedActivity: step 7 (called test path " + resourcePath.getUri() + ")", nestedCnt);
            this.lraMetric.assertCompensatedAllEquals("multiLevelNestedActivity: step 8 (called test path " + resourcePath.getUri() + ")", nestedCnt + 1);
        } else {
            this.lraMetric.assertCompletedAllEquals("multiLevelNestedActivity: step 10 (called test path " + resourcePath.getUri() + ")", nestedCnt + 1);
            this.lraMetric.assertCompensatedAllEquals("multiLevelNestedActivity: step 9 (called test path " + resourcePath.getUri() + ")", 1);
        }
    }

    private static enum CompletionType {
        complete,
        compensate,
        mixed;

    }
}

