/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.config;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.microprofile.jwt.tck.config.JwksApplication;
import org.eclipse.microprofile.jwt.tck.config.PublicKeyEndpoint;
import org.eclipse.microprofile.jwt.tck.config.SimpleTokenUtils;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public class PublicKeyAsJWKTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment(name="jwk")
    public static WebArchive createDeploymentJWK() throws IOException {
        URL publicKey = PublicKeyAsJWKTest.class.getResource("/signer-key4k.jwk");
        StringWriter jwksContents = new StringWriter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(publicKey.openStream()));){
            String line = reader.readLine();
            while (line != null) {
                jwksContents.write(line);
                line = reader.readLine();
            }
        }
        Properties configProps = new Properties();
        System.out.printf("jwk: %s\n", jwksContents.toString());
        configProps.setProperty("mp.jwt.verify.publickey", jwksContents.toString());
        configProps.setProperty("mp.jwt.verify.issuer", "https://server.example.com");
        StringWriter configSW = new StringWriter();
        configProps.store(configSW, "PublicKeyAsJWKTest JWK microprofile-config.properties");
        StringAsset configAsset = new StringAsset(configSW.toString());
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"PublicKeyAsJWKTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_1.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/signer-keyset4k.jwk")).addClass(PublicKeyEndpoint.class)).addClass(JwksApplication.class)).addClass(SimpleTokenUtils.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource((Asset)configAsset, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"config"}, description="Validate that the embedded JWKS key is used to verify the JWT signature")
    public void testKeyAsJWK() throws Exception {
        Reporter.log((String)"testKeyAsJWK, expect HTTP_OK");
        RSAPrivateKey privateKey = TokenUtils.readPrivateKey((String)"/privateKey4k.pem");
        String kid = "publicKey4k";
        HashMap timeClaims = new HashMap();
        String token = TokenUtils.generateTokenString((PrivateKey)privateKey, (String)kid, (String)"/Token1.json", null, timeClaims);
        String uri = this.baseURL.toExternalForm() + "jwks/endp/verifyKeyAsJWK";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("kid", new Object[]{kid});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }
}

