/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.editor;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.editor.MultiPaneEditorSelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class MultiPaneEditorSite
implements IEditorSite {
    private IEditorPart editor;
    private MultiPaneEditor multiPageEditor;
    private ISelectionProvider selectionProvider = null;
    private ISelectionChangedListener selectionChangedListener = null;

    public MultiPaneEditorSite(MultiPaneEditor multiPageEditor, IEditorPart editor) {
        if (multiPageEditor == null) {
            throw new NullPointerException();
        }
        if (editor == null) {
            throw new NullPointerException();
        }
        this.multiPageEditor = multiPageEditor;
        this.editor = editor;
    }

    public IEditorActionBarContributor getActionBarContributor() {
        return this.multiPageEditor.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.multiPageEditor.getEditorSite().getActionBars();
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    public String getId() {
        return "";
    }

    public MultiPaneEditor getMultiPageEditor() {
        return this.multiPageEditor;
    }

    public IWorkbenchPage getPage() {
        return this.getMultiPageEditor().getSite().getPage();
    }

    public String getPluginId() {
        return "";
    }

    public String getRegisteredName() {
        return "";
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MultiPaneEditorSite.this.handleSelectionChanged(event);
                }
            };
        }
        return this.selectionChangedListener;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Shell getShell() {
        return this.getMultiPageEditor().getSite().getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.getMultiPageEditor().getSite().getWorkbenchWindow();
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        if (parentProvider instanceof MultiPaneEditorSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            ((MultiPaneEditorSelectionProvider)parentProvider).fireSelectionChanged(newEvent);
        }
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selectionProvider) {
        this.getMultiPageEditor().getSite().registerContextMenu(menuID, menuMgr, selectionProvider);
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
        this.getMultiPageEditor().getSite().registerContextMenu(menuManager, selectionProvider);
    }

    public final void registerContextMenu(String menuId, MenuManager menuMgr, ISelectionProvider selectionProvider, boolean includeEditorInput) {
    }

    public final void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        ISelectionProvider oldSelectionProvider = this.selectionProvider;
        this.selectionProvider = provider;
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public IWorkbenchPart getPart() {
        return this.editor;
    }

    public <T> T getService(Class<T> api) {
        return null;
    }

    public boolean hasService(Class<?> api) {
        return false;
    }

    public IKeyBindingService getKeyBindingService() {
        return null;
    }
}

