/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.mat.ibmvm.acquire.DumpType;
import org.eclipse.mat.ibmvm.acquire.IBMDumpProvider;
import org.eclipse.mat.ibmvm.acquire.Messages;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;

public abstract class BaseProvider
implements IHeapDumpProvider {
    @Argument
    public DumpType defaultType = DumpType.SYSTEM;
    @Argument(isMandatory=false)
    public boolean defaultLive = true;
    @Argument(isMandatory=false)
    public boolean defaultCompress = false;
    @Argument(isMandatory=false)
    public boolean listAttach = true;
    @Argument
    public String systemDumpTemplate = "core.{0,date,yyyyMMdd.HHmmss}.{1,number,0}.{2,number,0000}.dmp";
    @Argument
    public String systemDumpZipTemplate = "core.{0,date,yyyyMMdd.HHmmss}.{1,number,0}.{2,number,0000}.dmp.zip";
    @Argument
    public String heapDumpTemplate = "heapdump.{0,date,yyyyMMdd.HHmmss}.{1,number,0}.{2,number,0000}.phd";
    @Argument
    public String heapDumpZipTemplate = "heapdump.{0,date,yyyyMMdd.HHmmss}.{1,number,0}.{2,number,0000}.phd.gz";
    @Argument
    public String javaDumpTemplate = "javacore.{0,date,yyyyMMdd.HHmmss}.{1,number,0}.{2,number,0000}.txt";
    @Argument
    public String hprofDumpTemplate = "java_pid{1,number,0000}.{2,number,0000}.hprof";
    @Argument
    public String hprofDumpZipTemplate = "java_pid{1,number,0000}.{2,number,0000}.hprof.gz";
    static final int SLEEP_TIMEOUT = 500;
    static final int GROW_COUNT = 600;
    static final int FINISHED_COUNT = 10;
    static final int CREATE_COUNT = 60;
    static final int GROWING_COUNT = 1320;
    static final int TOTAL_WORK = 1980;
    static final String INFO_SEPARATOR = File.pathSeparator;

    static File makeJar(String jarname, String metaEntry, String[] classesNames, Class<?>[] classes) throws IOException, FileNotFoundException {
        File jarfile = File.createTempFile(jarname, ".jar");
        jarfile.deleteOnExit();
        try (FileOutputStream fo = new FileOutputStream(jarfile);){
            ZipOutputStream zo = new ZipOutputStream(fo);
            ZipEntry ze = new ZipEntry("META-INF/MANIFEST.MF");
            zo.putNextEntry(ze);
            zo.write((String.valueOf(metaEntry) + classesNames[0] + "\n").getBytes("UTF-8"));
            zo.closeEntry();
            Object[] objectArray = classesNames;
            int n = classesNames.length;
            int n2 = 0;
            while (n2 < n) {
                String agent = objectArray[n2];
                BaseProvider.addClassToJar(zo, IBMDumpProvider.class, agent);
                ++n2;
            }
            objectArray = classes;
            n = classes.length;
            n2 = 0;
            while (n2 < n) {
                Object cls = objectArray[n2];
                String agent = ((Class)cls).getName();
                BaseProvider.addClassToJar(zo, cls, agent);
                if (cls == Messages.class) {
                    BaseProvider.addMessagesToJar(zo, Messages.RESOURCE_BUNDLE, String.valueOf(Messages.class.getPackage().getName()) + ".messages");
                }
                ++n2;
            }
            zo.close();
        }
        return jarfile;
    }

    private static void addClassToJar(ZipOutputStream zo, Class<?> cls, String agent) throws IOException {
        String agentFile = String.valueOf(agent.replace('.', '/')) + ".class";
        ZipEntry ze = new ZipEntry(agentFile);
        zo.putNextEntry(ze);
        InputStream is = cls.getResourceAsStream("/" + agentFile);
        if (is == null) {
            throw new FileNotFoundException(agentFile);
        }
        try (BufferedInputStream s = new BufferedInputStream(is);){
            int r;
            byte[] b = new byte[10000];
            while ((r = s.read(b)) >= 0) {
                zo.write(b, 0, r);
            }
        }
        zo.closeEntry();
    }

    private static void addMessagesToJar(ZipOutputStream zo, ResourceBundle rb, String agent) throws IOException {
        String agentFile = String.valueOf(agent.replace('.', '/')) + ".properties";
        ZipEntry ze = new ZipEntry(agentFile);
        zo.putNextEntry(ze);
        Properties p = new Properties();
        Enumeration<String> e = rb.getKeys();
        while (e.hasMoreElements()) {
            String k = e.nextElement();
            p.put(k, rb.getString(k));
        }
        p.store(zo, agent);
        zo.closeEntry();
    }
}

