/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.util.MessageUtil;

public class ErrorLogHandler
extends Handler {
    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        String name;
        int severity = 0;
        if (record.getLevel().intValue() >= Level.SEVERE.intValue()) {
            severity = 4;
        } else if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
            severity = 2;
        } else if (record.getLevel().intValue() >= Level.INFO.intValue()) {
            severity = 1;
        }
        String message = record.getMessage();
        if (record.getParameters() != null) {
            message = MessageUtil.format((String)message, (Object[])record.getParameters());
        }
        name = (name = record.getLoggerName()) != null ? (name.startsWith("org.eclipse.mat.ui.") ? "org.eclipse.mat.ui" : (name.startsWith("org.eclipse.mat.parser.") ? "org.eclipse.mat.parser" : (name.startsWith("org.eclipse.mat.report.") || name.startsWith("org.eclipse.mat.query.") ? "org.eclipse.mat.report" : (name.startsWith("org.eclipse.mat.inspections.") || name.startsWith("org.eclipse.mat.internal.") || name.startsWith("org.eclipse.mat.snapshot.") ? "org.eclipse.mat.api" : "org.eclipse.mat.ui")))) : "org.eclipse.mat.ui";
        Status status = new Status(severity, name, message, record.getThrown());
        MemoryAnalyserPlugin.log((IStatus)status);
    }
}

