/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.project;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4mp.commons.utils.IConfigSourcePropertiesProvider;
import org.eclipse.lsp4mp.commons.utils.StringUtils;
import org.eclipse.lsp4mp.jdt.core.project.IConfigSource;

public class ConfigSourcePropertiesProvider
implements IConfigSourcePropertiesProvider {
    private final IConfigSource configSource;
    private transient Set<String> keys;

    public ConfigSourcePropertiesProvider(IConfigSource configSource) {
        this.configSource = configSource;
        this.keys = null;
    }

    @Override
    public Set<String> keys() {
        if (this.keys != null) {
            return this.keys;
        }
        this.keys = this.configSource.getAllKeys().stream().filter(key -> StringUtils.hasText(this.configSource.getProperty((String)key))).collect(Collectors.toSet());
        return this.keys;
    }

    @Override
    public boolean hasKey(String key) {
        return StringUtils.hasText(this.configSource.getProperty(key));
    }

    @Override
    public String getValue(String key) {
        return this.configSource.getProperty(key);
    }
}

