/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.lsp4mp.jdt.core.IPropertiesProvider;

public class PropertiesProviderRegistry
implements IRegistryChangeListener {
    private static final String CLASS_ATTR = "class";
    private static final Logger LOGGER = Logger.getLogger(PropertiesProviderRegistry.class.getName());
    private static final PropertiesProviderRegistry INSTANCE = new PropertiesProviderRegistry();
    private static final String EXTENSION_PROPERTIES_PROVIDERS = "propertiesProviders";
    private boolean extensionPropertiesProvidersLoaded = false;
    private boolean registryListenerIntialized = false;
    private final List<IPropertiesProvider> propertiesProviders = new ArrayList<IPropertiesProvider>();

    public static PropertiesProviderRegistry getInstance() {
        return INSTANCE;
    }

    public List<IPropertiesProvider> getPropertiesProviders() {
        this.loadExtensionProviders();
        return this.propertiesProviders;
    }

    private synchronized void loadExtensionProviders() {
        if (this.extensionPropertiesProvidersLoaded) {
            return;
        }
        this.extensionPropertiesProvidersLoaded = true;
        LOGGER.log(Level.INFO, "->- Loading .propertiesProviders extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.lsp4mp.jdt.core", EXTENSION_PROPERTIES_PROVIDERS);
        this.addExtensionPropertiesProviders(cf);
        this.addRegistryListenerIfNeeded();
        LOGGER.log(Level.INFO, "-<- Done loading .propertiesProviders extension point -<-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.lsp4mp.jdt.core", EXTENSION_PROPERTIES_PROVIDERS);
        if (deltas != null) {
            PropertiesProviderRegistry propertiesProviderRegistry = this;
            synchronized (propertiesProviderRegistry) {
                IExtensionDelta[] iExtensionDeltaArray = deltas;
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionDelta delta = iExtensionDeltaArray[n2];
                    IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
                    if (delta.getKind() == 1) {
                        this.addExtensionPropertiesProviders(cf);
                    } else {
                        this.removeExtensionPropertiesProviders(cf);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addExtensionPropertiesProviders(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                IPropertiesProvider provider = (IPropertiesProvider)ce.createExecutableExtension(CLASS_ATTR);
                List<IPropertiesProvider> list = this.propertiesProviders;
                synchronized (list) {
                    this.propertiesProviders.add(provider);
                }
                LOGGER.log(Level.INFO, "  Loaded propertiesProviders: " + provider.getClass().getName());
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "  Loaded while loading  propertiesProviders", t);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExtensionPropertiesProviders(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                IPropertiesProvider provider = (IPropertiesProvider)ce.createExecutableExtension(CLASS_ATTR);
                List<IPropertiesProvider> list = this.propertiesProviders;
                synchronized (list) {
                    this.propertiesProviders.remove(provider);
                }
                LOGGER.log(Level.INFO, "  Unloaded propertiesProviders: " + provider.getClass().getName());
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "  Unloaded while loading  propertiesProviders", t);
            }
            ++n2;
        }
    }

    private void addRegistryListenerIfNeeded() {
        if (this.registryListenerIntialized) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.lsp4mp.jdt.core");
        this.registryListenerIntialized = true;
    }

    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void initialize() {
    }
}

