/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.ls;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaHoverParams;
import org.eclipse.lsp4mp.jdt.core.PropertiesManagerForJava;
import org.eclipse.lsp4mp.jdt.internal.core.ls.AbstractMicroProfileDelegateCommandHandler;
import org.eclipse.lsp4mp.jdt.internal.core.ls.ArgumentUtils;
import org.eclipse.lsp4mp.jdt.internal.core.ls.JDTUtilsLSImpl;

public class MicroProfileDelegateCommandHandlerForJava
extends AbstractMicroProfileDelegateCommandHandler {
    private static final String JAVA_CODEACTION_COMMAND_ID = "microprofile/java/codeAction";
    private static final String JAVA_CODELENS_COMMAND_ID = "microprofile/java/codeLens";
    private static final String JAVA_DIAGNOSTICS_COMMAND_ID = "microprofile/java/diagnostics";
    private static final String JAVA_HOVER_COMMAND_ID = "microprofile/java/hover";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor progress) throws Exception {
        switch (commandId) {
            case "microprofile/java/codeAction": {
                return MicroProfileDelegateCommandHandlerForJava.getCodeActionForJava(arguments, commandId, progress);
            }
            case "microprofile/java/codeLens": {
                return MicroProfileDelegateCommandHandlerForJava.getCodeLensForJava(arguments, commandId, progress);
            }
            case "microprofile/java/diagnostics": {
                return MicroProfileDelegateCommandHandlerForJava.getDiagnosticsForJava(arguments, commandId, progress);
            }
            case "microprofile/java/hover": {
                return MicroProfileDelegateCommandHandlerForJava.getHoverForJava(arguments, commandId, progress);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported command '%s'!", commandId));
    }

    private static List<? extends CodeAction> getCodeActionForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileJavaCodeActionParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaCodeActionParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().codeAction(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaCodeActionParams createMicroProfileJavaCodeActionParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaCodeActionParams argument!", commandId));
        }
        TextDocumentIdentifier texdDocumentIdentifier = ArgumentUtils.getTextDocumentIdentifier(obj, "textDocument");
        if (texdDocumentIdentifier == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaCodeActionParams.texdDocumentIdentifier", commandId));
        }
        Range range = ArgumentUtils.getRange(obj, "range");
        CodeActionContext context = ArgumentUtils.getCodeActionContext(obj, "context");
        MicroProfileJavaCodeActionParams params = new MicroProfileJavaCodeActionParams();
        params.setTextDocument(texdDocumentIdentifier);
        params.setRange(range);
        params.setContext(context);
        return params;
    }

    private static List<? extends CodeLens> getCodeLensForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileJavaCodeLensParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaCodeLensParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().codeLens(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaCodeLensParams createMicroProfileJavaCodeLensParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaCodeLensParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaCodeLensParams.uri (java URI)!", commandId));
        }
        MicroProfileJavaCodeLensParams params = new MicroProfileJavaCodeLensParams(javaFileUri);
        params.setUrlCodeLensEnabled(ArgumentUtils.getBoolean(obj, "urlCodeLensEnabled"));
        params.setCheckServerAvailable(ArgumentUtils.getBoolean(obj, "checkServerAvailable"));
        params.setOpenURICommand(ArgumentUtils.getString(obj, "openURICommand"));
        params.setLocalServerPort(ArgumentUtils.getInt(obj, "localServerPort"));
        return params;
    }

    private static List<PublishDiagnosticsParams> getDiagnosticsForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException {
        MicroProfileJavaDiagnosticsParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaDiagnosticsParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().diagnostics(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaDiagnosticsParams createMicroProfileJavaDiagnosticsParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaDiagnosticsParams argument!", commandId));
        }
        List<String> javaFileUri = ArgumentUtils.getStringList(obj, "uris");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaDiagnosticsParams.uri (java URIs)!", commandId));
        }
        return new MicroProfileJavaDiagnosticsParams(javaFileUri);
    }

    private static Hover getHoverForJava(List<Object> arguments, String commandId, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileJavaHoverParams params = MicroProfileDelegateCommandHandlerForJava.createMicroProfileJavaHoverParams(arguments, commandId);
        return PropertiesManagerForJava.getInstance().hover(params, JDTUtilsLSImpl.getInstance(), monitor);
    }

    private static MicroProfileJavaHoverParams createMicroProfileJavaHoverParams(List<Object> arguments, String commandId) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaHoverParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaHoverParams.uri (java URI)!", commandId));
        }
        Position hoverPosition = ArgumentUtils.getPosition(obj, "position");
        DocumentFormat documentFormat = DocumentFormat.PlainText;
        Number documentFormatIndex = (Number)obj.get("documentFormat");
        if (documentFormatIndex != null) {
            documentFormat = DocumentFormat.forValue(documentFormatIndex.intValue());
        }
        return new MicroProfileJavaHoverParams(javaFileUri, hoverPosition, documentFormat);
    }
}

