/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.utils;

import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

public class AnnotationUtils {
    public static boolean hasAnnotation(IAnnotatable annotatable, String annotationName) throws JavaModelException {
        return AnnotationUtils.getAnnotation(annotatable, annotationName) != null;
    }

    public static IAnnotation getAnnotation(IAnnotatable annotatable, String annotationName) throws JavaModelException {
        IAnnotation[] annotations;
        if (annotatable == null) {
            return null;
        }
        IAnnotation[] iAnnotationArray = annotations = annotatable.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            if (AnnotationUtils.isMatchAnnotation(annotation, annotationName)) {
                return annotation;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isMatchAnnotation(IAnnotation annotation, String annotationName) {
        return annotationName.endsWith(annotation.getElementName());
    }

    public static boolean isMatchAnnotation(Annotation annotation, String annotationName) {
        return annotationName.endsWith(annotation.getTypeName().getFullyQualifiedName());
    }

    public static String getAnnotationMemberValue(IAnnotation annotation, String memberName) throws JavaModelException {
        IMemberValuePair[] iMemberValuePairArray = annotation.getMemberValuePairs();
        int n = iMemberValuePairArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePair pair = iMemberValuePairArray[n2];
            if (memberName.equals(pair.getMemberName())) {
                return pair.getValue() != null ? pair.getValue().toString() : null;
            }
            ++n2;
        }
        return null;
    }

    public static Expression getAnnotationMemberValueExpression(Annotation annotation, String memberName) throws JavaModelException {
        if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            for (Object pair : normalAnnotation.values()) {
                MemberValuePair castPair = (MemberValuePair)pair;
                if (!"fallbackMethod".equals(castPair.getName().toString())) continue;
                return castPair.getValue();
            }
            return null;
        }
        if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            return singleMemberAnnotation.getProperty(memberName) != null ? singleMemberAnnotation.getValue() : null;
        }
        return null;
    }
}

