/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.test.annotations;

import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4jakarta.commons.JakartaJavaCodeActionParams;
import org.eclipse.lsp4jakarta.commons.JakartaJavaDiagnosticsParams;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.test.core.BaseJakartaTest;
import org.eclipse.lsp4jakarta.jdt.test.core.JakartaForJavaAssert;
import org.junit.Test;

public class PreDestroyAnnotationTest
extends BaseJakartaTest {
    protected static IJDTUtils IJDT_UTILS = JDTUtilsLSImpl.getInstance();

    @Test
    public void GeneratedAnnotation() throws Exception {
        IJavaProject javaProject = PreDestroyAnnotationTest.loadJavaProject("jakarta-sample", "");
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/io/openliberty/sample/jakarta/annotations/PreDestroyAnnotation.java"));
        String uri = javaFile.getLocation().toFile().toURI().toString();
        JakartaJavaDiagnosticsParams diagnosticsParams = new JakartaJavaDiagnosticsParams();
        diagnosticsParams.setUris(Arrays.asList(uri));
        Diagnostic d1 = JakartaForJavaAssert.d(24, 16, 28, "A method with the @PreDestroy annotation must not have any parameters.", DiagnosticSeverity.Error, "jakarta-annotations", "PreDestroyParams");
        Diagnostic d2 = JakartaForJavaAssert.d(31, 20, 31, "A method with the @PreDestroy annotation must not be static.", DiagnosticSeverity.Error, "jakarta-annotations", "PreDestroyStatic");
        Diagnostic d3 = JakartaForJavaAssert.d(36, 13, 25, "A method with the annotation '@PreDestroy' must not throw checked exceptions.", DiagnosticSeverity.Error, "jakarta-annotations", "PreDestroyException");
        Diagnostic d4 = JakartaForJavaAssert.d(51, 13, 29, "A method with the annotation '@PreDestroy' must not throw checked exceptions.", DiagnosticSeverity.Error, "jakarta-annotations", "PreDestroyException");
        Diagnostic d5 = JakartaForJavaAssert.d(56, 13, 40, "A method with the annotation '@PreDestroy' must not throw checked exceptions.", DiagnosticSeverity.Error, "jakarta-annotations", "PreDestroyException");
        JakartaForJavaAssert.assertJavaDiagnostics(diagnosticsParams, IJDT_UTILS, d2, d1, d3, d4, d5);
        JakartaJavaCodeActionParams codeActionParams = JakartaForJavaAssert.createCodeActionParams(uri, d1);
        TextEdit te = JakartaForJavaAssert.te(23, 1, 24, 1, "");
        TextEdit te1 = JakartaForJavaAssert.te(24, 29, 24, 40, "");
        CodeAction ca = JakartaForJavaAssert.ca(uri, "Remove @PreDestroy", d1, te);
        CodeAction ca1 = JakartaForJavaAssert.ca(uri, "Remove all parameters", d1, te1);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams, IJDT_UTILS, ca, ca1);
        JakartaJavaCodeActionParams codeActionParams1 = JakartaForJavaAssert.createCodeActionParams(uri, d2);
        TextEdit te2 = JakartaForJavaAssert.te(30, 1, 31, 1, "");
        TextEdit te3 = JakartaForJavaAssert.te(31, 7, 31, 14, "");
        CodeAction ca2 = JakartaForJavaAssert.ca(uri, "Remove @PreDestroy", d2, te2);
        CodeAction ca3 = JakartaForJavaAssert.ca(uri, "Remove the 'static' modifier", d2, te3);
        JakartaForJavaAssert.assertJavaCodeAction(codeActionParams1, IJDT_UTILS, ca2, ca3);
    }
}

