/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.cdi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4jakarta.commons.codeaction.ICodeActionId;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4jakarta.jdt.core.java.corrections.proposal.ModifyModifiersProposal;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;

public abstract class RemoveMethodParamAnnotationQuickFix
implements IJavaCodeActionParticipant {
    private static final Logger LOGGER = Logger.getLogger(RemoveMethodParamAnnotationQuickFix.class.getName());
    protected static final String ANNOTATIONS_KEY = "annotations";
    protected static final String PARAMETER_NAME_KEY = "parameter.name";
    String[] annotations;

    public RemoveMethodParamAnnotationQuickFix(String ... annotations) {
        this.annotations = annotations;
    }

    @Override
    public String getParticipantId() {
        return RemoveMethodParamAnnotationQuickFix.class.getName();
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        ASTNode node = context.getCoveredNode();
        MethodDeclaration parentNode = (MethodDeclaration)node.getParent();
        List parameters = parentNode.parameters();
        for (SingleVariableDeclaration parameter : parameters) {
            List modifiers = (List)parameter.getStructuralProperty((StructuralPropertyDescriptor)SingleVariableDeclaration.MODIFIERS2_PROPERTY);
            ArrayList<String> annotationsToRemove = new ArrayList<String>();
            for (ASTNode modifier : modifiers) {
                Name markAnnotationTypeName = ((MarkerAnnotation)modifier).getTypeName();
                if (!Arrays.asList(this.annotations).stream().anyMatch(m -> m.equals(markAnnotationTypeName.toString()))) continue;
                annotationsToRemove.add(markAnnotationTypeName.toString());
            }
            if (annotationsToRemove.size() <= 0) continue;
            this.createCodeAction(diagnostic, context, codeActions, parameter, annotationsToRemove.toArray(new String[annotationsToRemove.size()]));
        }
        return codeActions;
    }

    @Override
    public CodeAction resolveCodeAction(JavaCodeActionResolveContext context) {
        CodeAction toResolve = context.getUnresolved();
        ASTNode node = context.getCoveredNode();
        MethodDeclaration parentNode = (MethodDeclaration)node.getParent();
        IMethodBinding parentMethod = parentNode.resolveBinding();
        CodeActionResolveData data = (CodeActionResolveData)toResolve.getData();
        List annotationsToRemoveList = (List)data.getExtendedDataEntry(ANNOTATIONS_KEY);
        String[] annotationsToRemove = (String[])annotationsToRemoveList.toArray(String[]::new);
        String parameterName = (String)data.getExtendedDataEntry(PARAMETER_NAME_KEY);
        SingleVariableDeclaration parameter = this.matchParameterBinding(parentNode, parameterName);
        if (parameter != null) {
            String label = this.getLabel(parameterName, annotationsToRemove);
            ModifyModifiersProposal proposal = new ModifyModifiersProposal(label, context.getCompilationUnit(), context.getASTRoot(), (IBinding)parentMethod, 0, (ASTNode)parameter, new ArrayList<String>(), Arrays.asList(annotationsToRemove));
            try {
                toResolve.setEdit(context.convertToWorkspaceEdit(proposal));
            }
            catch (CoreException e) {
                LOGGER.log(Level.SEVERE, "Unable to resolve code action to remove annotation", e);
            }
        }
        return toResolve;
    }

    protected void createCodeAction(Diagnostic diagnostic, JavaCodeActionContext context, List<CodeAction> codeActions, SingleVariableDeclaration parameter, String ... annotationsToRemove) throws CoreException {
        String parameterName = parameter.getName().toString();
        String label = this.getLabel(parameterName, annotationsToRemove);
        ExtendedCodeAction codeAction = new ExtendedCodeAction(label);
        codeAction.setRelevance(0);
        codeAction.setKind("quickfix");
        codeAction.setDiagnostics(Arrays.asList(diagnostic));
        HashMap<String, Object> extendedData = new HashMap<String, Object>();
        extendedData.put(ANNOTATIONS_KEY, Arrays.asList(annotationsToRemove));
        extendedData.put(PARAMETER_NAME_KEY, parameterName);
        codeAction.setData(new CodeActionResolveData(context.getUri(), this.getParticipantId(), context.getParams().getRange(), extendedData, context.getParams().isResourceOperationSupported(), context.getParams().isCommandConfigurationUpdateSupported(), this.getCodeActionId()));
        codeActions.add(codeAction);
    }

    private SingleVariableDeclaration matchParameterBinding(MethodDeclaration method, String parameterName) {
        List parameters = method.parameters();
        for (SingleVariableDeclaration parameter : parameters) {
            if (!parameter.getName().toString().equals(parameterName)) continue;
            return parameter;
        }
        return null;
    }

    protected String getLabel(String parameterName, String ... annotationsToRemove) {
        StringBuilder sb = new StringBuilder();
        sb.append("'@").append(annotationsToRemove[0]).append("'");
        int i = 1;
        while (i < annotationsToRemove.length) {
            sb.append(", '@").append(annotationsToRemove[i]).append("'");
            ++i;
        }
        return Messages.getMessage("RemoveTheModifierFromParameter", sb.toString(), parameterName);
    }

    protected IBinding getBinding(ASTNode node) {
        if (node.getParent() instanceof VariableDeclarationFragment) {
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        if (node.getParent() instanceof MethodDeclaration) {
            return ((MethodDeclaration)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }

    protected abstract ICodeActionId getCodeActionId();
}

