/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.core;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ImportContainerInfo;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.DiagnosticsCollector;
import org.eclipse.lsp4jakarta.jdt.core.JDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.JakartaCorePlugin;

public abstract class AbstractDiagnosticsCollector
implements DiagnosticsCollector {
    protected String getDiagnosticSource() {
        return null;
    }

    @Override
    public void completeDiagnostic(Diagnostic diagnostic) {
        this.completeDiagnostic(diagnostic, null, DiagnosticSeverity.Error);
    }

    public void completeDiagnostic(Diagnostic diagnostic, String code) {
        this.completeDiagnostic(diagnostic, code, DiagnosticSeverity.Error);
    }

    public void completeDiagnostic(Diagnostic diagnostic, String code, DiagnosticSeverity severity) {
        String source = this.getDiagnosticSource();
        if (source != null) {
            diagnostic.setSource(source);
        }
        if (code != null) {
            diagnostic.setCode(code);
        }
        diagnostic.setSeverity(severity);
    }

    protected Diagnostic createDiagnostic(IJavaElement el, ICompilationUnit unit, String msg, String code, Object data, DiagnosticSeverity severity) throws JavaModelException {
        String source;
        ISourceRange nameRange = JDTUtils.getNameRange(el);
        Range range = JDTUtils.toRange((IOpenable)unit, nameRange.getOffset(), nameRange.getLength());
        Diagnostic diagnostic = new Diagnostic(range, msg);
        if (data != null) {
            diagnostic.setData(data);
        }
        if ((source = this.getDiagnosticSource()) != null) {
            diagnostic.setSource(source);
        }
        if (code != null) {
            diagnostic.setCode(code);
        }
        diagnostic.setSeverity(severity);
        return diagnostic;
    }

    @Override
    public void collectDiagnostics(ICompilationUnit unit, List<Diagnostic> diagnostics) {
    }

    protected static boolean isMatchedAnnotation(ICompilationUnit unit, IAnnotation annotation, String annotationFQName) throws JavaModelException {
        String elementName = annotation.getElementName();
        if (AbstractDiagnosticsCollector.nameEndsWith(annotationFQName, elementName) && unit != null) {
            if (AbstractDiagnosticsCollector.isImportedJavaElement(unit, annotationFQName)) {
                return true;
            }
            if (annotationFQName.equals(elementName)) {
                String[][] fqName;
                IType declaringType;
                IJavaElement parent = annotation.getParent();
                Object object = parent instanceof IType ? (IType)parent : (declaringType = parent instanceof IMember ? ((IMember)parent).getDeclaringType() : null);
                if (declaringType != null && (fqName = declaringType.resolveType(elementName)) != null && fqName.length == 1) {
                    return annotationFQName.equals(JavaModelUtil.concatenateName((String)fqName[0][0], (String)fqName[0][1]));
                }
            }
        }
        return false;
    }

    protected static boolean isMatchedJavaElement(IType type, String javaElementName, String javaElementFQName) throws JavaModelException {
        if (AbstractDiagnosticsCollector.nameEndsWith(javaElementFQName, javaElementName)) {
            String[][] fqName;
            if (AbstractDiagnosticsCollector.isImportedJavaElement(type.getCompilationUnit(), javaElementFQName)) {
                return true;
            }
            if (javaElementFQName.equals(javaElementName) && (fqName = type.resolveType(javaElementName)) != null && fqName.length == 1) {
                return javaElementFQName.equals(JavaModelUtil.concatenateName((String)fqName[0][0], (String)fqName[0][1]));
            }
        }
        return false;
    }

    protected static boolean isImportedJavaElement(ICompilationUnit unit, String javaElementFQName) throws JavaModelException {
        IJavaElement[] elements;
        IImportContainer container = unit.getImportContainer();
        if (container == null) {
            return false;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo((IJavaElement)container);
        if (info == null) {
            if (manager.getInfo((IJavaElement)unit) != null) {
                return false;
            }
            try {
                unit.open(null);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            info = manager.getInfo((IJavaElement)container);
            if (info == null) {
                return false;
            }
        }
        IJavaElement[] iJavaElementArray = elements = ((ImportContainerInfo)info).getChildren();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String fqn;
            String qualifier;
            IJavaElement child = iJavaElementArray[n2];
            IImportDeclaration importDeclaration = (IImportDeclaration)child;
            if (importDeclaration.isOnDemand() ? (qualifier = (fqn = importDeclaration.getElementName()).substring(0, fqn.lastIndexOf(46))).equals(javaElementFQName.substring(0, javaElementFQName.lastIndexOf(46))) : importDeclaration.getElementName().equals(javaElementFQName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static boolean isImportedJavaElement(ICompilationUnit unit, String[] javaElementFQNames) throws JavaModelException {
        IJavaElement[] elements;
        IImportContainer container = unit.getImportContainer();
        if (container == null) {
            return false;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo((IJavaElement)container);
        if (info == null) {
            if (manager.getInfo((IJavaElement)unit) != null) {
                return false;
            }
            try {
                unit.open(null);
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            info = manager.getInfo((IJavaElement)container);
            if (info == null) {
                return false;
            }
        }
        IJavaElement[] iJavaElementArray = elements = ((ImportContainerInfo)info).getChildren();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement child = iJavaElementArray[n2];
            IImportDeclaration importDeclaration = (IImportDeclaration)child;
            if (importDeclaration.isOnDemand()) {
                String fqn = importDeclaration.getElementName();
                String qualifier = fqn.substring(0, fqn.lastIndexOf(46));
                boolean imports = Stream.of(javaElementFQNames).anyMatch(elementFQName -> qualifier.equals(elementFQName.substring(0, elementFQName.lastIndexOf(46))));
                if (imports) {
                    return true;
                }
            } else {
                String importName = importDeclaration.getElementName();
                if (Stream.of(javaElementFQNames).anyMatch(elementFQName -> importName.equals(elementFQName))) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    protected static boolean doesImplementInterfaces(IType type, String[] interfaceFQNames) throws JavaModelException {
        String[] interfaceNames = type.getSuperInterfaceNames();
        if (interfaceNames.length > 0) {
            IType[] interfaces;
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            IType[] iTypeArray = interfaces = typeHierarchy.getAllInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                IType interfase = iTypeArray[n2];
                String fqName = interfase.getFullyQualifiedName();
                if (Stream.of(interfaceFQNames).anyMatch(name -> fqName.equals(name))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected static String getMatchedJavaElementName(IType type, String javaElementName, String[] javaElementFQNames) throws JavaModelException {
        String[] matches = (String[])Stream.of(javaElementFQNames).filter(fqName -> AbstractDiagnosticsCollector.nameEndsWith(fqName, javaElementName)).toArray(String[]::new);
        if (matches.length > 0 && AbstractDiagnosticsCollector.isMatchedJavaElement(type, javaElementName, matches[0])) {
            return matches[0];
        }
        return null;
    }

    protected static List<String> getMatchedJavaElementNames(IType type, String[] javaElementNames, String[] javaElementFQNames) {
        return Stream.of(javaElementFQNames).filter(fqName -> {
            boolean anyMatch = Stream.of(javaElementNames).anyMatch(name -> {
                try {
                    return AbstractDiagnosticsCollector.isMatchedJavaElement(type, name, fqName);
                }
                catch (JavaModelException e) {
                    JakartaCorePlugin.logException("Failed to get matched Java element FQ names", e);
                    return false;
                }
            });
            return anyMatch;
        }).collect(Collectors.toList());
    }

    protected static boolean nameEndsWith(String fqName, String name) {
        return fqName.equals(name) || fqName.endsWith("." + name);
    }

    protected static String getSimpleName(String fqName) {
        int idx = fqName.lastIndexOf(46);
        if (idx != -1 && idx != fqName.length() - 1) {
            return fqName.substring(idx + 1);
        }
        return fqName;
    }

    protected static boolean isConstructorMethod(IMethod m) {
        try {
            return m.isConstructor();
        }
        catch (JavaModelException e) {
            JakartaCorePlugin.logException("Failed to check constructor method", e);
            return false;
        }
    }
}

