/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.codeAction.proposal.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4jakarta.jdt.codeAction.IJavaCodeActionParticipant;
import org.eclipse.lsp4jakarta.jdt.codeAction.JavaCodeActionContext;
import org.eclipse.lsp4jakarta.jdt.codeAction.proposal.ModifyModifiersProposal;

public class RemoveModifierConflictQuickFix
implements IJavaCodeActionParticipant {
    private final String[] modifiers;
    protected final boolean generateOnlyOneCodeAction;

    public RemoveModifierConflictQuickFix(String ... modifiers) {
        this(false, modifiers);
    }

    public RemoveModifierConflictQuickFix(boolean generateOnlyOneCodeAction, String ... modifiers) {
        this.generateOnlyOneCodeAction = generateOnlyOneCodeAction;
        this.modifiers = modifiers;
    }

    @Override
    public List<? extends CodeAction> getCodeActions(JavaCodeActionContext context, Diagnostic diagnostic, IProgressMonitor monitor) throws CoreException {
        ASTNode node = context.getCoveredNode();
        IBinding parentType = this.getBinding(node);
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        this.removeModifiers(diagnostic, context, parentType, codeActions);
        return codeActions;
    }

    protected void removeModifiers(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions) throws CoreException {
        if (this.generateOnlyOneCodeAction) {
            this.removeModifier(diagnostic, context, parentType, codeActions, this.modifiers);
        } else {
            String[] stringArray = this.modifiers;
            int n = this.modifiers.length;
            int n2 = 0;
            while (n2 < n) {
                String modifier = stringArray[n2];
                this.removeModifier(diagnostic, context, parentType, codeActions, modifier);
                ++n2;
            }
        }
    }

    private void removeModifier(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions, String ... modifier) throws CoreException {
        ASTNode coveredNode = context.getCoveredNode().getParent();
        String type = "";
        if (diagnostic.getData().toString().equals(String.valueOf(14))) {
            type = "variable";
        } else if (diagnostic.getData().toString().equals(String.valueOf(8))) {
            type = "field";
        } else if (diagnostic.getData().toString().equals(String.valueOf(9))) {
            type = "method";
        } else if (diagnostic.getData().toString().equals(String.valueOf(6)) || diagnostic.getData().toString().equals(String.valueOf(7))) {
            type = "class";
        }
        String name = "Remove the '" + modifier[0] + "' modifier from this ";
        name = name.concat(type);
        ModifyModifiersProposal proposal = new ModifyModifiersProposal(name, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, coveredNode, new ArrayList<String>(), Arrays.asList(modifier));
        CodeAction codeAction = context.convertToCodeAction(proposal, diagnostic);
        if (codeAction != null) {
            codeActions.add(codeAction);
        }
    }

    protected void removeModifier(Diagnostic diagnostic, JavaCodeActionContext context, IBinding parentType, List<CodeAction> codeActions, ASTNode coveredNode, String label, String ... modifier) throws CoreException {
        ModifyModifiersProposal proposal = new ModifyModifiersProposal(label, context.getCompilationUnit(), context.getASTRoot(), parentType, 0, coveredNode, new ArrayList<String>(), Arrays.asList(this.modifiers));
        CodeAction codeAction = context.convertToCodeAction(proposal, diagnostic);
        if (codeAction != null) {
            codeActions.add(codeAction);
        }
    }

    protected IBinding getBinding(ASTNode node) {
        node.getParent();
        if (node.getParent() instanceof VariableDeclarationFragment) {
            return ((VariableDeclarationFragment)node.getParent()).resolveBinding();
        }
        if (node.getParent() instanceof MethodDeclaration) {
            return ((MethodDeclaration)node.getParent()).resolveBinding();
        }
        return Bindings.getBindingOfParentType((ASTNode)node);
    }
}

