/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.jsonrpc.ProtocolSince;

@ProtocolSince(value="3.16.0")
public enum SymbolTag {
    Deprecated(1),
    Private(2),
    Package(3),
    Protected(4),
    Public(5),
    Internal(6),
    File(7),
    Static(8),
    Abstract(9),
    Final(10),
    Sealed(11),
    Transient(12),
    Volatile(13),
    Synchronized(14),
    Virtual(15),
    Nullable(16),
    NonNull(17),
    Declaration(18),
    Definition(19),
    ReadOnly(20),
    Overrides(21),
    Implements(22);

    private final int value;

    private SymbolTag(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SymbolTag forValue(int value) {
        SymbolTag[] allValues = SymbolTag.values();
        if (value < 1 || value > allValues.length) {
            throw new IllegalArgumentException("Illegal enum value: " + value);
        }
        return allValues[value - 1];
    }
}

