/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class DocumentDidCloseTest
extends AbstractTestWithProject {
    @Test
    public void testClose() throws Exception {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        IEditorPart editor = TestUtils.openEditor(testFile);
        IDocument document = LSPEclipseUtils.getDocument((IResource)testFile);
        Assertions.assertNotNull((Object)document);
        LanguageServers.forDocument((IDocument)document).anyMatching();
        CompletableFuture didCloseExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidCloseCallback(didCloseExpectation);
        TestUtils.closeEditor(editor, false);
        DidCloseTextDocumentParams lastChange = (DidCloseTextDocumentParams)didCloseExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)lastChange.getTextDocument());
        Assertions.assertEquals((Object)LSPEclipseUtils.toUri((IResource)testFile).toString(), (Object)lastChange.getTextDocument().getUri());
    }

    @Test
    public void testCloseExternalFile(@TempDir Path tempDir) throws Exception {
        Path testFile = Files.createFile(tempDir.resolve("testCloseExternalFile.lspt"), new FileAttribute[0]);
        IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)testFile.toUri()));
        LanguageServers.forDocument((IDocument)LSPEclipseUtils.getDocument((IEditorInput)editor.getEditorInput())).anyMatching();
        CompletableFuture didCloseExpectation = new CompletableFuture();
        MockLanguageServer.INSTANCE.setDidCloseCallback(didCloseExpectation);
        TestUtils.closeEditor(editor, false);
        DidCloseTextDocumentParams lastChange = (DidCloseTextDocumentParams)didCloseExpectation.get(1000L, TimeUnit.MILLISECONDS);
        Assertions.assertNotNull((Object)lastChange.getTextDocument());
        Assertions.assertEquals((Object)LSPEclipseUtils.toUri((File)testFile.toFile()).toString(), (Object)lastChange.getTextDocument().getUri());
    }
}

