/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public final class HumanFriendlyComparator
implements Comparator<String> {
    public static final HumanFriendlyComparator DEFAULT = new HumanFriendlyComparator();
    private final Collator collator;

    public HumanFriendlyComparator() {
        this(Collator.getInstance(Locale.getDefault()));
    }

    public HumanFriendlyComparator(Collator collator) {
        this.collator = collator;
    }

    @Override
    public int compare(String str1, String str2) {
        List<Token> tokens1 = this.tokenize(str1);
        List<Token> tokens2 = this.tokenize(str2);
        int tokenCount1 = tokens1.size();
        int tokenCount2 = tokens2.size();
        int i = 0;
        while (i < tokenCount1 && i < tokenCount2) {
            Token t1 = tokens1.get(i);
            Token t2 = tokens2.get(i);
            if (t1.isNumeric && t2.isNumeric) {
                int cmp = this.compareNumeric(str1, t1, str2, t2);
                if (cmp != 0) {
                    return cmp;
                }
            } else if (!t1.isNumeric && !t2.isNumeric) {
                String sub2;
                String sub1 = str1.substring(t1.start, t1.end);
                int cmp = this.collator.compare(sub1, sub2 = str2.substring(t2.start, t2.end));
                if (cmp != 0) {
                    return cmp;
                }
            } else {
                return t1.isNumeric ? -1 : 1;
            }
            ++i;
        }
        return tokenCount1 - tokenCount2;
    }

    private int compareNumeric(String str1, Token tok1, String str2, Token tok2) {
        int start2;
        int len2;
        int start1 = this.skipLeadingZeros(str1, tok1.start, tok1.end);
        int len1 = tok1.end - start1;
        if (len1 != (len2 = tok2.end - (start2 = this.skipLeadingZeros(str2, tok2.start, tok2.end)))) {
            return len1 - len2;
        }
        int i = 0;
        while (i < len1) {
            char ch2;
            char ch1 = str1.charAt(start1 + i);
            if (ch1 != (ch2 = str2.charAt(start2 + i))) {
                return ch1 - ch2;
            }
            ++i;
        }
        int leadingZeros1 = start1 - tok1.start;
        int leadingZeros2 = start2 - tok2.start;
        return leadingZeros1 - leadingZeros2;
    }

    private int skipLeadingZeros(String str, int start, int end) {
        while (start < end && str.charAt(start) == '0') {
            ++start;
        }
        return start;
    }

    /*
     * Unable to fully structure code
     */
    private List<Token> tokenize(String str) {
        tokens = new ArrayList<Token>();
        len = str.length();
        i = 0;
        while (i < len) {
            start = i;
            if (!this.isDigit(ch = str.charAt(i++))) ** GOTO lbl14
            while (i < len && this.isDigit(str.charAt(i))) {
                ++i;
            }
            tokens.add(new Token(true, start, i));
            continue;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl14:
                // 2 sources

                ** while (i < len && !this.isDigit((char)str.charAt((int)i)))
            }
lbl15:
            // 1 sources

            tokens.add(new Token(false, start, i));
        }
        return tokens;
    }

    private boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static final class Token {
        final boolean isNumeric;
        final int start;
        final int end;

        Token(boolean isNumeric, int start, int end) {
            this.isNumeric = isNumeric;
            this.start = start;
            this.end = end;
        }
    }
}

