/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.internal;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.internal.DocumentUtil;

public final class DocumentOffsetAsyncCache<V> {
    private final Map<IDocument, ConcurrentMap<Integer, Entry<V>>> cache = Collections.synchronizedMap(new WeakHashMap());
    private final Map<IDocument, ConcurrentMap<Integer, CompletableFuture<V>>> inFlight = Collections.synchronizedMap(new WeakHashMap());
    private final long ttlNanos;

    public DocumentOffsetAsyncCache(Duration ttl) {
        this.ttlNanos = TimeUnit.MILLISECONDS.toNanos(ttl.toMillis());
    }

    public CompletableFuture<V> computeIfAbsent(IDocument doc, int offset, Supplier<CompletableFuture<V>> supplier) {
        @Nullable V cachedNow = this.getNow(doc, offset);
        if (cachedNow != null) {
            return CompletableFuture.completedFuture(cachedNow);
        }
        ConcurrentMap byOffset = this.inFlight.computeIfAbsent(doc, d -> new ConcurrentHashMap());
        return byOffset.computeIfAbsent(offset, k -> {
            long startStamp = DocumentUtil.getDocumentModificationStamp(doc);
            CompletableFuture cf = (CompletableFuture)supplier.get();
            cf.whenComplete((v, t) -> {
                byOffset.remove(offset);
                if (t == null && v != null) {
                    long nowStamp = DocumentUtil.getDocumentModificationStamp(doc);
                    if (startStamp == -1L || nowStamp == -1L || nowStamp == startStamp) {
                        this.put(doc, offset, v);
                    }
                }
            });
            return cf;
        });
    }

    public @Nullable V getNow(IDocument doc, int offset) {
        ConcurrentMap<Integer, Entry<V>> byOffset = this.cache.get(doc);
        if (byOffset == null) {
            return null;
        }
        Entry e = (Entry)byOffset.get(offset);
        if (e == null) {
            return null;
        }
        long nowStamp = DocumentUtil.getDocumentModificationStamp(doc);
        if (e.stale(this.ttlNanos, nowStamp)) {
            byOffset.remove(offset, e);
            return null;
        }
        return e.value;
    }

    public void invalidate(IDocument doc) {
        this.cache.remove(doc);
        ConcurrentMap<Integer, CompletableFuture<V>> map = this.inFlight.remove(doc);
        if (map != null) {
            map.values().forEach(f -> {
                boolean bl = f.cancel(true);
            });
        }
    }

    public void put(IDocument doc, int offset, V value) {
        this.cache.compute(doc, (d, byOffset) -> {
            ConcurrentMap map = byOffset != null ? byOffset : new ConcurrentHashMap();
            long stamp = DocumentUtil.getDocumentModificationStamp(doc);
            map.put(offset, new Entry<Object>(value, System.nanoTime(), stamp));
            return map;
        });
    }

    private record Entry<V>(V value, long createdNanos, long docModStamp) {
        boolean stale(long ttlNanos, long currentDocStamp) {
            return System.nanoTime() - this.createdNanos > ttlNanos || this.docModStamp != -1L && currentDocStamp != -1L && this.docModStamp != currentDocStamp;
        }
    }
}

