/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.api.algorithm;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.api.MaxPlusException;
import org.eclipse.lsat.common.ludus.api.MaximumMakespanResult;
import org.eclipse.lsat.common.ludus.api.algorithm.MaxPlusAlgorithm;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.algebra.Value;
import org.eclipse.lsat.common.ludus.backend.algorithms.BellmanFord;
import org.eclipse.lsat.common.ludus.backend.algorithms.CycleCheck;
import org.eclipse.lsat.common.ludus.backend.datastructures.tuple.Tuple;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;
import org.eclipse.lsat.common.ludus.backend.statespace.ComputeStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.MaxPlusStateSpace;
import org.eclipse.lsat.common.ludus.backend.statespace.Transition;
import org.eclipse.lsat.common.mpt.api.UnconnectedResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaximumMakespanAlgorithm
extends MaxPlusAlgorithm {
    private static final Logger LOGGER = LoggerFactory.getLogger(MaximumMakespanAlgorithm.class);

    public static MaximumMakespanResult run(FSM<Location, Edge> fsm, Map<String, Matrix> matrixMap) throws MaxPlusException, UnconnectedResourceException {
        if (CycleCheck.check(fsm)) {
            throw new MaxPlusException("Cannot compute the maximum makespan. Input CIF file contains a cycle.");
        }
        Matrix matrixFirst = matrixMap.values().iterator().next();
        for (Matrix m : matrixMap.values()) {
            if (matrixFirst.getRows() == m.getRows()) continue;
            throw new MaxPlusException("Cannot compute the maximum makespan. Matrices differ in size.");
        }
        MaxPlusStateSpace stateSpace = ComputeStateSpace.computeMaxPlusStateSpace(fsm, matrixFirst.getRows(), matrixMap);
        LOGGER.info("Max-plus state space constructed: " + stateSpace.getVertices().size() + " states and " + stateSpace.getEdges().size() + " edges.");
        stateSpace = ComputeStateSpace.negateWeights(stateSpace);
        Tuple<Value, List<Transition>> result = BellmanFord.runBellmanFord(stateSpace, stateSpace.getInitialConfiguration());
        List<String> listOfEventNames = result.getRight().stream().map(Transition::getEvent).collect(Collectors.toList());
        return new MaximumMakespanResult(result.getLeft().toDouble() * -1.0, listOfEventNames);
    }
}

