/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.diagnostics;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.extensions.relaxng.xml.validator.RelaxNGErrorCode;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.junit.jupiter.api.Test;

public class RelaxNGDiagnosticsWithCatalogTest
extends AbstractCacheBasedTest {
    @Test
    public void incomplete_element_required_element_missing() throws Exception {
        String xml = "<TEI xmlns=\"http://www.tei-c.org/ns/1.0\">\r\n\r\n</TEI>";
        XMLAssert.testDiagnosticsFor(xml, "src/test/resources/relaxng/catalog-relaxng.xml", XMLAssert.d(0, 1, 4, (IXMLErrorCode)RelaxNGErrorCode.incomplete_element_required_element_missing));
    }

    @Test
    public void unknown_element() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<?xml-model href=\"http://canonical-uri/schema.rng\" type=\"application/xml\" schematypens=\"http://relaxng.org/ns/structure/1.0\"?>\r\n<test> \r\n    <valid>I am valid element</valid>\r\n    <invalid>I am invalid b element</invalid>\r\n</test>";
        XMLAssert.testDiagnosticsFor(xml, "src/test/resources/relaxng/catalog-relaxng.xml", XMLAssert.d(4, 5, 12, (IXMLErrorCode)RelaxNGErrorCode.unknown_element));
    }
}

