/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import com.thaiopensource.relaxng.pattern.MySchemaPatternBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLParseException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.relaxng.grammar.rng.RNGXMLReaderCreator;
import org.eclipse.lemminx.extensions.relaxng.jing.SchemaProvider;
import org.eclipse.lemminx.extensions.xerces.ReferencedGrammarDiagnosticsInfo;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RNGValidator {
    private static final Logger LOGGER = Logger.getLogger(RNGValidator.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDiagnostics(DOMDocument document, XMLEntityResolver entityResolver, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, ContentModelManager contentModelManager, CancelChecker monitor) {
        HashMap<String, ReferencedGrammarDiagnosticsInfo> referencedGrammarDiagnosticsInfoCache = new HashMap<String, ReferencedGrammarDiagnosticsInfo>();
        LSPErrorReporterForXML reporterForRNG = new LSPErrorReporterForXML(document, diagnostics, contentModelManager, validationSettings != null ? validationSettings.isRelatedInformation() : false, referencedGrammarDiagnosticsInfoCache);
        try {
            InputSource input = DOMUtils.createInputSource(document);
            RNGXMLReaderCreator creator = new RNGXMLReaderCreator(reporterForRNG);
            SchemaProvider.loadSchema(input, entityResolver, reporterForRNG, new MySchemaPatternBuilder(), creator);
        }
        catch (IncorrectSchemaException | IOException | CancellationException | XMLParseException | SAXException input) {
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected RNG Validator error", e);
        }
        finally {
            reporterForRNG.endReport();
        }
    }
}

