/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.extensions;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.services.DocumentSymbolsResult;
import org.eclipse.lemminx.services.SymbolInformationResult;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.services.extensions.IHoverParticipant;
import org.eclipse.lemminx.services.extensions.IHoverRequest;
import org.eclipse.lemminx.services.extensions.IPrepareRenameRequest;
import org.eclipse.lemminx.services.extensions.IRenameParticipant;
import org.eclipse.lemminx.services.extensions.IRenameRequest;
import org.eclipse.lemminx.services.extensions.ISymbolsProviderParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionResponse;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.services.extensions.format.IFormatterParticipant;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLSymbolFilter;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.jupiter.api.Test;

public class ErrorParticipantLanguageServiceTest
extends AbstractCacheBasedTest {
    @Test
    public void testCodeAction() throws BadLocationException {
        Diagnostic diagnostic = XMLAssert.d(0, 0, 2, (IXMLErrorCode)XMLSyntaxErrorCode.ElementUnterminated);
        XMLAssert.testCodeActionsFor("", diagnostic, (String)null, null, new ErrorParticipantLanguageService(), XMLAssert.ca(diagnostic, XMLAssert.te(0, 0, 0, 0, "a")));
    }

    @Test
    public void testCodeLens() throws BadLocationException {
        XMLAssert.testCodeLensFor("", null, (XMLLanguageService)new ErrorParticipantLanguageService(), ErrorParticipantLanguageService.TEST_CODE_LENS, XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "Bind to grammar/schema...", "xml.open.binding.wizard"));
    }

    @Test
    public void testCompletion() throws BadLocationException {
        XMLAssert.testCompletionFor((XMLLanguageService)new ErrorParticipantLanguageService(), "<|aa bb=\"cc\">dd</aa>", null, a -> {}, null, (Integer)1, new SharedSettings(), ErrorParticipantLanguageService.TEST_COMPLETION_ITEM);
        XMLAssert.testCompletionFor((XMLLanguageService)new ErrorParticipantLanguageService(), "<aa bb=\"cc|\">dd</aa>", null, a -> {}, null, (Integer)1, new SharedSettings(), ErrorParticipantLanguageService.TEST_COMPLETION_ITEM);
        XMLAssert.testCompletionFor((XMLLanguageService)new ErrorParticipantLanguageService(), "<aa bb|=\"cc\">dd</aa>", null, a -> {}, null, (Integer)3, new SharedSettings(), ErrorParticipantLanguageService.TEST_COMPLETION_ITEM, XMLAssert.c("xmlns", "xmlns", XMLAssert.r(0, 4, 0, 6), "xmlns"), XMLAssert.c("xmlns:xsi", "xmlns:xsi", XMLAssert.r(0, 4, 0, 6), "xmlns:xsi"));
        XMLAssert.testCompletionFor((XMLLanguageService)new ErrorParticipantLanguageService(), "<aa bb=\"cc\">dd|</aa>", null, a -> {}, null, (Integer)4, new SharedSettings(), ErrorParticipantLanguageService.TEST_COMPLETION_ITEM);
        XMLAssert.testCompletionFor((XMLLanguageService)new ErrorParticipantLanguageService(), "<!DOCTYPE foo SYSTEM \"./zrb|\">", null, a -> {}, null, (Integer)1, new SharedSettings(), ErrorParticipantLanguageService.TEST_COMPLETION_ITEM);
    }

    @Test
    public void testDefinition() throws BadLocationException {
        XMLAssert.testDefinitionFor(new ErrorParticipantLanguageService(), "a|a", null, ErrorParticipantLanguageService.TEST_LOCATION_LINK);
    }

    @Test
    public void testDiagnostics() throws BadLocationException {
        XMLAssert.testDiagnosticsFor(new ErrorParticipantLanguageService(), "<a", null, a -> {}, null, false, new ContentModelSettings(), ErrorParticipantLanguageService.TEST_DIAGNOSTIC, XMLAssert.d(0, 1, 0, 2, (IXMLErrorCode)XMLSyntaxErrorCode.NoGrammarConstraints, "No grammar constraints (DTD or XML Schema).", "xml", DiagnosticSeverity.Hint), XMLAssert.d(0, 1, 0, 2, (IXMLErrorCode)XMLSyntaxErrorCode.MarkupEntityMismatch, "XML document structures must start and end within the same entity.", "xml", DiagnosticSeverity.Error));
    }

    @Test
    public void testDocLinks() throws BadLocationException {
        XMLAssert.testDocumentLinkFor(new ErrorParticipantLanguageService(), "", null, null, ErrorParticipantLanguageService.TEST_DOCLINK);
    }

    @Test
    public void testFormatting() throws BadLocationException {
        XMLAssert.assertFormat(new ErrorParticipantLanguageService(), " <a b=\"\"></a>", "<a b=\"\"></a>", new SharedSettings(), "test://test.html", false);
    }

    @Test
    public void testHighlight() throws BadLocationException {
        XMLAssert.assertHighlights(new ErrorParticipantLanguageService(), "|a a", new int[]{2}, "a");
    }

    @Test
    public void testHover() throws BadLocationException {
        XMLAssert.assertHover(new ErrorParticipantLanguageService(), "<a|a bb=\"cc\">text</a>", null, null, "contents", XMLAssert.r(0, 0, 0, 2));
        XMLAssert.assertHover(new ErrorParticipantLanguageService(), "<aa b|b=\"cc\">text</a>", null, null, "contents", XMLAssert.r(0, 0, 0, 2));
        XMLAssert.assertHover(new ErrorParticipantLanguageService(), "<aa bb=\"c|c\">text</a>", null, null, "contents", XMLAssert.r(0, 0, 0, 2));
        XMLAssert.assertHover(new ErrorParticipantLanguageService(), "<aa bb=\"cc\">te|xt</a>", null, null, "contents", XMLAssert.r(0, 0, 0, 2));
    }

    @Test
    public void testReferences() throws BadLocationException {
        XMLAssert.testReferencesFor(new ErrorParticipantLanguageService(), "|a", "src/hello", ErrorParticipantLanguageService.TEST_LOCATION);
    }

    @Test
    public void testRename() throws BadLocationException {
        XMLAssert.assertRename(new ErrorParticipantLanguageService(), "<|aa></aa>", "b", Arrays.asList(XMLAssert.te(0, 1, 0, 3, "b"), XMLAssert.te(0, 6, 0, 8, "b")));
    }

    @Test
    public void testSymbols() throws BadLocationException {
        XMLAssert.testSymbolInformationsFor(new ErrorParticipantLanguageService(), "e", null, new XMLSymbolSettings(), a -> {}, ErrorParticipantLanguageService.TEST_SI);
        XMLAssert.testDocumentSymbolsFor(new ErrorParticipantLanguageService(), "e", "src/hello", new XMLSymbolSettings(), a -> {}, ErrorParticipantLanguageService.TEST_DS);
    }

    @Test
    public void testTypeDefinition() throws BadLocationException {
        XMLAssert.testTypeDefinitionFor((XMLLanguageService)new ErrorParticipantLanguageService(), null, a -> {}, "|a", null, ErrorParticipantLanguageService.TEST_LOCATION_LINK);
    }

    static class ErrorParticipantLanguageService
    extends XMLLanguageService {
        public static final CodeLens TEST_CODE_LENS = XMLAssert.cl(XMLAssert.r(0, 0, 0, 0), "a", "a");
        public static final LocationLink TEST_LOCATION_LINK = XMLAssert.ll("src/hello", XMLAssert.r(0, 0, 0, 2), XMLAssert.r(0, 0, 0, 1));
        public static final Diagnostic TEST_DIAGNOSTIC = XMLAssert.d(0, 0, 0, (IXMLErrorCode)XMLSyntaxErrorCode.ElementUnterminated);
        public static final DocumentLink TEST_DOCLINK = XMLAssert.dl(XMLAssert.r(0, 0, 0, 0), "src/hello");
        public static final DocumentHighlight TEST_HIGHLIGHT = XMLAssert.hl(XMLAssert.r(0, 2, 0, 3));
        public static final Hover TEST_HOVER = new Hover(new MarkupContent("markdown", "contents"), XMLAssert.r(0, 0, 0, 2));
        public static final Location TEST_LOCATION = new Location("src/hello", XMLAssert.r(0, 0, 0, 1));
        private static final SymbolInformation TEST_SI = XMLAssert.si("hello", SymbolKind.Array, TEST_LOCATION, "hi");
        protected static final CompletionItem TEST_COMPLETION_ITEM = XMLAssert.c("aaa", "bbb");
        protected static final DocumentSymbol TEST_DS = XMLAssert.ds("hello", SymbolKind.Array, XMLAssert.r(0, 0, 0, 1), XMLAssert.r(0, 0, 0, 1), "detail", Collections.emptyList());

        public ErrorParticipantLanguageService() {
            this.registerCodeActionParticipant((request, codeActions, cancelChecker) -> {
                throw new RuntimeException("This participant is broken");
            });
            this.registerCodeActionParticipant((request, codeActions, cancelChecker) -> {
                Diagnostic diagnostic = request.getDiagnostic();
                codeActions.add(XMLAssert.ca(diagnostic, XMLAssert.te(0, 0, 0, 0, "a")));
            });
            this.registerCodeLensParticipant((request, lenses, cancelChecker) -> {
                throw new RuntimeException("This participant is broken");
            });
            this.registerCodeLensParticipant((request, lenses, cancelChecker) -> lenses.add(TEST_CODE_LENS));
            this.registerCompletionParticipant(new ICompletionParticipant(){

                public void onTagOpen(ICompletionRequest completionRequest, ICompletionResponse completionResponse, CancelChecker cancelChecker) throws Exception {
                    throw new RuntimeException("This participant is broken");
                }

                public void onXMLContent(ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
                    throw new RuntimeException("This participant is broken");
                }

                public void onAttributeName(boolean generateValue, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
                    throw new RuntimeException("This participant is broken");
                }

                public void onAttributeValue(String valuePrefix, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
                    throw new RuntimeException("This participant is broken");
                }

                public void onDTDSystemId(String valuePrefix, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
                    throw new RuntimeException("This participant is broken");
                }
            });
            this.registerCompletionParticipant(new ICompletionParticipant(){

                public void onTagOpen(ICompletionRequest completionRequest, ICompletionResponse completionResponse, CancelChecker cancelChecker) throws Exception {
                    completionResponse.addCompletionAttribute(TEST_COMPLETION_ITEM);
                }

                public void onXMLContent(ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
                    response.addCompletionAttribute(TEST_COMPLETION_ITEM);
                }

                public void onAttributeName(boolean generateValue, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
                    response.addCompletionAttribute(TEST_COMPLETION_ITEM);
                }

                public void onAttributeValue(String valuePrefix, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
                    response.addCompletionAttribute(TEST_COMPLETION_ITEM);
                }

                public void onDTDSystemId(String valuePrefix, ICompletionRequest request, ICompletionResponse response, CancelChecker cancelChecker) throws Exception {
                    response.addCompletionAttribute(TEST_COMPLETION_ITEM);
                }
            });
            this.registerDefinitionParticipant((request, locations, cancelChecker) -> {
                throw new RuntimeException("This participant is broken");
            });
            this.registerDefinitionParticipant((request, locations, cancelChecker) -> locations.add(TEST_LOCATION_LINK));
            this.registerDiagnosticsParticipant((xmlDocument, diagnostics, validationSettings, cancelChecker) -> {
                throw new RuntimeException("This participant is broken");
            });
            this.registerDiagnosticsParticipant((xmlDocument, diagnostics, validationSettings, cancelChecker) -> diagnostics.add(TEST_DIAGNOSTIC));
            this.registerDocumentLinkParticipant((document, links) -> {
                throw new RuntimeException("This participant is broken");
            });
            this.registerDocumentLinkParticipant((document, links) -> links.add(new DocumentLink(TEST_DOCLINK.getRange(), Paths.get(TEST_DOCLINK.getTarget(), new String[0]).toUri().toString())));
            this.registerFormatterParticipant(new IFormatterParticipant(){

                public boolean formatAttributeValue(String name, String valueWithoutQuote, Character quote, DOMAttr attr, XMLBuilder xml) {
                    throw new RuntimeException("This participant is broken");
                }
            });
            this.registerHighlightingParticipant((node, position, offset, highlights, cancelChecker) -> {
                throw new RuntimeException("This participant is broken");
            });
            this.registerHighlightingParticipant((node, position, offset, highlights, cancelChecker) -> highlights.add(TEST_HIGHLIGHT));
            this.registerHoverParticipant(new IHoverParticipant(){

                public Hover onTag(IHoverRequest request) throws Exception {
                    throw new RuntimeException("This participant is broken");
                }

                public Hover onAttributeName(IHoverRequest request) throws Exception {
                    throw new RuntimeException("This participant is broken");
                }

                public Hover onAttributeValue(IHoverRequest request) throws Exception {
                    throw new RuntimeException("This participant is broken");
                }

                public Hover onText(IHoverRequest request) throws Exception {
                    throw new RuntimeException("This participant is broken");
                }
            });
            this.registerHoverParticipant(new IHoverParticipant(){

                public Hover onTag(IHoverRequest request) throws Exception {
                    return TEST_HOVER;
                }

                public Hover onAttributeName(IHoverRequest request) throws Exception {
                    return TEST_HOVER;
                }

                public Hover onAttributeValue(IHoverRequest request) throws Exception {
                    return TEST_HOVER;
                }

                public Hover onText(IHoverRequest request) throws Exception {
                    return TEST_HOVER;
                }
            });
            this.registerReferenceParticipant((document, position, context, locations, cancelChecker) -> {
                throw new RuntimeException("This participant is broken");
            });
            this.registerReferenceParticipant((document, position, context, locations, cancelChecker) -> locations.add(TEST_LOCATION));
            this.registerRenameParticipant(new IRenameParticipant(){

                public Either<Range, PrepareRenameResult> prepareRename(IPrepareRenameRequest request, CancelChecker cancelChecker) {
                    return null;
                }

                public void doRename(IRenameRequest request, List<TextEdit> locations, CancelChecker cancelChecker) {
                    throw new RuntimeException("This participant is broken");
                }
            });
            this.registerSymbolsProviderParticipant(new ISymbolsProviderParticipant(){

                public ISymbolsProviderParticipant.SymbolStrategy applyFor(DOMDocument document) {
                    return ISymbolsProviderParticipant.SymbolStrategy.INSERT;
                }

                public void findSymbolInformations(DOMDocument document, SymbolInformationResult symbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
                    throw new RuntimeException("This participant is broken");
                }

                public void findDocumentSymbols(DOMDocument document, DocumentSymbolsResult symbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
                    throw new RuntimeException("This participant is broken");
                }
            });
            this.registerSymbolsProviderParticipant(new ISymbolsProviderParticipant(){

                public ISymbolsProviderParticipant.SymbolStrategy applyFor(DOMDocument document) {
                    return ISymbolsProviderParticipant.SymbolStrategy.INSERT;
                }

                public void findSymbolInformations(DOMDocument document, SymbolInformationResult symbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
                    symbols.add((Object)TEST_SI);
                }

                public void findDocumentSymbols(DOMDocument document, DocumentSymbolsResult symbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
                    symbols.add((Object)TEST_DS);
                }
            });
            this.registerSymbolsProviderParticipant(new ISymbolsProviderParticipant(){

                public ISymbolsProviderParticipant.SymbolStrategy applyFor(DOMDocument document) {
                    return ISymbolsProviderParticipant.SymbolStrategy.REPLACE;
                }

                public void findSymbolInformations(DOMDocument document, SymbolInformationResult symbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
                    throw new RuntimeException("This participant is broken");
                }

                public void findDocumentSymbols(DOMDocument document, DocumentSymbolsResult symbols, XMLSymbolFilter filter, CancelChecker cancelChecker) {
                    throw new RuntimeException("This participant is broken");
                }
            });
            this.registerTypeDefinitionParticipant((request, locations, cancelChecker) -> {
                throw new RuntimeException("This participant is broken");
            });
            this.registerTypeDefinitionParticipant((request, locations, cancelChecker) -> locations.add(TEST_LOCATION_LINK));
        }
    }
}

