/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.lemminx.client.InvalidPathWarner;
import org.eclipse.lemminx.client.PathFeature;
import org.eclipse.lemminx.services.AbstractNotifierTest;
import org.eclipse.lemminx.services.IXMLNotificationService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InvalidPathWarnerTest
extends AbstractNotifierTest {
    private static final String catalog1 = "catalog.xml";
    private static final String catalog2 = "catalog2.xml";
    private static final PathFeature TEST_FEATURE = PathFeature.CATALOGS;
    private InvalidPathWarner pathWarner;

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.pathWarner = new InvalidPathWarner((IXMLNotificationService)this.languageServer);
    }

    @Test
    public void testSendActionableNotification() {
        this.setSupportCapabilities(true, true);
        this.sendNotification(catalog1);
        this.assertCounts(1, 0);
    }

    @Test
    public void testSendActionableNotificationWarningText() {
        this.setSupportCapabilities(true, true);
        this.sendNotification(catalog1);
        this.assertLastActionableNotificationMessage("Invalid path for setting 'xml.catalogs': 'catalog.xml'");
        this.sendNotification(catalog1, catalog2);
        this.assertLastActionableNotificationMessage("Invalid paths for setting 'xml.catalogs': 'catalog.xml', 'catalog2.xml'");
    }

    @Test
    public void testSendActionableNotificationCache() {
        this.setSupportCapabilities(true, true);
        this.sendNotification(catalog1);
        this.assertCounts(1, 0);
        this.sendNotification(catalog1);
        this.assertCounts(1, 0);
        this.sendNotification(catalog2);
        this.assertCounts(2, 0);
        this.sendNotification(catalog2);
        this.assertCounts(2, 0);
        this.sendNotification(catalog1);
        this.assertCounts(3, 0);
        this.sendNotification(catalog1);
        this.assertCounts(3, 0);
    }

    @Test
    public void testActionableNotificationEvict() {
        this.setSupportCapabilities(true, true);
        this.sendNotification(catalog1);
        this.assertCounts(1, 0);
        this.pathWarner.evictValue(catalog1);
        this.sendNotification(catalog1);
        this.assertCounts(2, 0);
        this.sendNotification(catalog1);
        this.assertCounts(2, 0);
    }

    @Test
    public void testSendMessage() {
        this.setSupportCapabilities(false, false);
        this.sendNotification(catalog1);
        this.assertCounts(0, 1);
    }

    @Test
    public void testSendMessage2() {
        this.setSupportCapabilities(true, false);
        this.sendNotification(catalog1);
        this.assertCounts(0, 1);
    }

    @Test
    public void testSendMessage3() {
        this.setSupportCapabilities(false, true);
        this.sendNotification(catalog1);
        this.assertCounts(0, 1);
    }

    @Test
    public void testSendMessageWarningText() {
        this.setSupportCapabilities(false, false);
        this.sendNotification(catalog1);
        this.assertLastShowMessage("Invalid path for setting 'xml.catalogs': 'catalog.xml'");
        this.sendNotification(catalog1, catalog2);
        this.assertLastShowMessage("Invalid paths for setting 'xml.catalogs': 'catalog.xml', 'catalog2.xml'");
    }

    @Test
    public void testSendMessageCache() {
        this.setSupportCapabilities(false, false);
        this.sendNotification(catalog1);
        this.assertCounts(0, 1);
        this.sendNotification(catalog1);
        this.assertCounts(0, 1);
        this.sendNotification(catalog2);
        this.assertCounts(0, 2);
        this.sendNotification(catalog2);
        this.assertCounts(0, 2);
        this.sendNotification(catalog1);
        this.assertCounts(0, 3);
        this.sendNotification(catalog1);
        this.assertCounts(0, 3);
    }

    @Test
    public void testSendMessageEvict() {
        this.setSupportCapabilities(false, false);
        this.sendNotification(catalog1);
        this.assertCounts(0, 1);
        this.pathWarner.evictValue(catalog1);
        this.sendNotification(catalog1);
        this.assertCounts(0, 2);
        this.sendNotification(catalog1);
        this.assertCounts(0, 2);
    }

    private void sendNotification(String ... invalidPaths) {
        this.pathWarner.onInvalidFilePath(new LinkedHashSet<String>(Arrays.asList(invalidPaths)), TEST_FEATURE);
    }
}

