/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.services.format.XMLFormatterDocumentNew;
import org.eclipse.lemminx.services.format.XMLFormattingConstraints;
import org.eclipse.lsp4j.TextEdit;

public class DOMAttributeFormatter {
    private final XMLFormatterDocumentNew formatterDocument;

    public DOMAttributeFormatter(XMLFormatterDocumentNew formatterDocument) {
        this.formatterDocument = formatterDocument;
    }

    public void formatAttribute(DOMAttr attr, int prevOffset, boolean singleAttribute, boolean useSettings, XMLFormattingConstraints parentConstraints, List<TextEdit> edits) {
        boolean alreadyIndented = false;
        if (useSettings) {
            int indentLevel = parentConstraints.getIndentLevel();
            if (this.isPreserveAttributeLineBreaks() && this.hasLineBreak(prevOffset, attr.getStart())) {
                this.replaceLeftSpacesWithIndentation(indentLevel + 1, attr.getStart(), true, edits);
                alreadyIndented = true;
            } else if (this.isSplitAttributes() && !singleAttribute) {
                this.replaceLeftSpacesWithIndentation(indentLevel + this.getSplitAttributesIndentSize(), attr.getStart(), true, edits);
                alreadyIndented = true;
            }
        }
        if (!alreadyIndented) {
            int from = prevOffset;
            int to = attr.getStart();
            this.replaceLeftSpacesWithOneSpace(from, to, edits);
        }
        if (attr.hasDelimiter()) {
            int delimiterOffset = attr.getDelimiterOffset();
            int attrNameEnd = attr.getNodeAttrName().getEnd();
            this.removeLeftSpaces(attrNameEnd, delimiterOffset, edits);
            if (attr.getNodeAttrValue() != null) {
                int attrValueStart = attr.getNodeAttrValue().getStart();
                this.removeLeftSpaces(delimiterOffset, attrValueStart, edits);
            }
        }
    }

    private void replaceLeftSpacesWithOneSpace(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWithOneSpace(from, to, edits);
    }

    private void replaceLeftSpacesWithIndentation(int indentLevel, int offset, boolean addLineSeparator, List<TextEdit> edits) {
        this.formatterDocument.replaceLeftSpacesWithIndentation(indentLevel, offset, addLineSeparator, edits);
    }

    private void removeLeftSpaces(int from, int to, List<TextEdit> edits) {
        this.formatterDocument.removeLeftSpaces(from, to, edits);
    }

    private boolean isSplitAttributes() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isSplitAttributes();
    }

    private int getSplitAttributesIndentSize() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().getSplitAttributesIndentSize();
    }

    boolean isPreserveAttributeLineBreaks() {
        return this.formatterDocument.getSharedSettings().getFormattingSettings().isPreserveAttributeLineBreaks();
    }

    private boolean hasLineBreak(int prevOffset, int start) {
        return this.formatterDocument.hasLineBreak(prevOffset, start);
    }
}

