/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.dom;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMParser;
import org.eclipse.lemminx.dom.DOMText;
import org.eclipse.lemminx.dom.DTDAttlistDecl;
import org.eclipse.lemminx.dom.DTDElementDecl;
import org.eclipse.lemminx.dom.DTDEntityDecl;
import org.eclipse.lemminx.dom.DTDNotationDecl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DOMParserForInternalDTDTest {
    @Test
    public void onlyDocTypeNotClosed() {
        String xml = "<!DOCTYPE ";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)10, (int)documentType.getEnd());
        Assertions.assertNull((Object)documentType.getName());
        Assertions.assertFalse((boolean)documentType.isClosed());
        Assertions.assertEquals((int)0, (int)documentType.getChildren().size());
    }

    @Test
    public void docTypeWithNameNotClosed() {
        String xml = "<!DOCTYPE foo";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)13, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertFalse((boolean)documentType.isClosed());
        Assertions.assertEquals((int)0, (int)documentType.getChildren().size());
    }

    @Test
    public void docTypeWithStartInternalSubsetNotClosed() {
        String xml = "<!DOCTYPE foo [";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)15, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertFalse((boolean)documentType.isClosed());
        Assertions.assertEquals((int)0, (int)documentType.getChildren().size());
    }

    @Test
    public void docTypeWithStartInternalSubsetTextNotClosed() {
        String xml = "<!DOCTYPE foo [aaa";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)18, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertFalse((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isText());
        DOMText text = (DOMText)documentType.getChild(0);
        Assertions.assertEquals((Object)"aaa", (Object)text.getTextContent());
    }

    @Test
    public void docTypeNotClosedAndElement() {
        String xml = "<!DOCTYPE foo []<foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)16, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)actual.getChild(1).isClosed());
    }

    @Test
    public void docTypeClosedEmptySubsetContentAndElement() {
        String xml = "<!DOCTYPE foo []><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)17, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void docTypeClosedNoSubsetContentAndElement() {
        String xml = "<!DOCTYPE foo ><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)15, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void docTypeClosedWithBadContentAndElement() {
        String xml = "<!DOCTYPE foo [aaaa]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)21, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void elementDeclNotClosed() {
        String xml = "<!DOCTYPE foo [<!ELEMENT]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)26, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDElementDecl());
        DTDElementDecl elementDecl = (DTDElementDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)elementDecl.getStart());
        Assertions.assertEquals((int)23, (int)elementDecl.getEnd());
        Assertions.assertFalse((boolean)elementDecl.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void elementDeclWithNameNotClosed() {
        String xml = "<!DOCTYPE foo [<!ELEMENT a]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)28, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDElementDecl());
        DTDElementDecl elementDecl = (DTDElementDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)elementDecl.getStart());
        Assertions.assertEquals((int)25, (int)elementDecl.getEnd());
        Assertions.assertFalse((boolean)elementDecl.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void elementDeclClosed() {
        String xml = "<!DOCTYPE foo [<!ELEMENT >]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)28, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDElementDecl());
        DTDElementDecl elementDecl = (DTDElementDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)elementDecl.getStart());
        Assertions.assertEquals((int)26, (int)elementDecl.getEnd());
        Assertions.assertTrue((boolean)elementDecl.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void elementDeclWithNameClosed() {
        String xml = "<!DOCTYPE foo [<!ELEMENT a >]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)30, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDElementDecl());
        DTDElementDecl elementDecl = (DTDElementDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)elementDecl.getStart());
        Assertions.assertEquals((int)28, (int)elementDecl.getEnd());
        Assertions.assertTrue((boolean)elementDecl.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void elementDeclClosedWithBraces() {
        String xml = "<!DOCTYPE error-page [<!ELEMENT error-page ((error-code | exception-type), location)>]><error-page/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)87, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"error-page", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDElementDecl());
        DTDElementDecl elementDecl = (DTDElementDecl)documentType.getChild(0);
        Assertions.assertEquals((int)22, (int)elementDecl.getStart());
        Assertions.assertEquals((int)85, (int)elementDecl.getEnd());
        Assertions.assertTrue((boolean)elementDecl.isClosed());
        Assertions.assertEquals((Object)"error-page", (Object)elementDecl.getName());
        Assertions.assertEquals((Object)"((error-code | exception-type), location)", (Object)elementDecl.getContent());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void elementDeclNotClosedWithBraces() {
        String xml = "<!DOCTYPE error-page [<!ELEMENT error-page ((error-code | exception-type), location)]><error-page/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)86, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"error-page", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDElementDecl());
        DTDElementDecl elementDecl = (DTDElementDecl)documentType.getChild(0);
        Assertions.assertEquals((int)22, (int)elementDecl.getStart());
        Assertions.assertEquals((int)83, (int)elementDecl.getEnd());
        Assertions.assertEquals((Object)"error-page", (Object)elementDecl.getName());
        Assertions.assertEquals((Object)"((error-code | exception-type), location)", (Object)elementDecl.getContent());
        Assertions.assertFalse((boolean)elementDecl.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void attListDeclNotClosed() {
        String xml = "<!DOCTYPE foo [<!ATTLIST]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)26, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDAttListDecl());
        DTDAttlistDecl attListDecl = (DTDAttlistDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)attListDecl.getStart());
        Assertions.assertEquals((int)23, (int)attListDecl.getEnd());
        Assertions.assertFalse((boolean)attListDecl.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void attListDeclClosed() {
        String xml = "<!DOCTYPE foo [<!ATTLIST >]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)28, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDAttListDecl());
        DTDAttlistDecl attListDecl = (DTDAttlistDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)attListDecl.getStart());
        Assertions.assertEquals((int)26, (int)attListDecl.getEnd());
        Assertions.assertTrue((boolean)attListDecl.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void attListDeclWithNameClosed() {
        String xml = "<!DOCTYPE foo [<!ATTLIST a >]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)30, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDAttListDecl());
        DTDAttlistDecl attListDecl = (DTDAttlistDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)attListDecl.getStart());
        Assertions.assertEquals((int)28, (int)attListDecl.getEnd());
        Assertions.assertTrue((boolean)attListDecl.isClosed());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void entityDeclNotClosed() {
        String xml = "<!DOCTYPE foo [<!ENTITY]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)25, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDEntityDecl());
        DTDEntityDecl entityDecl = (DTDEntityDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)entityDecl.getStart());
        Assertions.assertEquals((int)22, (int)entityDecl.getEnd());
        Assertions.assertFalse((boolean)entityDecl.isClosed());
        Assertions.assertNull((Object)entityDecl.getNodeName());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void entityDeclWithNameNotClosed() {
        String xml = "<!DOCTYPE foo [<!ENTITY a]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)27, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDEntityDecl());
        DTDEntityDecl entityDecl = (DTDEntityDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)entityDecl.getStart());
        Assertions.assertEquals((int)24, (int)entityDecl.getEnd());
        Assertions.assertFalse((boolean)entityDecl.isClosed());
        Assertions.assertEquals((Object)"a", (Object)entityDecl.getNodeName());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void entityDeclClosed() {
        String xml = "<!DOCTYPE foo [<!ENTITY >]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)27, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDEntityDecl());
        DTDEntityDecl entityDecl = (DTDEntityDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)entityDecl.getStart());
        Assertions.assertEquals((int)25, (int)entityDecl.getEnd());
        Assertions.assertTrue((boolean)entityDecl.isClosed());
        Assertions.assertNull((Object)entityDecl.getNodeName());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void entityDeclWithNameClosed() {
        String xml = "<!DOCTYPE foo [<!ENTITY a >]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)29, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDEntityDecl());
        DTDEntityDecl entityDecl = (DTDEntityDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)entityDecl.getStart());
        Assertions.assertEquals((int)27, (int)entityDecl.getEnd());
        Assertions.assertTrue((boolean)entityDecl.isClosed());
        Assertions.assertEquals((Object)"a", (Object)entityDecl.getNodeName());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void entityDeclWithNameClosedAndParameters() {
        String xml = "<!DOCTYPE foo [<!ENTITY % eName PUBLIC \"publicId\" \"systemId\" >]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)64, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDEntityDecl());
        DTDEntityDecl entityDecl = (DTDEntityDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)entityDecl.getStart());
        Assertions.assertEquals((int)62, (int)entityDecl.getEnd());
        Assertions.assertTrue((boolean)entityDecl.isClosed());
        Assertions.assertEquals((Object)"%", (Object)entityDecl.getPercent());
        Assertions.assertEquals((Object)"eName", (Object)entityDecl.getNodeName());
        Assertions.assertEquals((Object)"PUBLIC", (Object)entityDecl.getKind());
        Assertions.assertEquals((Object)"publicId", (Object)entityDecl.getPublicId());
        Assertions.assertEquals((Object)"systemId", (Object)entityDecl.getSystemId());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void entityDeclWithNameClosedAndSomeParameters() {
        String xml = "<!DOCTYPE foo [<!ENTITY % eName PUBLIC \"publicId\" >]><foo/>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(xml);
        Assertions.assertEquals((int)2, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)53, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDEntityDecl());
        DTDEntityDecl entityDecl = (DTDEntityDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)entityDecl.getStart());
        Assertions.assertEquals((int)51, (int)entityDecl.getEnd());
        Assertions.assertTrue((boolean)entityDecl.isClosed());
        Assertions.assertEquals((Object)"%", (Object)entityDecl.getPercent());
        Assertions.assertEquals((Object)"eName", (Object)entityDecl.getNodeName());
        Assertions.assertEquals((Object)"PUBLIC", (Object)entityDecl.getKind());
        Assertions.assertEquals((Object)"publicId", (Object)entityDecl.getPublicId());
        Assertions.assertEquals(null, (Object)entityDecl.getSystemId());
        Assertions.assertTrue((boolean)actual.getChild(1).isElement());
    }

    @Test
    public void attlistWithMultipleInternalDeclarations() {
        String dtd = "<!DOCTYPE foo [<!ATTLIST Institution\n    to CDATA #REQUIRED\n    from CDATA #REQUIRED>]\n>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(dtd);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)88, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDAttListDecl());
        DTDAttlistDecl attlistDecl = (DTDAttlistDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)attlistDecl.getStart());
        Assertions.assertEquals((int)85, (int)attlistDecl.getEnd());
        Assertions.assertEquals((Object)"Institution", (Object)attlistDecl.getElementName());
        Assertions.assertEquals((Object)"to", (Object)attlistDecl.getAttributeName());
        Assertions.assertEquals((Object)"CDATA", (Object)attlistDecl.getAttributeType());
        Assertions.assertEquals((Object)"#REQUIRED", (Object)attlistDecl.getAttributeValue());
        Assertions.assertNotNull((Object)attlistDecl.getInternalChildren());
        Assertions.assertEquals((int)1, (int)attlistDecl.getInternalChildren().size());
        DTDAttlistDecl internalDecl = (DTDAttlistDecl)attlistDecl.getInternalChildren().get(0);
        Assertions.assertEquals((Object)"from", (Object)internalDecl.getAttributeName());
        Assertions.assertEquals((Object)"CDATA", (Object)internalDecl.getAttributeType());
        Assertions.assertEquals((Object)"#REQUIRED", (Object)internalDecl.getAttributeValue());
    }

    @Test
    public void attlistWithMultipleInternalDeclarationsMissingInformation() {
        String dtd = "<!DOCTYPE foo [<!ATTLIST Institution\n    to CDATA \n    from CDATA #REQUIRED>]\n>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(dtd);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)79, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDAttListDecl());
        DTDAttlistDecl attlistDecl = (DTDAttlistDecl)documentType.getChild(0);
        Assertions.assertEquals((int)15, (int)attlistDecl.getStart());
        Assertions.assertEquals((int)76, (int)attlistDecl.getEnd());
        Assertions.assertEquals((Object)"Institution", (Object)attlistDecl.getElementName());
        Assertions.assertEquals((Object)"to", (Object)attlistDecl.getAttributeName());
        Assertions.assertEquals((Object)"CDATA", (Object)attlistDecl.getAttributeType());
        Assertions.assertEquals(null, (Object)attlistDecl.getAttributeValue());
        Assertions.assertEquals((int)55, (int)attlistDecl.unrecognized.start);
        Assertions.assertEquals((int)75, (int)attlistDecl.unrecognized.end);
    }

    @Test
    public void elementWithContent() {
        String dtd = "<!DOCTYPE foo [\n    <!ELEMENT elName (aa1,bb2,cc3) \n    ]\n>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(dtd);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)59, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDElementDecl());
        DTDElementDecl elementDecl = (DTDElementDecl)documentType.getChild(0);
        Assertions.assertEquals((int)20, (int)elementDecl.getStart());
        Assertions.assertEquals((int)55, (int)elementDecl.getEnd());
        Assertions.assertEquals((Object)"elName", (Object)elementDecl.getName());
        Assertions.assertEquals((Object)"(aa1,bb2,cc3)", (Object)elementDecl.getContent());
        Assertions.assertEquals(null, (Object)elementDecl.getCategory());
        Assertions.assertFalse((boolean)elementDecl.isClosed());
    }

    @Test
    public void allDeclsUnclosed() {
        String dtd = "<!DOCTYPE foo [ <!ELEMENT   <!ATTLIST elName <!ENTITY garbage   <!NOTATION garbage  ]>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(dtd);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)86, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)4, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDElementDecl());
        Assertions.assertTrue((boolean)documentType.getChild(1).isDTDAttListDecl());
        Assertions.assertTrue((boolean)documentType.getChild(2).isDTDEntityDecl());
        Assertions.assertTrue((boolean)documentType.getChild(3).isDTDNotationDecl());
        DTDElementDecl elementDecl = (DTDElementDecl)documentType.getChild(0);
        Assertions.assertEquals((int)16, (int)elementDecl.getStart());
        Assertions.assertEquals((int)28, (int)elementDecl.getEnd());
        Assertions.assertEquals(null, (Object)elementDecl.getName());
        Assertions.assertEquals(null, (Object)elementDecl.getContent());
        Assertions.assertEquals(null, (Object)elementDecl.getCategory());
        Assertions.assertFalse((boolean)elementDecl.isClosed());
        DTDAttlistDecl attlistDecl = (DTDAttlistDecl)documentType.getChild(1);
        Assertions.assertEquals((int)28, (int)attlistDecl.getStart());
        Assertions.assertEquals((int)45, (int)attlistDecl.getEnd());
        Assertions.assertEquals((Object)"elName", (Object)attlistDecl.getElementName());
        Assertions.assertFalse((boolean)attlistDecl.isClosed());
        DTDEntityDecl entityDecl = (DTDEntityDecl)documentType.getChild(2);
        Assertions.assertEquals((int)45, (int)entityDecl.getStart());
        Assertions.assertEquals((int)64, (int)entityDecl.getEnd());
        Assertions.assertEquals((Object)"garbage", (Object)entityDecl.getNodeName());
        Assertions.assertFalse((boolean)entityDecl.isClosed());
        DTDNotationDecl notationDecl = (DTDNotationDecl)documentType.getChild(3);
        Assertions.assertEquals((int)64, (int)notationDecl.getStart());
        Assertions.assertEquals((int)83, (int)notationDecl.getEnd());
        Assertions.assertEquals((Object)"garbage", (Object)notationDecl.getName());
        Assertions.assertFalse((boolean)notationDecl.isClosed());
    }

    @Test
    public void dtdUnrecognizedContent() {
        String dtd = "<!DOCTYPE foo [\n    <!ELEMENT elName (aa1,bb2,cc3) BAD UNRECOGNIZED CONTENT> \n    ]\n>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(dtd);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)85, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDElementDecl());
        DTDElementDecl elementDecl = (DTDElementDecl)documentType.getChild(0);
        Assertions.assertEquals((int)20, (int)elementDecl.getStart());
        Assertions.assertEquals((int)76, (int)elementDecl.getEnd());
        Assertions.assertEquals((Object)"elName", (Object)elementDecl.getName());
        Assertions.assertEquals((Object)"(aa1,bb2,cc3)", (Object)elementDecl.getContent());
        Assertions.assertEquals(null, (Object)elementDecl.getCategory());
        Assertions.assertEquals((int)51, (int)elementDecl.unrecognized.start);
        Assertions.assertEquals((int)75, (int)elementDecl.unrecognized.end);
        Assertions.assertTrue((boolean)elementDecl.isClosed());
    }

    @Test
    public void dtdNotationComplete() {
        String dtd = "<!DOCTYPE foo [\n    <!NOTATION Name PUBLIC \"PublicID\" \"SystemID\"> \n    ]\n>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(dtd);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)74, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDNotationDecl());
        DTDNotationDecl elementDecl = (DTDNotationDecl)documentType.getChild(0);
        Assertions.assertEquals((int)20, (int)elementDecl.getStart());
        Assertions.assertEquals((int)65, (int)elementDecl.getEnd());
        Assertions.assertEquals((Object)"Name", (Object)elementDecl.getName());
        Assertions.assertEquals((Object)"PUBLIC", (Object)elementDecl.getKind());
        Assertions.assertEquals((Object)"PublicID", (Object)elementDecl.getPublicId());
        Assertions.assertEquals((Object)"SystemID", (Object)elementDecl.getSystemId());
        Assertions.assertTrue((boolean)elementDecl.isClosed());
    }

    @Test
    public void dtdNotationSYSTEMUnrecognizedParameter() {
        String dtd = "<!DOCTYPE foo [\n    <!NOTATION Name SYSTEM \"PublicID\" \"SystemID\"> \n    ]\n>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(dtd);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)74, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertTrue((boolean)documentType.isClosed());
        Assertions.assertEquals((int)1, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)documentType.getChild(0).isDTDNotationDecl());
        DTDNotationDecl elementDecl = (DTDNotationDecl)documentType.getChild(0);
        Assertions.assertEquals((int)20, (int)elementDecl.getStart());
        Assertions.assertEquals((int)65, (int)elementDecl.getEnd());
        Assertions.assertEquals((Object)"Name", (Object)elementDecl.getName());
        Assertions.assertEquals((Object)"SYSTEM", (Object)elementDecl.getKind());
        Assertions.assertEquals((Object)"PublicID", (Object)elementDecl.getSystemId());
        Assertions.assertEquals((Object)"\"SystemID\"", (Object)elementDecl.getUnrecognized());
        Assertions.assertTrue((boolean)elementDecl.isClosed());
    }

    @Test
    public void testDoctypeUnrecognizedContent() {
        String dtd = "<!DOCTYPE foo BAD_VALUE [\n    <!NOTATION Name SYSTEM \"PublicID\" \"SystemID\"> \n    ]\n>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(dtd);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)0, (int)documentType.getStart());
        Assertions.assertEquals((int)84, (int)documentType.getEnd());
        Assertions.assertEquals((Object)"foo", (Object)documentType.getName());
        Assertions.assertEquals((int)14, (int)documentType.unrecognized.start);
        Assertions.assertEquals((int)82, (int)documentType.unrecognized.end);
        Assertions.assertTrue((boolean)documentType.isClosed());
    }

    @Test
    public void testAttlistUncompletedInternalDecl() {
        String dtd = "<!DOCTYPE foo [\n    <!ATTLIST payment type CDATA \"check\" BAD \n    <!NOTATION Name SYSTEM \"PublicID\" \"SystemID\"> \n    ]\n>";
        DOMDocument actual = DOMParserForInternalDTDTest.createDOMDocument(dtd);
        Assertions.assertEquals((int)1, (int)actual.getChildren().size());
        Assertions.assertTrue((boolean)actual.getChild(0).isDoctype());
        DOMDocumentType documentType = (DOMDocumentType)actual.getChild(0);
        Assertions.assertEquals((int)2, (int)documentType.getChildren().size());
        Assertions.assertTrue((boolean)(documentType.getChild(0) instanceof DTDAttlistDecl));
        Assertions.assertTrue((boolean)(documentType.getChild(1) instanceof DTDNotationDecl));
    }

    private static DOMDocument createDOMDocument(String xml) {
        return DOMParser.getInstance().parse(xml, "uri", null);
    }
}

