/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.lemminx.XMLTextDocumentService;
import org.eclipse.lemminx.XMLWorkspaceService;
import org.eclipse.lemminx.client.ExtendedClientCapabilities;
import org.eclipse.lemminx.commons.ModelTextDocument;
import org.eclipse.lemminx.commons.ParentProcessWatcher;
import org.eclipse.lemminx.customservice.ActionableNotification;
import org.eclipse.lemminx.customservice.AutoCloseTagResponse;
import org.eclipse.lemminx.customservice.XMLLanguageClientAPI;
import org.eclipse.lemminx.customservice.XMLLanguageServerAPI;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.settings.ContentModelSettings;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.logs.LogHelper;
import org.eclipse.lemminx.services.IXMLDocumentProvider;
import org.eclipse.lemminx.services.IXMLNotificationService;
import org.eclipse.lemminx.services.IXMLValidationService;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.eclipse.lemminx.settings.AllXMLSettings;
import org.eclipse.lemminx.settings.InitializationOptionsSettings;
import org.eclipse.lemminx.settings.ServerSettings;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLCodeLensSettings;
import org.eclipse.lemminx.settings.XMLCompletionSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.settings.XMLGeneralClientSettings;
import org.eclipse.lemminx.settings.XMLPreferences;
import org.eclipse.lemminx.settings.XMLSymbolSettings;
import org.eclipse.lemminx.settings.XMLTelemetrySettings;
import org.eclipse.lemminx.settings.capabilities.InitializationOptionsExtendedClientCapabilities;
import org.eclipse.lemminx.settings.capabilities.ServerCapabilitiesInitializer;
import org.eclipse.lemminx.settings.capabilities.XMLCapabilityManager;
import org.eclipse.lemminx.telemetry.TelemetryManager;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.platform.Platform;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class XMLLanguageServer
implements ParentProcessWatcher.ProcessLanguageServer,
XMLLanguageServerAPI,
IXMLDocumentProvider,
IXMLNotificationService,
IXMLValidationService {
    private static final Logger LOGGER = Logger.getLogger(XMLLanguageServer.class.getName());
    private final XMLLanguageService xmlLanguageService;
    private final XMLTextDocumentService xmlTextDocumentService = new XMLTextDocumentService(this);
    private final XMLWorkspaceService xmlWorkspaceService = new XMLWorkspaceService(this);
    private XMLLanguageClientAPI languageClient;
    private final ScheduledExecutorService delayer;
    private Integer parentProcessId;
    private XMLCapabilityManager capabilityManager;
    private TelemetryManager telemetryManager;

    public XMLLanguageServer() {
        this.xmlLanguageService = new XMLLanguageService();
        this.xmlLanguageService.setDocumentProvider(this);
        this.xmlLanguageService.setNotificationService(this);
        this.xmlLanguageService.setCommandService(this.xmlWorkspaceService);
        this.xmlLanguageService.setValidationService(this);
        this.delayer = Executors.newScheduledThreadPool(1);
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        Object initOptions = InitializationOptionsSettings.getSettings(params);
        Object xmlSettings = AllXMLSettings.getAllXMLSettings(initOptions);
        XMLGeneralClientSettings settings = XMLGeneralClientSettings.getGeneralXMLSettings(xmlSettings);
        LogHelper.initializeRootLogger(this.languageClient, settings == null ? null : settings.getLogs());
        LOGGER.info("Initializing XML Language server" + System.lineSeparator() + Platform.details());
        this.parentProcessId = params.getProcessId();
        this.xmlLanguageService.setTelemetryManager(this.getTelemetryManager());
        this.xmlLanguageService.initializeParams(params);
        ExtendedClientCapabilities extendedClientCapabilities = InitializationOptionsExtendedClientCapabilities.getExtendedClientCapabilities(params);
        this.capabilityManager.setClientCapabilities(params.getCapabilities(), extendedClientCapabilities);
        this.xmlTextDocumentService.updateClientCapabilities(this.capabilityManager.getClientCapabilities().capabilities, this.capabilityManager.getClientCapabilities().getExtendedCapabilities());
        this.updateSettings(initOptions, false);
        ServerCapabilities nonDynamicServerCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities(this.capabilityManager.getClientCapabilities(), this.xmlTextDocumentService.isIncrementalSupport());
        return CompletableFuture.completedFuture(new InitializeResult(nonDynamicServerCapabilities));
    }

    public void initialized(InitializedParams params) {
        this.capabilityManager.initializeCapabilities();
        this.getTelemetryManager().onInitialized(params);
    }

    public synchronized void updateSettings(Object initOptions) {
        this.updateSettings(initOptions, true);
    }

    private synchronized void updateSettings(Object initOptions, boolean initLogs) {
        ContentModelSettings cmSettings;
        if (initOptions == null) {
            return;
        }
        Object initSettings = AllXMLSettings.getAllXMLSettings(initOptions);
        XMLGeneralClientSettings xmlClientSettings = XMLGeneralClientSettings.getGeneralXMLSettings(initSettings);
        if (xmlClientSettings != null) {
            ServerSettings serverSettings;
            XMLPreferences newPreferences;
            XMLCodeLensSettings newCodeLens;
            XMLSymbolSettings newSymbols;
            XMLCompletionSettings newCompletions;
            XMLFormattingOptions formatterSettings;
            XMLTelemetrySettings newTelemetry;
            if (initLogs) {
                LogHelper.initializeRootLogger(this.languageClient, xmlClientSettings.getLogs());
            }
            if ((newTelemetry = xmlClientSettings.getTelemetry()) != null) {
                this.getTelemetryManager().setEnabled(newTelemetry.isEnabled());
            }
            if ((formatterSettings = xmlClientSettings.getFormat()) != null) {
                this.xmlTextDocumentService.getSharedFormattingSettings().merge(formatterSettings);
            }
            if ((newCompletions = xmlClientSettings.getCompletion()) != null) {
                this.xmlTextDocumentService.updateCompletionSettings(newCompletions);
            }
            if ((newSymbols = xmlClientSettings.getSymbols()) != null) {
                this.xmlTextDocumentService.updateSymbolSettings(newSymbols);
            }
            if ((newCodeLens = xmlClientSettings.getCodeLens()) != null) {
                this.xmlTextDocumentService.updateCodeLensSettings(newCodeLens);
            }
            if ((newPreferences = xmlClientSettings.getPreferences()) != null) {
                this.xmlTextDocumentService.updatePreferences(newPreferences);
            }
            if ((serverSettings = xmlClientSettings.getServer()) != null) {
                String workDir = serverSettings.getNormalizedWorkDir();
                FilesUtils.setCachePathSetting(workDir);
            }
        }
        if ((cmSettings = ContentModelSettings.getContentModelXMLSettings(initSettings)) != null) {
            XMLValidationSettings validationSettings = cmSettings.getValidation();
            this.xmlTextDocumentService.getValidationSettings().merge(validationSettings);
        }
        this.xmlTextDocumentService.updateSettings(initSettings);
    }

    public CompletableFuture<Object> shutdown() {
        this.xmlLanguageService.dispose();
        if (this.capabilityManager.getClientCapabilities().shouldLanguageServerExitOnShutdown()) {
            this.delayer.schedule(() -> this.exit(0), 1L, TimeUnit.SECONDS);
        }
        this.getTelemetryManager().shutdown();
        return CompletableFutures.computeAsync(cc -> new Object());
    }

    public void exit() {
        this.exit(0);
    }

    @Override
    public void exit(int exitCode) {
        this.delayer.shutdown();
        System.exit(exitCode);
    }

    public TextDocumentService getTextDocumentService() {
        return this.xmlTextDocumentService;
    }

    public WorkspaceService getWorkspaceService() {
        return this.xmlWorkspaceService;
    }

    public void setClient(LanguageClient languageClient) {
        this.languageClient = (XMLLanguageClientAPI)languageClient;
        this.capabilityManager = new XMLCapabilityManager(this.languageClient, this.xmlTextDocumentService);
        this.telemetryManager = new TelemetryManager(languageClient);
    }

    public XMLLanguageClientAPI getLanguageClient() {
        return this.languageClient;
    }

    public XMLLanguageService getXMLLanguageService() {
        return this.xmlLanguageService;
    }

    public SharedSettings getSettings() {
        return this.xmlTextDocumentService.getSharedSettings();
    }

    public ScheduledFuture<?> schedule(Runnable command, int delay, TimeUnit unit) {
        return this.delayer.schedule(command, (long)delay, unit);
    }

    @Override
    public long getParentProcessId() {
        return this.parentProcessId != null ? (long)this.parentProcessId.intValue() : 0L;
    }

    @Override
    public CompletableFuture<AutoCloseTagResponse> closeTag(TextDocumentPositionParams params) {
        return this.xmlTextDocumentService.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> this.getXMLLanguageService().doAutoClose((DOMDocument)xmlDocument, params.getPosition(), this.getSettings().getCompletionSettings(), (CancelChecker)cancelChecker));
    }

    @Override
    public CompletableFuture<Position> matchingTagPosition(TextDocumentPositionParams params) {
        return this.xmlTextDocumentService.computeDOMAsync(params.getTextDocument(), (cancelChecker, xmlDocument) -> this.getXMLLanguageService().getMatchingTagPosition((DOMDocument)xmlDocument, params.getPosition(), (CancelChecker)cancelChecker));
    }

    @Override
    public DOMDocument getDocument(String uri) {
        ModelTextDocument<DOMDocument> document = this.xmlTextDocumentService.getDocument(uri);
        return document != null ? (DOMDocument)document.getModel().getNow(null) : null;
    }

    @Override
    public void sendNotification(String message, MessageType messageType, Command ... commands) {
        SharedSettings sharedSettings = this.getSharedSettings();
        if (sharedSettings.isActionableNotificationSupport() && sharedSettings.isOpenSettingsCommandSupport()) {
            ActionableNotification notification = new ActionableNotification().withSeverity(messageType).withMessage(message).withCommands(Arrays.asList(commands));
            this.languageClient.actionableNotification(notification);
        } else {
            this.languageClient.showMessage(new MessageParams(messageType, message));
        }
    }

    @Override
    public SharedSettings getSharedSettings() {
        return this.xmlTextDocumentService.getSharedSettings();
    }

    @Override
    public Collection<DOMDocument> getAllDocuments() {
        return this.xmlTextDocumentService.allDocuments().stream().map(m -> m.getModel().getNow(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void validate(DOMDocument document) {
        this.xmlTextDocumentService.validate(document);
    }

    public XMLCapabilityManager getCapabilityManager() {
        return this.capabilityManager;
    }

    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }
}

