/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.catalog;

import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.catalog.CatalogEntry;
import org.eclipse.lemminx.extensions.catalog.CatalogUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class URICatalogEntry
extends CatalogEntry {
    public URICatalogEntry(@NonNull String baseURI, DOMElement entryElement) {
        super(baseURI, entryElement);
    }

    @Override
    public DOMRange getLinkRange() {
        DOMAttr uriAttr = CatalogUtils.getCatalogEntryURI(this.getEntryElement());
        if (uriAttr == null) {
            return null;
        }
        return uriAttr.getNodeAttrValue();
    }

    @Override
    public String getResolvedURI() {
        DOMAttr uriAttr = CatalogUtils.getCatalogEntryURI(this.getEntryElement());
        if (uriAttr == null) {
            return null;
        }
        String lastSegment = uriAttr.getValue();
        if (StringUtils.isBlank(lastSegment)) {
            return null;
        }
        try {
            return Paths.get(this.getBaseURI(), lastSegment).toString();
        }
        catch (InvalidPathException e) {
            return null;
        }
    }
}

