/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.contentmodel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSValue;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDDocument;
import org.eclipse.lemminx.extensions.xsd.contentmodel.XSDDocumentation;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.eclipse.lemminx.settings.SchemaDocumentationType;

public class CMXSDAttributeDeclaration
implements CMAttributeDeclaration {
    private final XSAttributeUse attributeUse;
    private final Map<String, String> valuesDocumentation;
    private String attrDocumentation;
    private SchemaDocumentationType docStrategy;

    public CMXSDAttributeDeclaration(XSAttributeUse attributeUse) {
        this.attributeUse = attributeUse;
        this.valuesDocumentation = new HashMap<String, String>();
    }

    @Override
    public String getName() {
        return this.getAttrDeclaration().getName();
    }

    @Override
    public String getDefaultValue() {
        XSValue xsValue = this.attributeUse.getValueConstraintValue();
        if (xsValue == null && CMXSDDocument.isBooleanType(this.getAttrDeclaration().getTypeDefinition())) {
            return "false";
        }
        return xsValue != null ? xsValue.getNormalizedValue().toString() : null;
    }

    @Override
    public String getDocumentation(ISharedSettingsRequest request) {
        SchemaDocumentationType currStrategy = request.getSharedSettings().getPreferences().getShowSchemaDocumentationType();
        if (this.docStrategy != currStrategy) {
            this.clearDocumentation();
        } else if (this.attrDocumentation != null) {
            return this.attrDocumentation;
        }
        this.docStrategy = currStrategy;
        XSObjectList annotations = this.getAnnotations();
        boolean markdownSupported = request.canSupportMarkupKind("markdown");
        this.attrDocumentation = new XSDDocumentation(annotations, this.docStrategy, !markdownSupported).getFormattedDocumentation(markdownSupported);
        return this.attrDocumentation;
    }

    @Override
    public String getValueDocumentation(String value, ISharedSettingsRequest request) {
        String documentation;
        SchemaDocumentationType currStrategy = request.getSharedSettings().getPreferences().getShowSchemaDocumentationType();
        if (this.docStrategy != currStrategy) {
            this.clearDocumentation();
        }
        if ((documentation = this.valuesDocumentation.get(value)) != null) {
            return documentation;
        }
        this.docStrategy = currStrategy;
        XSObjectList annotations = this.getValueAnnotations();
        boolean markdownSupported = request.canSupportMarkupKind("markdown");
        documentation = new XSDDocumentation(annotations, value, this.docStrategy, !markdownSupported).getFormattedDocumentation(markdownSupported);
        this.valuesDocumentation.put(value, documentation);
        return documentation;
    }

    private void clearDocumentation() {
        this.valuesDocumentation.clear();
        this.attrDocumentation = null;
    }

    private XSObjectList getAnnotations() {
        XSAttributeDeclaration attributeDeclaration = this.getAttrDeclaration();
        XSObjectList annotation = attributeDeclaration.getAnnotations();
        if (annotation != null && annotation.getLength() > 0) {
            return annotation;
        }
        XSSimpleTypeDefinition typeDefinition = attributeDeclaration.getTypeDefinition();
        if (typeDefinition == null) {
            return null;
        }
        if (typeDefinition.getTypeCategory() == 15) {
            return ((XSComplexTypeDecl)typeDefinition).getAnnotations();
        }
        if (typeDefinition.getTypeCategory() == 16) {
            return ((XSSimpleTypeDecl)typeDefinition).getAnnotations();
        }
        return null;
    }

    private XSObjectList getValueAnnotations() {
        XSMultiValueFacet facet;
        Object[] annotationArray;
        XSSimpleTypeDecl simpleTypeDecl;
        XSObjectList multiFacets;
        XSAttributeDeclaration attributeDeclaration = this.getAttrDeclaration();
        XSSimpleTypeDefinition simpleTypeDefinition = attributeDeclaration.getTypeDefinition();
        XSObjectList annotation = null;
        if (simpleTypeDefinition instanceof XSSimpleTypeDecl && !(multiFacets = (simpleTypeDecl = (XSSimpleTypeDecl)simpleTypeDefinition).getMultiValueFacets()).isEmpty() && !this.onlyContainsNull(annotationArray = (multiFacets = (facet = (XSMultiValueFacet)multiFacets.get(0)).getAnnotations()).toArray())) {
            annotation = simpleTypeDecl.getMultiValueFacets();
        }
        if (annotation == null) {
            annotation = attributeDeclaration.getAnnotations();
        }
        if (annotation != null && annotation.getLength() > 0) {
            return annotation;
        }
        XSSimpleTypeDefinition typeDefinition = attributeDeclaration.getTypeDefinition();
        if (typeDefinition == null) {
            return null;
        }
        if (typeDefinition.getTypeCategory() == 15) {
            return ((XSComplexTypeDecl)typeDefinition).getAnnotations();
        }
        if (typeDefinition.getTypeCategory() == 16) {
            return ((XSSimpleTypeDecl)typeDefinition).getAnnotations();
        }
        return null;
    }

    private boolean onlyContainsNull(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return true;
        }
        for (Object o : arr) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRequired() {
        return this.attributeUse.getRequired();
    }

    XSAttributeDeclaration getAttrDeclaration() {
        return this.attributeUse.getAttrDeclaration();
    }

    @Override
    public Collection<String> getEnumerationValues() {
        XSAttributeDeclaration attributeDeclaration = this.getAttrDeclaration();
        if (attributeDeclaration != null) {
            XSSimpleTypeDefinition typeDefinition = attributeDeclaration.getTypeDefinition();
            return CMXSDDocument.getEnumerationValues(typeDefinition);
        }
        return Collections.emptyList();
    }
}

