/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.general.completion;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.nio.file.Path;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.CompletionParticipantAdapter;
import org.eclipse.lemminx.services.extensions.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.ICompletionResponse;
import org.eclipse.lemminx.utils.CompletionSortTextHelper;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.OSUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class FilePathCompletionParticipant
extends CompletionParticipantAdapter {
    public static final String FILE_SCHEME = "file";

    @Override
    public void onAttributeValue(String valuePrefix, ICompletionRequest request, ICompletionResponse response) throws Exception {
        Path validAttributeValuePath;
        DOMDocument xmlDocument = request.getXMLDocument();
        String text = xmlDocument.getText();
        Range fullRange = request.getReplaceRange();
        int documentStartOffset = xmlDocument.offsetAt(fullRange.getStart());
        String fullAttributeValue = valuePrefix;
        if (StringUtils.isEmpty(fullAttributeValue)) {
            return;
        }
        int completionOffset = request.getOffset();
        int parsedAttributeStartOffset = StringUtils.getOffsetAfterWhitespace(fullAttributeValue, completionOffset - documentStartOffset) + documentStartOffset;
        String attributePath = text.substring(parsedAttributeStartOffset, completionOffset);
        Position startValue = xmlDocument.positionAt(parsedAttributeStartOffset);
        Position endValue = xmlDocument.positionAt(completionOffset);
        fullRange = new Range(startValue, endValue);
        String osSpecificAttributePath = attributePath;
        boolean hasFileScheme = false;
        hasFileScheme = attributePath.startsWith("file://");
        if (hasFileScheme) {
            osSpecificAttributePath = attributePath.substring("file://".length());
        }
        String slashInAttribute = FilesUtils.getFilePathSlash(attributePath);
        if (hasFileScheme) {
            if (!osSpecificAttributePath.startsWith("/")) {
                return;
            }
            if (OSUtils.isWindows && osSpecificAttributePath.length() == 1) {
                File[] drives;
                Range replaceRange = this.adjustReplaceRange(xmlDocument, fullRange, attributePath, "/");
                for (File drive : drives = File.listRoots()) {
                    this.createFilePathCompletionItem(drive, replaceRange, response, "/");
                }
                return;
            }
        }
        if (OSUtils.isWindows) {
            osSpecificAttributePath = FilesUtils.convertToWindowsPath(osSpecificAttributePath);
        } else if ("\\".equals(slashInAttribute)) {
            osSpecificAttributePath = osSpecificAttributePath.replace("\\", "/");
        }
        String workingDirectory = null;
        if (!hasFileScheme) {
            String uriString = xmlDocument.getTextDocument().getUri();
            URI uri = new URI(uriString);
            if (!FILE_SCHEME.equals(uri.getScheme())) {
                return;
            }
            String uriPathString = uri.getPath();
            if (!uriPathString.startsWith("/")) {
                return;
            }
            int lastSlash = uriPathString.lastIndexOf("/");
            if (lastSlash > -1) {
                workingDirectory = uriPathString.substring(0, lastSlash);
                if (OSUtils.isWindows) {
                    workingDirectory = FilesUtils.convertToWindowsPath(workingDirectory);
                }
            }
        }
        if ((validAttributeValuePath = FilesUtils.getNormalizedPath(workingDirectory, osSpecificAttributePath)) == null) {
            return;
        }
        Range replaceRange = this.adjustReplaceRange(xmlDocument, fullRange, attributePath, slashInAttribute);
        this.createNextValidCompletionPaths(validAttributeValuePath, slashInAttribute, replaceRange, response, null);
    }

    private Range adjustReplaceRange(DOMDocument xmlDocument, Range fullRange, String attributeValue, String slash) {
        int startOffset;
        Position replaceStart = null;
        Position currentEnd = fullRange.getEnd();
        try {
            startOffset = xmlDocument.offsetAt(fullRange.getStart());
        }
        catch (BadLocationException e) {
            return null;
        }
        int lastSlashIndex = attributeValue.lastIndexOf(slash);
        if (lastSlashIndex > -1) {
            try {
                replaceStart = xmlDocument.positionAt(startOffset + lastSlashIndex);
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        Range replaceRange = new Range();
        if (replaceStart != null) {
            replaceRange.setStart(replaceStart);
        } else {
            replaceRange.setStart(currentEnd);
        }
        replaceRange.setEnd(currentEnd);
        return replaceRange;
    }

    private void createNextValidCompletionPaths(Path pathToAttributeDirectory, String slash, Range replaceRange, ICompletionResponse response, FilenameFilter filter) {
        File[] proposedFiles = this.gatherFiles(pathToAttributeDirectory, filter);
        if (proposedFiles != null) {
            for (File child : proposedFiles) {
                if (child == null) continue;
                this.createFilePathCompletionItem(child, replaceRange, response, slash);
            }
        }
    }

    private File[] gatherFiles(Path pathOfDirectory, FilenameFilter filter) {
        File f = new File(pathOfDirectory.toString());
        return f.isDirectory() ? f.listFiles(filter) : null;
    }

    private void createFilePathCompletionItem(File f, Range replaceRange, ICompletionResponse response, String slash) {
        CompletionItem item = new CompletionItem();
        String fName = f.getName();
        if (OSUtils.isWindows && fName.isEmpty()) {
            fName = f.getPath();
            fName = fName.substring(0, fName.length() - 1);
        }
        String insertText = slash + fName;
        item.setLabel(insertText);
        CompletionItemKind kind = f.isDirectory() ? CompletionItemKind.Folder : CompletionItemKind.File;
        item.setKind(kind);
        item.setSortText(CompletionSortTextHelper.getSortText(kind));
        item.setFilterText(insertText);
        item.setTextEdit(new TextEdit(replaceRange, insertText));
        response.addCompletionItem(item);
    }
}

