/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.util.List;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.xerces.AbstractLSPErrorReporter;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;

public class LSPErrorReporterForXML
extends AbstractLSPErrorReporter {
    private static final String XML_DIAGNOSTIC_SOURCE = "xml";

    public LSPErrorReporterForXML(DOMDocument xmlDocument, List<Diagnostic> diagnostics) {
        super(XML_DIAGNOSTIC_SOURCE, xmlDocument, diagnostics);
    }

    @Override
    protected Range toLSPRange(XMLLocator location, String key, Object[] arguments, DOMDocument document) {
        XMLSyntaxErrorCode syntaxCode = XMLSyntaxErrorCode.get(key);
        if (syntaxCode != null) {
            Range range = XMLSyntaxErrorCode.toLSPRange(location, syntaxCode, arguments, document);
            if (range != null) {
                return range;
            }
        } else {
            XMLSchemaErrorCode schemaCode = XMLSchemaErrorCode.get(key);
            if (schemaCode != null) {
                Range range = XMLSchemaErrorCode.toLSPRange(location, schemaCode, arguments, document);
                if (range != null) {
                    return range;
                }
            } else {
                Range range;
                DTDErrorCode dtdCode = DTDErrorCode.get(key);
                if (dtdCode != null && (range = DTDErrorCode.toLSPRange(location, dtdCode, arguments, document)) != null) {
                    return range;
                }
            }
        }
        return null;
    }

    @Override
    protected boolean isIgnoreFatalError(String key) {
        return DTDErrorCode.EntityNotDeclared.name().equals(key);
    }
}

