/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.List;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMDocumentType;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.dom.DTDDeclParameter;
import org.eclipse.lemminx.dom.NoNamespaceSchemaLocation;
import org.eclipse.lemminx.dom.XMLModel;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentLink;

public class ContentModelDocumentLinkParticipant
implements IDocumentLinkParticipant {
    @Override
    public void findDocumentLinks(DOMDocument document, List<DocumentLink> links) {
        String location;
        DOMDocumentType docType;
        NoNamespaceSchemaLocation noNamespaceSchemaLocation = document.getNoNamespaceSchemaLocation();
        if (noNamespaceSchemaLocation != null) {
            try {
                DOMNode attrValue;
                String location2 = ContentModelDocumentLinkParticipant.getResolvedLocation(document.getDocumentURI(), noNamespaceSchemaLocation.getLocation());
                if (location2 != null && (attrValue = noNamespaceSchemaLocation.getAttr().getNodeAttrValue()) != null) {
                    links.add(XMLPositionUtility.createDocumentLink(attrValue, location2));
                }
            }
            catch (BadLocationException location2) {
                // empty catch block
            }
        }
        if ((docType = document.getDoctype()) != null && (location = ContentModelDocumentLinkParticipant.getResolvedLocation(document.getDocumentURI(), docType.getSystemIdWithoutQuotes())) != null) {
            try {
                DTDDeclParameter systemIdRange = docType.getSystemIdNode();
                if (systemIdRange != null) {
                    links.add(XMLPositionUtility.createDocumentLink(systemIdRange, location));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        List<XMLModel> xmlModels = document.getXMLModels();
        for (XMLModel xmlModel : xmlModels) {
            String location3 = ContentModelDocumentLinkParticipant.getResolvedLocation(document.getDocumentURI(), xmlModel.getHref());
            if (location3 == null) continue;
            try {
                DOMRange hrefRange = xmlModel.getHrefNode();
                if (hrefRange == null) continue;
                links.add(XMLPositionUtility.createDocumentLink(hrefRange, location3));
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private static String getResolvedLocation(String documentURI, String location) {
        if (location == null) {
            return null;
        }
        try {
            return XMLEntityManager.expandSystemId((String)location, (String)documentURI, (boolean)false);
        }
        catch (URI.MalformedURIException e) {
            return location;
        }
    }
}

