/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.ble.ibeacon;

import org.eclipse.kura.KuraBluetoothBeaconAdvertiserNotAvailable;
import org.eclipse.kura.ble.ibeacon.BluetoothLeIBeacon;
import org.eclipse.kura.ble.ibeacon.BluetoothLeIBeaconService;
import org.eclipse.kura.bluetooth.le.BluetoothLeAdapter;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconAdvertiser;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconDecoder;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconEncoder;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconManager;
import org.eclipse.kura.bluetooth.le.beacon.BluetoothLeBeaconScanner;
import org.eclipse.kura.internal.ble.ibeacon.BluetoothLeIBeaconDecoderImpl;
import org.eclipse.kura.internal.ble.ibeacon.BluetoothLeIBeaconEncoderImpl;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothLeIBeaconServiceImpl
implements BluetoothLeIBeaconService {
    private static final Logger logger = LoggerFactory.getLogger(BluetoothLeIBeaconServiceImpl.class);
    private BluetoothLeBeaconManager<BluetoothLeIBeacon> bluetoothLeBeaconManager;

    public void setBluetoothLeBeaconManager(BluetoothLeBeaconManager<BluetoothLeIBeacon> bluetoothLeBeaconManager) {
        this.bluetoothLeBeaconManager = bluetoothLeBeaconManager;
    }

    public void unsetBluetoothLeBeaconManager(BluetoothLeBeaconManager<BluetoothLeIBeacon> bluetoothLeBeaconManager) {
        this.bluetoothLeBeaconManager = null;
    }

    protected void activate(ComponentContext context) {
        logger.info("Activating Bluetooth Le IBeacon Service...");
    }

    protected void deactivate(ComponentContext context) {
        logger.debug("Deactivating Bluetooth Le IBeacon Service...");
    }

    public BluetoothLeBeaconScanner<BluetoothLeIBeacon> newBeaconScanner(BluetoothLeAdapter adapter) {
        return this.bluetoothLeBeaconManager.newBeaconScanner(adapter, (BluetoothLeBeaconDecoder)new BluetoothLeIBeaconDecoderImpl());
    }

    public BluetoothLeBeaconAdvertiser<BluetoothLeIBeacon> newBeaconAdvertiser(BluetoothLeAdapter adapter) throws KuraBluetoothBeaconAdvertiserNotAvailable {
        return this.bluetoothLeBeaconManager.newBeaconAdvertiser(adapter, (BluetoothLeBeaconEncoder)new BluetoothLeIBeaconEncoderImpl());
    }

    public void deleteBeaconScanner(BluetoothLeBeaconScanner<BluetoothLeIBeacon> scanner) {
        this.bluetoothLeBeaconManager.deleteBeaconScanner(scanner);
    }

    public void deleteBeaconAdvertiser(BluetoothLeBeaconAdvertiser<BluetoothLeIBeacon> advertiser) {
        this.bluetoothLeBeaconManager.deleteBeaconAdvertiser(advertiser);
    }
}

