/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.parser.netty;

import io.moquette.parser.netty.DemuxDecoder;
import io.moquette.parser.netty.Utils;
import io.moquette.proto.messages.AbstractMessage;
import io.moquette.proto.messages.SubscribeMessage;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.AttributeMap;
import java.io.UnsupportedEncodingException;
import java.util.List;

class SubscribeDecoder
extends DemuxDecoder {
    SubscribeDecoder() {
    }

    @Override
    void decode(AttributeMap ctx, ByteBuf in, List<Object> out) throws Exception {
        SubscribeMessage message = new SubscribeMessage();
        in.resetReaderIndex();
        if (!this.decodeCommonHeader(message, 2, in)) {
            in.resetReaderIndex();
            return;
        }
        if (message.getQos() != AbstractMessage.QOSType.LEAST_ONE) {
            throw new CorruptedFrameException("Received SUBSCRIBE message with QoS other than LEAST_ONE, was: " + (Object)((Object)message.getQos()));
        }
        int start = in.readerIndex();
        message.setMessageID(in.readUnsignedShort());
        int read = in.readerIndex() - start;
        while (read < message.getRemainingLength()) {
            this.decodeSubscription(in, message);
            read = in.readerIndex() - start;
        }
        if (message.subscriptions().isEmpty()) {
            throw new CorruptedFrameException("subscribe MUST have got at least 1 couple topic/QoS");
        }
        out.add(message);
    }

    private void decodeSubscription(ByteBuf in, SubscribeMessage message) throws UnsupportedEncodingException {
        String topic = Utils.decodeString(in);
        if (topic.length() == 0) {
            throw new CorruptedFrameException("Received a SUBSCRIBE with empty topic filter");
        }
        byte qosByte = in.readByte();
        if ((qosByte & 0xFC) > 0) {
            throw new CorruptedFrameException("subscribe MUST have QoS byte with reserved buts to 0, found " + Integer.toHexString(qosByte));
        }
        byte qos = (byte)(qosByte & 3);
        message.addSubscription(new SubscribeMessage.Couple(qos, topic));
    }
}

