/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.request.handler.jaxrs;

import com.google.gson.Gson;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.request.handler.jaxrs.consumer.ResponseBodyHandler;

public final class ResponseBodyHandlers {
    private ResponseBodyHandlers() {
    }

    public static ResponseBodyHandler voidHandler() {
        return r -> Optional.empty();
    }

    public static ResponseBodyHandler responseHandler(Gson gson) {
        return r -> {
            Response response = (Response)r;
            if (response == null) {
                return Optional.empty();
            }
            Object entity = response.getEntity();
            if (entity == null) {
                return Optional.empty();
            }
            if (entity instanceof String) {
                return Optional.of(((String)entity).getBytes(StandardCharsets.UTF_8));
            }
            if (entity instanceof byte[]) {
                return Optional.of((byte[])entity);
            }
            if (entity instanceof InputStream) {
                try {
                    return Optional.of(IOUtils.toByteArray((InputStream)((InputStream)entity)));
                }
                catch (Exception e) {
                    throw KuraException.internalError((Throwable)e);
                }
            }
            String asJson = gson.toJson(entity);
            return Optional.of(asJson.getBytes(StandardCharsets.UTF_8));
        };
    }

    public static ResponseBodyHandler gsonHandler(Gson gson) {
        return r -> {
            if (r == null) {
                return Optional.empty();
            }
            return Optional.of(gson.toJson(r).getBytes(StandardCharsets.UTF_8));
        };
    }
}

