/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.xml.marshaller.unmarshaller;

import org.eclipse.kura.core.inventory.resources.SystemBundle;
import org.eclipse.kura.core.inventory.resources.SystemDeploymentPackage;
import org.eclipse.kura.core.inventory.resources.SystemDeploymentPackages;
import org.eclipse.kura.internal.xml.marshaller.unmarshaller.XmlJavaDataMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlJavaPackagesMapper
implements XmlJavaDataMapper {
    private static final String PACKAGES = "packages";
    private static final String PACKAGES_PACKAGE = "package";
    private static final String PACKAGES_PACKAGE_NAME = "name";
    private static final String PACKAGES_PACKAGE_VERSION = "version";
    private static final String PACKAGES_PACKAGE_BUNDLES = "bundles";
    private static final String PACKAGES_PACKAGE_BUNDLES_BUNDLE = "bundle";
    private static final String PACKAGES_PACKAGE_BUNDLES_BUNDLE_NAME = "name";
    private static final String PACKAGES_PACKAGE_BUNDLES_BUNDLE_VERSION = "version";

    @Override
    public Element marshal(Document doc, Object object) throws Exception {
        SystemDeploymentPackage[] xdpArray;
        Element packages = doc.createElement(PACKAGES);
        doc.appendChild(packages);
        SystemDeploymentPackages xdps = (SystemDeploymentPackages)object;
        SystemDeploymentPackage[] systemDeploymentPackageArray = xdpArray = xdps.getDeploymentPackages();
        int n = xdpArray.length;
        int n2 = 0;
        while (n2 < n) {
            SystemDeploymentPackage xdp = systemDeploymentPackageArray[n2];
            Element packageInstalled = doc.createElement(PACKAGES_PACKAGE);
            XmlJavaPackagesMapper.marshalDeploymentPackage(doc, xdp, packageInstalled);
            packages.appendChild(packageInstalled);
            ++n2;
        }
        return packages;
    }

    @Override
    public <T> T unmarshal(Document doc) throws Exception {
        return null;
    }

    private static void marshalDeploymentPackage(Document doc, SystemDeploymentPackage xdp, Element packageInstalled) {
        String packageName = xdp.getName();
        String packageVersion = xdp.getVersion();
        SystemBundle[] xbiArray = xdp.getBundleInfos();
        if (packageName != null && !packageName.trim().isEmpty()) {
            Element name = doc.createElement("name");
            name.setTextContent(packageName);
            packageInstalled.appendChild(name);
        }
        if (packageVersion != null && !packageVersion.trim().isEmpty()) {
            Element version = doc.createElement("version");
            version.setTextContent(packageVersion);
            packageInstalled.appendChild(version);
        }
        Element bundles = doc.createElement(PACKAGES_PACKAGE_BUNDLES);
        packageInstalled.appendChild(bundles);
        if (xbiArray != null) {
            SystemBundle[] systemBundleArray = xbiArray;
            int n = xbiArray.length;
            int n2 = 0;
            while (n2 < n) {
                SystemBundle xbi = systemBundleArray[n2];
                Element bundle = doc.createElement(PACKAGES_PACKAGE_BUNDLES_BUNDLE);
                XmlJavaPackagesMapper.marshalBundleInfo(doc, xbi, bundle);
                bundles.appendChild(bundle);
                ++n2;
            }
        }
    }

    private static void marshalBundleInfo(Document doc, SystemBundle xbi, Element bundle) {
        String bundleName = xbi.getName();
        String bundleVersion = xbi.getVersion();
        if (bundleName != null && !bundleName.trim().isEmpty()) {
            Element name = doc.createElement("name");
            name.setTextContent(bundleName);
            bundle.appendChild(name);
        }
        if (bundleVersion != null && !bundleVersion.trim().isEmpty()) {
            Element version = doc.createElement("version");
            version.setTextContent(bundleVersion);
            bundle.appendChild(version);
        }
    }
}

