/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.configuration;

import java.util.Map;
import java.util.Optional;

public final class Property<T> {
    private final String key;
    private final Optional<T> defaultValue;
    private final Class<? extends T> classz;

    public Property(String key, T defaultValue) {
        this.key = key;
        this.defaultValue = Optional.of(defaultValue);
        this.classz = defaultValue.getClass();
    }

    public Property(String key, Class<T> classz) {
        this.key = key;
        this.classz = classz;
        this.defaultValue = Optional.empty();
    }

    public T get(Map<String, Object> properties) {
        Object value = properties.get(this.key);
        if (this.classz.isInstance(value)) {
            return (T)value;
        }
        return this.defaultValue.orElseThrow(() -> new IllegalStateException("configuration property + \"" + this.key + "\" has not been provided set and the property does not have a default value"));
    }

    public Optional<T> getOptional(Map<String, Object> properties) {
        Object value = properties.get(this.key);
        if (this.classz.isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

