/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.wireadmin;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.wireadmin.Activator;
import org.eclipse.equinox.internal.wireadmin.NotificationEvent;
import org.eclipse.equinox.internal.wireadmin.WireAdminImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireAdminEvent;
import org.osgi.service.wireadmin.WireAdminListener;

public class EventDispatcher
implements Runnable {
    private BundleContext bc;
    private WireAdminImpl wa;
    private Hashtable refToList;
    private Vector events;
    private Object synch = new Object();
    private Object listenersLock = new Object();
    private boolean running = true;
    private Thread dispatcher;
    static /* synthetic */ Class class$0;

    public EventDispatcher(BundleContext bc, WireAdminImpl wa) {
        this.bc = bc;
        this.wa = wa;
        this.refToList = new Hashtable(5);
        this.events = new Vector(5, 5);
        ServiceReference[] sRefs = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.wireadmin.WireAdminListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            sRefs = bc.getServiceReferences(clazz.getName(), null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        if (sRefs != null) {
            int i = 0;
            while (i < sRefs.length) {
                WireAdminListener listener = (WireAdminListener)bc.getService(sRefs[i]);
                if (listener != null) {
                    this.refToList.put(sRefs[i], listener);
                }
                ++i;
            }
        }
        this.dispatcher = new Thread((Runnable)this, "[WireAdmin] - Event Dispatcher");
        this.dispatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEvent(WireAdminEvent evt) {
        if (this.refToList.isEmpty()) {
            return;
        }
        if (this.dispatcher == null) {
            this.notifyListeners(new EventData(evt, this.refToList));
        } else {
            this.events.addElement(new EventData(evt, this.refToList));
            Object object = this.synch;
            synchronized (object) {
                this.synch.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNotificationEvent(NotificationEvent ne) {
        if (this.dispatcher == null) {
            this.notifyConsumerProducer(ne);
        } else {
            this.events.addElement(ne);
            Object object = this.synch;
            synchronized (object) {
                this.synch.notify();
            }
        }
    }

    private String printWires(Wire[] wires) {
        if (wires != null) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("\n");
            int i = 0;
            while (i < wires.length) {
                buff.append(wires[i]).append("\n");
                ++i;
            }
            return ((Object)buff).toString();
        }
        return "null";
    }

    private void notifyConsumerProducer(NotificationEvent ne) {
        if (Activator.LOG_DEBUG) {
            Activator.log.debug("Notification event " + (ne.producer != null ? "; Producer " + ne.producer : "; Consumer " + ne.consumer) + "; source: " + ne.source + "; wires " + this.printWires(ne.wires), null);
            Activator.log.debug(0, 10001, this.dispatcher != null ? "asynchronous" : "synchronous", null, false);
        }
        if (ne.producer != null) {
            try {
                ne.producer.consumersConnected(ne.wires);
            }
            catch (Throwable t) {
                this.wa.notifyListeners(ne.source, 1, t);
            }
        } else if (ne.consumer != null) {
            try {
                ne.consumer.producersConnected(ne.wires);
            }
            catch (Throwable t) {
                this.wa.notifyListeners(ne.source, 2, t);
            }
        }
    }

    private void notifyListeners(EventData event) {
        WireAdminEvent evt = (WireAdminEvent)event.event;
        Hashtable refToList = event.listeners;
        if (Activator.LOG_DEBUG) {
            Activator.log.debug(0, 10002, String.valueOf(this.getEvent(evt.getType())) + evt.getWire(), evt.getThrowable(), false);
            Activator.log.debug(0, 10001, this.dispatcher != null ? "asynchronous" : "synchronous", null, false);
        }
        Enumeration en = refToList.keys();
        while (this.running && en.hasMoreElements()) {
            ServiceReference current = (ServiceReference)en.nextElement();
            Integer accepts = (Integer)current.getProperty("wireadmin.events");
            if (accepts == null || (accepts & evt.getType()) != evt.getType()) continue;
            try {
                ((WireAdminListener)refToList.get(current)).wireAdminEvent(evt);
            }
            catch (Throwable t) {
                if (!Activator.LOG_DEBUG) continue;
                Activator.log.debug(0, 10003, ((WireAdminListener)refToList.get(current)).toString(), t, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ServiceReference ref) {
        if (this.refToList.containsKey(ref)) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.refToList = (Hashtable)this.refToList.clone();
                if (this.refToList.remove(ref) != null) {
                    this.bc.ungetService(ref);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ServiceReference ref, Object object) {
        Object object2 = this.listenersLock;
        synchronized (object2) {
            this.refToList = (Hashtable)this.refToList.clone();
            this.refToList.put(ref, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.running) {
            Object object = this.synch;
            synchronized (object) {
                while (this.running && this.events.size() == 0) {
                    try {
                        this.synch.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            EventData evt = null;
            NotificationEvent ne = null;
            while (this.running && this.events.size() > 0) {
                Object event = this.events.elementAt(0);
                this.events.removeElementAt(0);
                if (event instanceof EventData) {
                    evt = (EventData)event;
                    this.notifyListeners(evt);
                    continue;
                }
                ne = (NotificationEvent)event;
                this.notifyConsumerProducer(ne);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Object object;
        this.running = false;
        if (this.dispatcher != null) {
            object = this.synch;
            synchronized (object) {
                this.synch.notify();
            }
        }
        object = this.listenersLock;
        synchronized (object) {
            Enumeration en = this.refToList.keys();
            while (en.hasMoreElements()) {
                this.bc.ungetService((ServiceReference)en.nextElement());
            }
            this.refToList.clear();
            this.refToList = null;
        }
        this.events.removeAllElements();
        this.events = null;
    }

    private String getEvent(int type) {
        switch (type) {
            case 4: {
                return "WIRE_CREATED";
            }
            case 32: {
                return "WIRE_CONNECTED";
            }
            case 8: {
                return "WIRE_UPDATED";
            }
            case 128: {
                return "WIRE_TRACE";
            }
            case 64: {
                return "WIRE_DISCONNECTED";
            }
            case 16: {
                return "WIRE_DELETED";
            }
            case 1: {
                return "PRODUCER_EXCEPTION";
            }
            case 2: {
                return "CONSUMER_EXCEPTION";
            }
        }
        return null;
    }

    class EventData {
        Object event;
        Hashtable listeners;

        public EventData(Object event, Hashtable listenersData) {
            this.event = event;
            this.listeners = listenersData;
        }
    }
}

