/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.net;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.net.NetConfig;
import org.eclipse.kura.net.wifi.WifiBgscan;
import org.eclipse.kura.net.wifi.WifiCiphers;
import org.eclipse.kura.net.wifi.WifiConfig;
import org.eclipse.kura.net.wifi.WifiMode;
import org.eclipse.kura.net.wifi.WifiRadioMode;
import org.eclipse.kura.net.wifi.WifiSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WifiConfigurationInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(WifiConfigurationInterpreter.class);
    private static final String BGSCAN = ".bgscan";
    private static final String HARDWARE_MODE = ".hardwareMode";
    private static final String WIFI_PASSPHRASE_KEY = ".passphrase";
    private static final String SECURITY_TYPE = ".securityType";
    private static final String NET_INTERFACE = "net.interface.";
    private static final String WIFI_CHANNELS_KEY = ".channel";
    private static final String WIFI_IGNORE_SSID_KEY = ".ignoreSSID";
    private static final String WIFI_PING_ACCESS_POINT_KEY = ".pingAccessPoint";
    private static final String WIFI_RADIO_MODE_KEY = ".radioMode";
    private static final String WIFI_GROUP_CIPHERS_KEY = ".groupCiphers";
    private static final String WIFI_PAIRWISE_CIPHERS_KEY = ".pairwiseCiphers";
    private static final String DRIVER_KEY = ".driver";
    private static final String WIFI_SSID_KEY = ".ssid";

    private WifiConfigurationInterpreter() {
    }

    public static List<NetConfig> populateConfiguration(Map<String, Object> props, String interfaceName) throws KuraException {
        ArrayList<NetConfig> netConfigs = new ArrayList<NetConfig>();
        if (Objects.isNull(props)) {
            return netConfigs;
        }
        StringBuilder sbPrefix = new StringBuilder();
        sbPrefix.append(NET_INTERFACE).append(interfaceName).append(".").append("config.");
        String netIfConfigPrefix = sbPrefix.toString();
        netConfigs.add((NetConfig)WifiConfigurationInterpreter.getWifiConfig(netIfConfigPrefix, WifiMode.MASTER, props));
        netConfigs.add((NetConfig)WifiConfigurationInterpreter.getWifiConfig(netIfConfigPrefix, WifiMode.INFRA, props));
        return netConfigs;
    }

    public static WifiMode getWifiMode(Map<String, Object> props, String interfaceName) {
        StringBuilder sbPrefix = new StringBuilder();
        sbPrefix.append(NET_INTERFACE).append(interfaceName).append(".");
        String configWifiMode = String.valueOf(sbPrefix.append("config.").toString()) + "wifi.mode";
        WifiMode mode = WifiMode.MASTER;
        if (!Objects.isNull(props) && props.containsKey(configWifiMode) && props.get(configWifiMode) != null) {
            mode = WifiMode.valueOf((String)((String)props.get(configWifiMode)));
        }
        return mode;
    }

    private static WifiConfig getWifiConfig(String netIfConfigPrefix, WifiMode mode, Map<String, Object> properties) throws KuraException {
        String radioMode;
        String hwMode;
        String driver;
        String prefix = netIfConfigPrefix + "wifi." + mode.toString().toLowerCase();
        WifiConfig wifiConfig = new WifiConfig();
        wifiConfig.setMode(mode);
        String ssid = WifiConfigurationInterpreter.getSsid(properties, prefix);
        if (!Objects.isNull(ssid)) {
            wifiConfig.setSSID(ssid);
        }
        if (!Objects.isNull(driver = WifiConfigurationInterpreter.getDriver(properties, prefix))) {
            wifiConfig.setDriver(driver);
        }
        wifiConfig.setSecurity(WifiConfigurationInterpreter.getWifiSecurity(properties, prefix));
        wifiConfig.setChannels(WifiConfigurationInterpreter.getWifiChannels(properties, prefix));
        String psswdObj = WifiConfigurationInterpreter.getWifiPassphrase(properties, prefix);
        if (!Objects.isNull(psswdObj)) {
            wifiConfig.setPasskey(psswdObj);
        }
        if (!Objects.isNull(hwMode = WifiConfigurationInterpreter.getHwMode(properties, prefix))) {
            wifiConfig.setHardwareMode(hwMode);
        }
        wifiConfig.setIgnoreSSID(WifiConfigurationInterpreter.isSsidIgnored(properties, prefix));
        String pairwiseCiphers = WifiConfigurationInterpreter.getPairwiseCiphers(properties, prefix);
        if (!Objects.isNull(pairwiseCiphers)) {
            wifiConfig.setPairwiseCiphers(WifiCiphers.valueOf((String)pairwiseCiphers));
        }
        if (mode == WifiMode.INFRA) {
            wifiConfig.setBgscan(WifiConfigurationInterpreter.getBgScan(properties, prefix));
            String groupCiphers = WifiConfigurationInterpreter.getGroupCiphers(properties, prefix);
            if (!Objects.isNull(groupCiphers)) {
                wifiConfig.setGroupCiphers(WifiCiphers.valueOf((String)groupCiphers));
            }
            wifiConfig.setPingAccessPoint(WifiConfigurationInterpreter.isPingAccessPoint(properties, prefix));
        }
        if (!Objects.isNull(radioMode = WifiConfigurationInterpreter.getRadioMode(properties, prefix))) {
            try {
                wifiConfig.setRadioMode(WifiRadioMode.valueOf((String)radioMode));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, new Object[]{"Could not parse wifi radio mode " + radioMode});
            }
        }
        return wifiConfig;
    }

    private static String getRadioMode(Map<String, Object> properties, String prefix) {
        return (String)properties.get(String.valueOf(prefix) + WIFI_RADIO_MODE_KEY);
    }

    private static boolean isPingAccessPoint(Map<String, Object> properties, String prefix) {
        boolean pingAccessPoint = false;
        Object value = properties.get(String.valueOf(prefix) + WIFI_PING_ACCESS_POINT_KEY);
        if (!Objects.isNull(value) && value instanceof Boolean) {
            pingAccessPoint = (Boolean)value;
        }
        return pingAccessPoint;
    }

    private static String getGroupCiphers(Map<String, Object> properties, String prefix) {
        return (String)properties.get(String.valueOf(prefix) + WIFI_GROUP_CIPHERS_KEY);
    }

    private static WifiBgscan getBgScan(Map<String, Object> properties, String prefix) {
        String bgscan = (String)properties.get(String.valueOf(prefix) + BGSCAN);
        if (bgscan == null) {
            bgscan = "";
        }
        return new WifiBgscan(bgscan);
    }

    private static String getPairwiseCiphers(Map<String, Object> properties, String prefix) {
        return (String)properties.get(String.valueOf(prefix) + WIFI_PAIRWISE_CIPHERS_KEY);
    }

    private static boolean isSsidIgnored(Map<String, Object> properties, String prefix) {
        boolean ignoreSSID = false;
        Object value = properties.get(String.valueOf(prefix) + WIFI_IGNORE_SSID_KEY);
        if (!Objects.isNull(value) && value instanceof Boolean) {
            ignoreSSID = (Boolean)value;
        }
        return ignoreSSID;
    }

    private static String getHwMode(Map<String, Object> properties, String prefix) {
        return (String)properties.get(String.valueOf(prefix) + HARDWARE_MODE);
    }

    private static String getWifiPassphrase(Map<String, Object> properties, String prefix) {
        Object psswdObj = properties.get(String.valueOf(prefix) + WIFI_PASSPHRASE_KEY);
        String passphrase = null;
        if (psswdObj instanceof Password) {
            Password psswd = (Password)psswdObj;
            passphrase = new String(psswd.getPassword());
        } else if (psswdObj instanceof String) {
            passphrase = (String)psswdObj;
        }
        return passphrase;
    }

    private static int[] getWifiChannels(Map<String, Object> properties, String prefix) {
        StringTokenizer st;
        int tokens;
        String channelsString = (String)properties.get(String.valueOf(prefix) + WIFI_CHANNELS_KEY);
        if (!Objects.isNull(channelsString) && !channelsString.trim().isEmpty() && (tokens = (st = new StringTokenizer(channelsString.trim(), " ")).countTokens()) > 0) {
            int[] channels = new int[tokens];
            int i = 0;
            while (i < tokens) {
                String token = st.nextToken();
                try {
                    channels[i] = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    logger.error("Error parsing channels!", (Throwable)e);
                }
                ++i;
            }
            return channels;
        }
        return new int[]{1};
    }

    private static WifiSecurity getWifiSecurity(Map<String, Object> properties, String prefix) throws KuraException {
        String securityString = (String)properties.get(String.valueOf(prefix) + SECURITY_TYPE);
        if (securityString != null && !securityString.isEmpty()) {
            try {
                return WifiSecurity.valueOf((String)securityString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KuraException(KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID, new Object[]{"Could not parse wifi security " + securityString});
            }
        }
        return WifiSecurity.NONE;
    }

    private static String getDriver(Map<String, Object> properties, String prefix) {
        String key = String.valueOf(prefix) + DRIVER_KEY;
        return (String)properties.get(key);
    }

    private static String getSsid(Map<String, Object> properties, String prefix) {
        String key = String.valueOf(prefix) + WIFI_SSID_KEY;
        return (String)properties.get(key);
    }
}

