/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.apache.camel.CamelContext;

public class CamelObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;

    public CamelObjectInputStream(InputStream in, CamelContext context) throws IOException {
        super(in);
        this.classLoader = context != null ? context.getApplicationContextClassLoader() : null;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException, IOException {
        if (this.classLoader != null) {
            return Class.forName(desc.getName(), false, this.classLoader);
        }
        return super.resolveClass(desc);
    }
}

