/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyLoader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.UserManager;
import org.eclipse.kura.web.server.Audit;
import org.eclipse.kura.web.server.KuraRemoteServiceServlet;
import org.eclipse.kura.web.server.RequiredPermissions;
import org.eclipse.kura.web.session.Attributes;
import org.eclipse.kura.web.shared.model.GwtUserConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiRemoteServiceServlet
extends KuraRemoteServiceServlet {
    private final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");
    private final Optional<RequiredPermissions> servicePermissionRequirements;
    private final Map<Method, RequiredPermissions> methodPermissionRequirements = new HashMap<Method, RequiredPermissions>();
    private final Map<Method, Audit> methodAuditSettings = new HashMap<Method, Audit>();
    private static final long serialVersionUID = -8826193840033103296L;

    public OsgiRemoteServiceServlet() {
        Optional<Object> servicePermissions = Optional.empty();
        Class<?>[] classArray = ((Object)((Object)this)).getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            RequiredPermissions permissions = intf.getAnnotation(RequiredPermissions.class);
            if (permissions != null) {
                servicePermissions = Optional.of(permissions);
            }
            Method[] methodArray = intf.getMethods();
            int n3 = methodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Audit methodAudit;
                Method method = methodArray[n4];
                RequiredPermissions methodPermissions = method.getAnnotation(RequiredPermissions.class);
                if (methodPermissions != null) {
                    this.methodPermissionRequirements.put(method, methodPermissions);
                }
                if ((methodAudit = method.getAnnotation(Audit.class)) != null) {
                    this.methodAuditSettings.put(method, methodAudit);
                }
                ++n4;
            }
            ++n2;
        }
        this.servicePermissionRequirements = servicePermissions;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        AuditContext auditContext = Console.instance().initAuditContext(req);
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (AuditContext.Scope scope = AuditContext.openScope((AuditContext)auditContext);){
                super.service(req, resp);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            currentThread.setContextClassLoader(oldContextClassLoader);
        }
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        String contextPath = request.getContextPath();
        String modulePath = null;
        if (moduleBaseURL != null) {
            try {
                modulePath = new URL(moduleBaseURL).getPath();
            }
            catch (MalformedURLException ex) {
                this.log("Malformed moduleBaseURL: " + moduleBaseURL, ex);
            }
        }
        SerializationPolicy serializationPolicy = null;
        if (modulePath == null || !modulePath.startsWith(contextPath)) {
            String message = "ERROR: The module path requested, " + modulePath + ", is not in the same web application as this servlet, " + contextPath + ".  Your module may not be properly configured or your client and server code maybe out of date.";
            this.log(message, null);
        } else {
            String contextRelativePath = modulePath.substring(contextPath.length());
            String serializationPolicyFilePath = SerializationPolicyLoader.getSerializationPolicyFileName((String)(String.valueOf(contextRelativePath) + strongName));
            InputStream is = this.getServletContext().getResourceAsStream(serializationPolicyFilePath);
            if (is == null) {
                String file = "/www" + serializationPolicyFilePath.replace("/admin", "");
                this.log("Trying " + file);
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
            }
            try {
                if (is != null) {
                    try {
                        serializationPolicy = SerializationPolicyLoader.loadFromStream((InputStream)is, null);
                    }
                    catch (ParseException e) {
                        this.log("ERROR: Failed to parse the policy file '" + serializationPolicyFilePath + "'", e);
                    }
                    catch (IOException e) {
                        this.log("ERROR: Could not read the policy file '" + serializationPolicyFilePath + "'", e);
                    }
                } else {
                    String message = "ERROR: The serialization policy file '" + serializationPolicyFilePath + "' was not found; did you forget to include it in this deployment?";
                    this.log(message, null);
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return serializationPolicy;
    }

    public String processCall(RPCRequest rpcRequest) throws SerializationException {
        Method method = rpcRequest.getMethod();
        AuditContext.currentOrInternal().getProperties().put("rpc.method", String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "." + method.getName());
        this.checkPermissions(rpcRequest);
        Optional<Audit> methodAudit = Optional.ofNullable(this.methodAuditSettings.get(method));
        try {
            String result = super.processCall(rpcRequest);
            if (methodAudit.isPresent()) {
                if (result == null || result.startsWith("//EX")) {
                    this.auditLogger.warn("{} {} - Failure - {}", new Object[]{AuditContext.currentOrInternal(), methodAudit.get().componentName(), methodAudit.get().description()});
                } else {
                    this.auditLogger.info("{} {} - Success - {}", new Object[]{AuditContext.currentOrInternal(), methodAudit.get().componentName(), methodAudit.get().description()});
                }
            }
            return result;
        }
        catch (Exception e) {
            if (methodAudit.isPresent()) {
                this.auditLogger.warn("{} {} - Failure - {}", new Object[]{AuditContext.currentOrInternal(), methodAudit.get().componentName(), methodAudit.get().description()});
            }
            throw e;
        }
    }

    private void checkPermissions(RPCRequest request) {
        Method method = request.getMethod();
        Optional<RequiredPermissions> requiredPermissions = this.methodPermissionRequirements.containsKey(method) ? Optional.of(this.methodPermissionRequirements.get(method)) : this.servicePermissionRequirements;
        if (!requiredPermissions.isPresent()) {
            return;
        }
        HttpSession session = this.getThreadLocalRequest().getSession(false);
        UserManager userManager = Console.instance().getUserManager();
        Object rawUserName = session.getAttribute(Attributes.AUTORIZED_USER.getValue());
        if (!(rawUserName instanceof String)) {
            throw new KuraPermissionException();
        }
        String userName = (String)rawUserName;
        Optional<GwtUserConfig> config = userManager.getUserConfig(userName);
        if (!config.isPresent()) {
            throw new KuraPermissionException();
        }
        if (config.get().isAdmin()) {
            return;
        }
        if (requiredPermissions.get().mode() == RequiredPermissions.Mode.ALL ? !OsgiRemoteServiceServlet.containsAll(requiredPermissions.get().value(), config.get().getPermissions()) : !OsgiRemoteServiceServlet.containsAny(requiredPermissions.get().value(), config.get().getPermissions())) {
            throw new KuraPermissionException();
        }
    }

    private static boolean containsAll(String[] required, Set<String> actual) {
        String[] stringArray = required;
        int n = required.length;
        int n2 = 0;
        while (n2 < n) {
            String req = stringArray[n2];
            if (!actual.contains(req)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean containsAny(String[] required, Set<String> actual) {
        String[] stringArray = required;
        int n = required.length;
        int n2 = 0;
        while (n2 < n) {
            String req = stringArray[n2];
            if (actual.contains(req)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void doUnexpectedFailure(Throwable e) {
        if (e instanceof KuraPermissionException) {
            try {
                this.getThreadLocalResponse().sendError(403);
                return;
            }
            catch (IOException iOException) {}
        }
        super.doUnexpectedFailure(e);
    }

    private class KuraPermissionException
    extends RuntimeException {
        private static final long serialVersionUID = 7782509676228955785L;

        private KuraPermissionException() {
        }
    }
}

