/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushEventConsumer;
import org.osgi.util.pushstream.QueuePolicy;
import org.osgi.util.pushstream.SimplePushEventSource;

class SimplePushEventSourceImpl<T, U extends BlockingQueue<PushEvent<? extends T>>>
implements SimplePushEventSource<T> {
    private final Object lock = new Object();
    private final PromiseFactory promiseFactory;
    private final PromiseFactory sameThread;
    private final QueuePolicy<T, U> queuePolicy;
    private final U queue;
    private final int parallelism;
    private final Semaphore semaphore;
    private final List<PushEventConsumer<? super T>> connected = new ArrayList<PushEventConsumer<? super T>>();
    private final Runnable onClose;
    private boolean closed;
    private Deferred<Void> connectPromise;
    private boolean waitForFinishes;

    public SimplePushEventSourceImpl(PromiseFactory promiseFactory, QueuePolicy<T, U> queuePolicy, U queue, int parallelism, Runnable onClose) {
        this.promiseFactory = promiseFactory;
        this.sameThread = new PromiseFactory(PromiseFactory.inlineExecutor(), promiseFactory.scheduledExecutor());
        this.queuePolicy = queuePolicy;
        this.queue = queue;
        this.parallelism = parallelism;
        this.semaphore = new Semaphore(parallelism);
        this.onClose = onClose;
        this.closed = false;
        this.connectPromise = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AutoCloseable open(PushEventConsumer<? super T> pec) throws Exception {
        Deferred<Void> toResolve = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("This PushEventConsumer is closed");
            }
            toResolve = this.connectPromise;
            this.connectPromise = null;
            this.connected.add(pec);
        }
        if (toResolve != null) {
            toResolve.resolve(null);
        }
        return () -> this.closeConsumer(pec, PushEvent.close());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConsumer(PushEventConsumer<? super T> pec, PushEvent<T> event) {
        boolean sendClose;
        Object object = this.lock;
        synchronized (object) {
            sendClose = this.connected.remove(pec);
        }
        if (sendClose) {
            this.doSend(pec, event);
        }
    }

    private void doSend(PushEventConsumer<? super T> pec, PushEvent<T> event) {
        try {
            this.promiseFactory.executor().execute(() -> {
                long l = this.safePush(pec, event);
            });
        }
        catch (RejectedExecutionException ree) {
            if (!event.isTerminal()) {
                this.close(PushEvent.error(ree));
            }
            this.safePush(pec, event);
        }
    }

    private Promise<Long> doSendWithBackPressure(PushEventConsumer<? super T> pec, PushEvent<T> event) {
        Deferred d = this.sameThread.deferred();
        try {
            this.promiseFactory.executor().execute(() -> d.resolve((Object)(System.nanoTime() + this.safePush(pec, event))));
        }
        catch (RejectedExecutionException ree) {
            if (!event.isTerminal()) {
                this.close(PushEvent.error(ree));
                d.resolve((Object)System.nanoTime());
            }
            d.resolve((Object)(System.nanoTime() + this.safePush(pec, event)));
        }
        return d.getPromise();
    }

    private long safePush(PushEventConsumer<? super T> pec, PushEvent<T> event) {
        long backpressure;
        block4: {
            try {
                backpressure = pec.accept(event) * 1000000L;
                if (backpressure >= 0L || event.isTerminal()) break block4;
                this.closeConsumer(pec, PushEvent.close());
                return -1L;
            }
            catch (Exception e) {
                if (!event.isTerminal()) {
                    this.closeConsumer(pec, PushEvent.error(e));
                }
                return -1L;
            }
        }
        return event.isTerminal() ? -1L : backpressure;
    }

    @Override
    public void close() {
        this.close(PushEvent.close());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(PushEvent<T> event) {
        List toClose;
        Deferred<Void> toFail = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                toClose = new ArrayList<PushEventConsumer<T>>(this.connected);
                this.connected.clear();
                this.queue.clear();
                if (this.connectPromise != null) {
                    toFail = this.connectPromise;
                    this.connectPromise = null;
                }
            } else {
                toClose = Collections.emptyList();
            }
        }
        toClose.stream().forEach(pec -> this.doSend((PushEventConsumer<? super T>)pec, event));
        if (toFail != null) {
            toFail.resolveWith(this.closedConnectPromise());
        }
        this.onClose.run();
    }

    @Override
    public void publish(T t) {
        this.enqueueEvent(PushEvent.data(t));
    }

    @Override
    public void endOfStream() {
        this.enqueueEvent(PushEvent.close());
    }

    @Override
    public void error(Throwable t) {
        this.enqueueEvent(PushEvent.error(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueEvent(PushEvent<T> event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed || this.connected.isEmpty()) {
                return;
            }
        }
        try {
            boolean start;
            this.queuePolicy.doOffer(this.queue, event);
            Object object2 = this.lock;
            synchronized (object2) {
                start = !this.waitForFinishes && this.semaphore.tryAcquire();
            }
            if (start) {
                this.startWorker();
            }
        }
        catch (Exception e) {
            this.close(PushEvent.error(e));
            throw new IllegalStateException("The queue policy threw an exception", e);
        }
    }

    private void startWorker() {
        this.promiseFactory.executor().execute(() -> {
            try {
                block16: {
                    boolean resetWait;
                    Promise<Long> backPressure;
                    block17: {
                        long toWait;
                        do {
                            ArrayList<PushEventConsumer<? super T>> toCall;
                            PushEvent event;
                            Object object = this.lock;
                            synchronized (object) {
                                if (this.waitForFinishes) {
                                    this.semaphore.release();
                                    while (this.waitForFinishes) {
                                        this.lock.notifyAll();
                                        this.lock.wait();
                                    }
                                    this.semaphore.acquire();
                                }
                                if ((event = (PushEvent)this.queue.poll()) == null) {
                                    break block16;
                                }
                                if (this.connected.isEmpty()) {
                                    this.queue.clear();
                                    break block16;
                                }
                                toCall = new ArrayList<PushEventConsumer<? super T>>(this.connected);
                                if (event.isTerminal()) {
                                    this.waitForFinishes = true;
                                    resetWait = true;
                                    this.connected.clear();
                                    while (!this.semaphore.tryAcquire(this.parallelism - 1)) {
                                        this.lock.wait();
                                    }
                                } else {
                                    resetWait = false;
                                }
                            }
                            backPressure = this.deliver(toCall, event);
                            if (!backPressure.isDone()) break block17;
                            this.handleReset(resetWait);
                        } while ((toWait = (Long)backPressure.getValue() - System.nanoTime()) <= 0L);
                        this.promiseFactory.scheduledExecutor().schedule(this::startWorker, toWait, TimeUnit.NANOSECONDS);
                        return;
                    }
                    backPressure.then(p -> {
                        this.handleReset(resetWait);
                        long toWait = (Long)p.getValue() - System.nanoTime();
                        if (toWait > 0L) {
                            this.promiseFactory.scheduledExecutor().schedule(this::startWorker, toWait, TimeUnit.NANOSECONDS);
                        } else {
                            this.startWorker();
                        }
                        return p;
                    }, p -> this.close(PushEvent.error(p.getFailure())));
                    return;
                }
                this.semaphore.release();
            }
            catch (Exception e) {
                this.close(PushEvent.error(e));
            }
            if (this.queue.peek() != null && this.semaphore.tryAcquire()) {
                try {
                    this.startWorker();
                }
                catch (Exception e) {
                    this.close(PushEvent.error(e));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReset(boolean resetWait) {
        if (resetWait) {
            Object object = this.lock;
            synchronized (object) {
                this.waitForFinishes = false;
                this.lock.notifyAll();
            }
        }
    }

    private Promise<Long> deliver(List<PushEventConsumer<? super T>> toCall, PushEvent<T> event) {
        if (toCall.size() == 1) {
            return this.doCall(event, toCall.get(0));
        }
        List calls = toCall.stream().map(pec -> {
            if (this.semaphore.tryAcquire()) {
                return this.doSendWithBackPressure((PushEventConsumer<? super T>)pec, event).onResolve(() -> this.semaphore.release());
            }
            return this.doCall(event, (PushEventConsumer<? super T>)pec);
        }).collect(Collectors.toList());
        return this.sameThread.all(calls).map(l -> l.stream().max(Long::compareTo).orElseGet(() -> System.nanoTime()));
    }

    private Promise<Long> doCall(PushEvent<T> event, PushEventConsumer<? super T> pec) {
        return this.sameThread.resolved((Object)(System.nanoTime() + this.safePush(pec, event)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            return !this.connected.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<Void> connectPromise() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return this.closedConnectPromise();
            }
            if (this.connected.isEmpty()) {
                if (this.connectPromise == null) {
                    this.connectPromise = this.promiseFactory.deferred();
                }
                return this.connectPromise.getPromise();
            }
            return this.promiseFactory.resolved(null);
        }
    }

    private Promise<Void> closedConnectPromise() {
        return this.promiseFactory.failed((Throwable)new IllegalStateException("This SimplePushEventSource is closed"));
    }
}

