/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraProcessExecutionErrorException;
import org.eclipse.kura.command.PasswordCommandService;
import org.eclipse.kura.container.orchestration.ContainerInstanceDescriptor;
import org.eclipse.kura.container.orchestration.ContainerOrchestrationService;
import org.eclipse.kura.system.SystemAdminService;
import org.eclipse.kura.system.SystemService;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.ThreadComparator;
import org.eclipse.kura.web.server.ThreadGroupComparator;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtGroupedNVPair;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtDeviceService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtDeviceServiceImpl
extends OsgiRemoteServiceServlet
implements GwtDeviceService {
    private static final String DEV_JAVA = "devJava";
    private static final String DEV_SW = "devSw";
    private static final String DEV_HW = "devHw";
    private static final String DEV_INFO = "devInfo";
    private static final Logger logger = LoggerFactory.getLogger(GwtDeviceServiceImpl.class);
    private static final String UNKNOWN = "UNKNOWN";
    private static final long serialVersionUID = -4176701819112753800L;
    private static final String KURA_MODE = "org.eclipse.kura.mode";
    private static final String EMULATOR = "emulator";

    @Override
    public List<GwtGroupedNVPair> findDeviceConfiguration(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        SystemAdminService systemAdminService = ServiceLocator.getInstance().getService(SystemAdminService.class);
        try {
            Properties systemProperties = systemService.getProperties();
            pairs.add(new GwtGroupedNVPair(DEV_INFO, "devKuraVersion", systemService.getKuraVersion()));
            pairs.add(new GwtGroupedNVPair(DEV_INFO, "devClientId", systemService.getPrimaryMacAddress() != null ? systemService.getPrimaryMacAddress() : UNKNOWN));
            pairs.add(new GwtGroupedNVPair(DEV_INFO, "devDisplayName", systemService.getDeviceName()));
            pairs.add(new GwtGroupedNVPair(DEV_INFO, "devUptime", this.formatUptime(Long.parseLong(systemAdminService.getUptime()))));
            pairs.add(new GwtGroupedNVPair(DEV_INFO, "devLastWifiChannel", String.valueOf(systemService.getKuraWifiTopChannel())));
            pairs.add(new GwtGroupedNVPair(DEV_HW, "devModelName", systemService.getModelName()));
            pairs.add(new GwtGroupedNVPair(DEV_HW, "devModelId", systemService.getModelId()));
            pairs.add(new GwtGroupedNVPair(DEV_HW, "devPartNumber", systemService.getPartNumber()));
            pairs.add(new GwtGroupedNVPair(DEV_HW, "devSerialNumber", systemService.getSerialNumber()));
            pairs.add(new GwtGroupedNVPair(DEV_SW, "devFirmwareVersion", systemService.getFirmwareVersion()));
            pairs.add(new GwtGroupedNVPair(DEV_SW, "devBiosVersion", systemService.getBiosVersion()));
            pairs.add(new GwtGroupedNVPair(DEV_SW, "devOsVersion", systemService.getOsVersion()));
            pairs.add(new GwtGroupedNVPair(DEV_SW, "devOs", systemService.getOsName()));
            pairs.add(new GwtGroupedNVPair(DEV_SW, "devOsArch", systemService.getOsArch()));
            pairs.add(new GwtGroupedNVPair(DEV_JAVA, "devJvmName", systemProperties.getProperty("java.vm.name")));
            pairs.add(new GwtGroupedNVPair(DEV_JAVA, "devJvmVersion", systemProperties.getProperty("java.vm.version")));
            pairs.add(new GwtGroupedNVPair(DEV_JAVA, "devJvmProfile", String.valueOf(systemService.getJavaVendor()) + " " + systemService.getJavaVersion()));
            pairs.add(new GwtGroupedNVPair(DEV_JAVA, "devOsgiFramework", systemProperties.getProperty("org.osgi.framework.vendor")));
            pairs.add(new GwtGroupedNVPair(DEV_JAVA, "devOsgiFrameworkVersion", systemProperties.getProperty("org.osgi.framework.version")));
            if (systemService.getNumberOfProcessors() != -1) {
                pairs.add(new GwtGroupedNVPair(DEV_JAVA, "devNumProc", String.valueOf(systemService.getNumberOfProcessors())));
            }
            pairs.add(new GwtGroupedNVPair(DEV_JAVA, "devRamTot", String.valueOf(String.valueOf(systemService.getTotalMemory())) + " kB"));
            pairs.add(new GwtGroupedNVPair(DEV_JAVA, "devRamFree", String.valueOf(String.valueOf(systemService.getFreeMemory())) + " kB"));
        }
        catch (Exception e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    public ArrayList<GwtGroupedNVPair> findThreads(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
        while (rootGroup.getParent() != null) {
            rootGroup = rootGroup.getParent();
        }
        ThreadGroup[] groups = new ThreadGroup[2 * rootGroup.activeGroupCount()];
        rootGroup.enumerate(groups);
        Arrays.sort(groups, ThreadGroupComparator.getInstance());
        ThreadGroup[] threadGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadGroup group = threadGroupArray[n2];
            if (group != null) {
                StringBuilder sbGroup = new StringBuilder();
                sbGroup.append("ThreadGroup ").append(group.getName()).append(" [").append("maxprio=").append(group.getMaxPriority());
                sbGroup.append(", parent=");
                if (group.getParent() != null) {
                    sbGroup.append(group.getParent().getName());
                } else {
                    sbGroup.append('-');
                }
                sbGroup.append(", isDaemon=");
                sbGroup.append(group.isDaemon());
                sbGroup.append(", isDestroyed=");
                sbGroup.append(group.isDestroyed());
                sbGroup.append(']');
                int numThreads = group.activeCount();
                Thread[] threads = new Thread[numThreads * 2];
                group.enumerate(threads, false);
                Arrays.sort(threads, ThreadComparator.getInstance());
                Thread[] threadArray = threads;
                int n3 = threads.length;
                int n4 = 0;
                while (n4 < n3) {
                    Thread thread = threadArray[n4];
                    if (thread != null) {
                        StringBuilder sbThreadName = new StringBuilder();
                        sbThreadName.append(thread.getId()).append('/').append(thread.getName());
                        StringBuilder sbThreadValue = new StringBuilder();
                        sbThreadValue.append("priority=");
                        sbThreadValue.append(thread.getPriority());
                        sbThreadValue.append(", alive=");
                        sbThreadValue.append(thread.isAlive());
                        sbThreadValue.append(", daemon=");
                        sbThreadValue.append(thread.isDaemon());
                        sbThreadValue.append(", interrupted=");
                        sbThreadValue.append(thread.isInterrupted());
                        sbThreadValue.append(", loader=");
                        sbThreadValue.append(thread.getContextClassLoader());
                        sbThreadValue.append(']');
                        pairs.add(new GwtGroupedNVPair(sbGroup.toString(), sbThreadName.toString(), sbThreadValue.toString()));
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    public ArrayList<GwtGroupedNVPair> findSystemProperties(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        Properties kuraProps = systemService.getProperties();
        TreeSet<Object> kuraKeys = new TreeSet<Object>(kuraProps.keySet());
        for (Object e : kuraKeys) {
            pairs.add(new GwtGroupedNVPair("propsKura", e.toString(), kuraProps.get(e).toString()));
        }
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    public ArrayList<GwtGroupedNVPair> findBundles(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        Bundle[] bundles = systemService.getBundles();
        if (bundles != null) {
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                if (bundle != null) {
                    GwtGroupedNVPair pair = new GwtGroupedNVPair();
                    pair.setId(String.valueOf(bundle.getBundleId()));
                    pair.setName(this.getName(bundle));
                    pair.setStatus(this.toStateString(bundle));
                    pair.setVersion(GwtDeviceServiceImpl.getHeaderValue(bundle, "Bundle-Version"));
                    pair.setSigned(this.isSigned(bundle));
                    pairs.add(pair);
                }
                ++n2;
            }
        }
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    @Override
    public boolean checkIfContainerOrchestratorIsActive(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ContainerOrchestrationService checkIfContainerOrchestratorIsActive = ServiceLocator.getInstance().getService(ContainerOrchestrationService.class);
        return checkIfContainerOrchestratorIsActive != null;
    }

    @Override
    public List<GwtGroupedNVPair> findContainers(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList<GwtGroupedNVPair> pairs = new ArrayList<GwtGroupedNVPair>();
        try {
            ContainerOrchestrationService checkIfContainerOrchestratorIsActive = ServiceLocator.getInstance().getService(ContainerOrchestrationService.class);
            List containers = checkIfContainerOrchestratorIsActive.listContainerDescriptors();
            if (containers != null) {
                for (ContainerInstanceDescriptor container : containers) {
                    GwtGroupedNVPair pair = new GwtGroupedNVPair();
                    pair.setId(container.getContainerName());
                    pair.setName(container.getContainerImage());
                    pair.setStatus(this.containerStateToString(container));
                    pair.setVersion(container.getContainerImageTag().split(":")[0]);
                    pair.set("isFrameworkManaged", container.isFrameworkManaged());
                    pairs.add(pair);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed To List Containers", (Throwable)e);
        }
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    @Override
    public void startContainer(GwtXSRFToken xsrfToken, String containerName) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ContainerOrchestrationService containerOrchestrationService = ServiceLocator.getInstance().getService(ContainerOrchestrationService.class);
        List containers = containerOrchestrationService.listContainerDescriptors();
        logger.info("Starting container with name: {}", (Object)containerName);
        if (containers != null) {
            for (ContainerInstanceDescriptor container : containers) {
                if (!container.getContainerName().equals(containerName)) continue;
                try {
                    containerOrchestrationService.startContainer(container.getContainerId());
                }
                catch (KuraException kuraException) {
                    logger.error("Could not start container with name: {}", (Object)containerName);
                    throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
                }
                return;
            }
        }
        logger.error("Could not find container with name: {}", (Object)containerName);
        throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
    }

    @Override
    public void stopContainer(GwtXSRFToken xsrfToken, String containerName) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ContainerOrchestrationService containerOrchestrationService = ServiceLocator.getInstance().getService(ContainerOrchestrationService.class);
        List containers = containerOrchestrationService.listContainerDescriptors();
        logger.info("Stopping container with name: {}", (Object)containerName);
        if (containers != null) {
            for (ContainerInstanceDescriptor container : containers) {
                if (!container.getContainerName().equals(containerName)) continue;
                try {
                    containerOrchestrationService.stopContainer(container.getContainerId());
                }
                catch (KuraException kuraException) {
                    logger.error("Could not stop container with name: {}", (Object)containerName);
                    throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
                }
                return;
            }
        }
        logger.error("Could not find container with name: {}", (Object)containerName);
        throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
    }

    private boolean isSigned(Bundle bundle) {
        return !bundle.getSignerCertificates(1).isEmpty();
    }

    @Override
    public void startBundle(GwtXSRFToken xsrfToken, String bundleId) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        Bundle[] bundles = systemService.getBundles();
        logger.info("Starting bundle with ID: {}", (Object)bundleId);
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getBundleId() == Long.parseLong(bundleId)) {
                try {
                    b.start();
                    return;
                }
                catch (BundleException e) {
                    logger.error("Failed to start bundle {}", (Object)b.getBundleId(), (Object)e);
                    throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
                }
            }
            ++n2;
        }
        logger.error("Could not find bundle with ID: {}", (Object)bundleId);
        throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
    }

    @Override
    public void stopBundle(GwtXSRFToken xsrfToken, String bundleId) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
        Bundle[] bundles = systemService.getBundles();
        logger.info("Stopping bundle with ID: {}", (Object)bundleId);
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getBundleId() == Long.parseLong(bundleId)) {
                try {
                    b.stop();
                    return;
                }
                catch (BundleException e) {
                    logger.error("Failed to stop bundle {}", (Object)b.getBundleId(), (Object)e);
                    throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
                }
            }
            ++n2;
        }
        logger.error("Could not find bundle with ID: {}", (Object)bundleId);
        throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
    }

    @Override
    public String executeCommand(GwtXSRFToken xsrfToken, String cmd, String pwd) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        PasswordCommandService commandService = ServiceLocator.getInstance().getService(PasswordCommandService.class);
        try {
            return commandService.execute(cmd, pwd);
        }
        catch (KuraException e) {
            GwtKuraException gwtKuraException = null;
            gwtKuraException = e.getCode() == KuraErrorCode.OPERATION_NOT_SUPPORTED ? new GwtKuraException(GwtKuraErrorCode.SERVICE_NOT_ENABLED) : (e.getCode() == KuraErrorCode.CONFIGURATION_ATTRIBUTE_INVALID ? new GwtKuraException(GwtKuraErrorCode.ILLEGAL_ARGUMENT) : new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR));
            throw gwtKuraException;
        }
    }

    public ArrayList<GwtGroupedNVPair> findSystemPackages(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        ArrayList pairs = new ArrayList();
        if (!this.isEmulatorMode()) {
            SystemService systemService = ServiceLocator.getInstance().getService(SystemService.class);
            List packages = null;
            try {
                packages = systemService.getSystemPackages();
            }
            catch (KuraProcessExecutionErrorException e) {
                throw new GwtKuraException(GwtKuraErrorCode.RESOURCE_FETCHING_FAILURE, (Throwable)e);
            }
            if (packages != null) {
                packages.stream().forEach(p -> {
                    GwtGroupedNVPair pair = new GwtGroupedNVPair();
                    pair.setName(p.getName());
                    pair.setVersion(p.getVersion());
                    pair.setType(p.getTypeString());
                    pairs.add(pair);
                });
            }
        }
        return new ArrayList<GwtGroupedNVPair>(pairs);
    }

    private String getName(Bundle bundle) {
        String name = (String)bundle.getHeaders().get("Bundle-Name");
        if ((name == null || name.length() == 0) && (name = bundle.getSymbolicName()) == null && (name = bundle.getLocation()) == null) {
            name = String.valueOf(bundle.getBundleId());
        }
        return name;
    }

    private static String getHeaderValue(Bundle bundle, String headerName) {
        Object value = bundle.getHeaders().get(headerName);
        if (value != null) {
            return value.toString();
        }
        return "";
    }

    private String toStateString(Bundle bundle) {
        switch (bundle.getState()) {
            case 2: {
                return "bndInstalled";
            }
            case 4: {
                return "bndResolved";
            }
            case 8: {
                return "bndStarting";
            }
            case 32: {
                return "bndActive";
            }
            case 16: {
                return "bndStopping";
            }
            case 1: {
                return "bndUninstalled";
            }
        }
        return "bndUnknown";
    }

    private String containerStateToString(ContainerInstanceDescriptor container) {
        switch (container.getContainerState()) {
            case STARTING: {
                return "bndInstalled";
            }
            case ACTIVE: {
                return "bndActive";
            }
            case FAILED: {
                return "bndUninstalled";
            }
            case STOPPING: {
                return "bndUninstalled";
            }
        }
        return "bndUnknown";
    }

    private String formatUptime(long uptime) {
        int days = (int)TimeUnit.MILLISECONDS.toDays(uptime);
        long hours = TimeUnit.MILLISECONDS.toHours(uptime) - (long)(days * 24);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(uptime) - TimeUnit.MILLISECONDS.toHours(uptime) * 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(uptime) - TimeUnit.MILLISECONDS.toMinutes(uptime) * 60L;
        StringBuilder sb = new StringBuilder();
        sb.append(days).append(" days ").append(hours).append(":").append(minutes).append(":").append(seconds).append(" hms");
        return sb.toString();
    }

    private boolean isEmulatorMode() {
        return System.getProperty(KURA_MODE, "").equals(EMULATOR);
    }
}

