/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.http.server.manager;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.kura.util.configuration.Property;

public class HttpServiceOptions {
    static final String PROP_HTTP_PORTS = "http.ports";
    static final String PROP_HTTPS_PORTS = "https.ports";
    static final String PROP_HTTPS_CLIENT_AUTH_PORTS = "https.client.auth.ports";
    static final String PROP_REVOCATION_ENABLED = "https.revocation.check.enabled";
    static final String PROP_REVOCATION_MODE = "ssl.revocation.mode";
    static final String PROP_CRL_PATH = "https.client.crl.path";
    static final String PROP_REVOCATION_SOFT_FAIL = "https.client.revocation.soft.fail";
    static final String PROP_KEYSTORE_SERVICE = "KeystoreService.target";
    private static final Property<Integer[]> HTTP_PORTS = new Property("http.ports", (Object)new Integer[0]);
    private static final Property<Integer[]> HTTPS_PORTS = new Property("https.ports", (Object)new Integer[0]);
    private static final Property<Integer[]> HTTPS_CLIENT_AUTH_PORTS = new Property("https.client.auth.ports", (Object)new Integer[0]);
    private static final Property<Boolean> REVOCATION_ENABLED = new Property("https.revocation.check.enabled", (Object)false);
    private static final Property<String> REVOCATION_MODE = new Property("ssl.revocation.mode", (Object)RevocationCheckMode.PREFER_OCSP.name());
    private static final Property<Boolean> REVOCATION_SOFT_FAIL = new Property("https.client.revocation.soft.fail", (Object)false);
    private static final Property<String> KEYSTORE_SERVICE = new Property("KeystoreService.target", (Object)"kura.service.pid=changeit");
    private final Set<Integer> httpPorts;
    private final Set<Integer> httpsPorts;
    private final Set<Integer> httpsWithClientAuthPorts;
    private final boolean isRevocationEnabled;
    private final RevocationCheckMode revocationCheckMode;
    private final boolean isRevocationSoftFailEnabled;
    private final String keystoreServicePid;

    public HttpServiceOptions(Map<String, Object> properties, String kuraHome) {
        this.httpPorts = HttpServiceOptions.loadIntArrayProperty((Integer[])HTTP_PORTS.get(properties));
        this.httpsPorts = HttpServiceOptions.loadIntArrayProperty((Integer[])HTTPS_PORTS.get(properties));
        this.httpsWithClientAuthPorts = HttpServiceOptions.loadIntArrayProperty((Integer[])HTTPS_CLIENT_AUTH_PORTS.get(properties));
        this.isRevocationEnabled = (Boolean)REVOCATION_ENABLED.get(properties);
        this.revocationCheckMode = RevocationCheckMode.valueOf((String)REVOCATION_MODE.get(properties));
        this.isRevocationSoftFailEnabled = (Boolean)REVOCATION_SOFT_FAIL.get(properties);
        this.keystoreServicePid = (String)KEYSTORE_SERVICE.get(properties);
    }

    public Set<Integer> getHttpPorts() {
        return this.httpPorts;
    }

    public Set<Integer> getHttpsPorts() {
        return this.httpsPorts;
    }

    public Set<Integer> getHttpsClientAuthPorts() {
        return this.httpsWithClientAuthPorts;
    }

    public boolean isRevocationEnabled() {
        return this.isRevocationEnabled;
    }

    public RevocationCheckMode getRevocationCheckMode() {
        return this.revocationCheckMode;
    }

    public String getKeystoreServicePid() {
        return this.keystoreServicePid;
    }

    public boolean isRevocationSoftFailEnabled() {
        return this.isRevocationSoftFailEnabled;
    }

    private static Set<Integer> loadIntArrayProperty(Integer[] list) {
        if (list == null) {
            return Collections.emptySet();
        }
        HashSet<Integer> result = new HashSet<Integer>();
        Integer[] integerArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Integer value = integerArray[n2];
            if (value != null) {
                result.add(value);
            }
            ++n2;
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.httpPorts, this.httpsPorts, this.httpsWithClientAuthPorts, this.isRevocationEnabled, this.isRevocationSoftFailEnabled, this.keystoreServicePid, this.revocationCheckMode});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HttpServiceOptions)) {
            return false;
        }
        HttpServiceOptions other = (HttpServiceOptions)obj;
        return Objects.equals(this.httpPorts, other.httpPorts) && Objects.equals(this.httpsPorts, other.httpsPorts) && Objects.equals(this.httpsWithClientAuthPorts, other.httpsWithClientAuthPorts) && this.isRevocationEnabled == other.isRevocationEnabled && this.isRevocationSoftFailEnabled == other.isRevocationSoftFailEnabled && Objects.equals(this.keystoreServicePid, other.keystoreServicePid) && this.revocationCheckMode == other.revocationCheckMode;
    }

    public static enum RevocationCheckMode {
        PREFER_OCSP,
        PREFER_CRL,
        CRL_ONLY;

    }
}

