/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraNotConnectedException;
import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.KuraTooManyInflightMessagesException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.data.DataMessage;
import org.eclipse.kura.core.data.DataServiceListenerS;
import org.eclipse.kura.core.data.DataServiceOptions;
import org.eclipse.kura.core.data.DataStore;
import org.eclipse.kura.core.data.store.DbDataStore;
import org.eclipse.kura.core.internal.data.TokenBucket;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.data.DataTransportService;
import org.eclipse.kura.data.DataTransportToken;
import org.eclipse.kura.data.listener.DataServiceListener;
import org.eclipse.kura.data.transport.listener.DataTransportListener;
import org.eclipse.kura.db.H2DbService;
import org.eclipse.kura.status.CloudConnectionStatusComponent;
import org.eclipse.kura.status.CloudConnectionStatusEnum;
import org.eclipse.kura.status.CloudConnectionStatusService;
import org.eclipse.kura.watchdog.CriticalComponent;
import org.eclipse.kura.watchdog.WatchdogService;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataServiceImpl
implements DataService,
DataTransportListener,
ConfigurableComponent,
CloudConnectionStatusComponent,
CriticalComponent {
    private static final Logger logger = LoggerFactory.getLogger(DataServiceImpl.class);
    private static final int TRANSPORT_TASK_TIMEOUT = 1;
    private DataServiceOptions dataServiceOptions;
    private DataTransportService dataTransportService;
    private H2DbService dbService;
    private DataServiceListenerS dataServiceListeners;
    protected ScheduledExecutorService connectionMonitorExecutor;
    private ScheduledFuture<?> connectionMonitorFuture;
    private ExecutorService publisherExecutor;
    private DataStore store;
    private Map<DataTransportToken, Integer> inFlightMsgIds;
    private ScheduledExecutorService congestionExecutor;
    private ScheduledFuture<?> congestionFuture;
    private CloudConnectionStatusService cloudConnectionStatusService;
    private CloudConnectionStatusEnum notificationStatus = CloudConnectionStatusEnum.OFF;
    private TokenBucket throttle;
    private final Lock lock = new ReentrantLock();
    private boolean notifyPending;
    private final Condition lockCondition = this.lock.newCondition();
    private final AtomicBoolean publisherEnabled = new AtomicBoolean();
    private ServiceTracker<H2DbService, H2DbService> dbServiceTracker;
    private ComponentContext componentContext;
    private WatchdogService watchdogService;
    private AtomicInteger connectionAttempts;

    protected void activate(ComponentContext componentContext, Map<String, Object> properties) {
        String pid = (String)properties.get("kura.service.pid");
        logger.info("Activating {}...", (Object)pid);
        this.componentContext = componentContext;
        this.dataServiceOptions = new DataServiceOptions(properties);
        this.connectionMonitorExecutor = Executors.newSingleThreadScheduledExecutor();
        this.publisherExecutor = Executors.newSingleThreadExecutor();
        this.congestionExecutor = Executors.newSingleThreadScheduledExecutor();
        this.createThrottle();
        this.submitPublishingWork();
        this.store = new DbDataStore(pid);
        this.restartDbServiceTracker(this.dataServiceOptions.getDbServiceInstancePid());
        this.dataServiceListeners = new DataServiceListenerS(componentContext);
        this.cloudConnectionStatusService.register((CloudConnectionStatusComponent)this);
        this.dataTransportService.addDataTransportListener((DataTransportListener)this);
        this.startConnectionMonitorTask();
    }

    private void restartDbServiceTracker(String kuraServicePid) {
        this.stopDbServiceTracker();
        try {
            Filter filter = FrameworkUtil.createFilter((String)("(kura.service.pid=" + kuraServicePid + ")"));
            this.dbServiceTracker = new ServiceTracker(this.componentContext.getBundleContext(), filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<H2DbService, H2DbService>(){

                public H2DbService addingService(ServiceReference<H2DbService> reference) {
                    logger.info("H2DbService instance found");
                    H2DbService contextDbService = (H2DbService)DataServiceImpl.this.componentContext.getBundleContext().getService(reference);
                    DataServiceImpl.this.setH2DbService(contextDbService);
                    return contextDbService;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void modifiedService(ServiceReference<H2DbService> reference, H2DbService service) {
                    logger.info("H2DbService instance updated, recreating table if needed...");
                    DataServiceImpl dataServiceImpl = DataServiceImpl.this;
                    synchronized (dataServiceImpl) {
                        DataServiceImpl.this.store.update(DataServiceImpl.this.dataServiceOptions.getStoreHousekeeperInterval(), DataServiceImpl.this.dataServiceOptions.getStorePurgeAge(), DataServiceImpl.this.dataServiceOptions.getStoreCapacity());
                    }
                }

                public void removedService(ServiceReference<H2DbService> reference, H2DbService service) {
                    logger.info("H2DbService instance removed");
                    DataServiceImpl.this.unsetH2DbService(DataServiceImpl.this.dbService);
                    DataServiceImpl.this.componentContext.getBundleContext().ungetService(reference);
                }
            });
            this.dbServiceTracker.open();
        }
        catch (InvalidSyntaxException e) {
            throw new ComponentException((Throwable)e);
        }
    }

    private void stopDbServiceTracker() {
        if (this.dbServiceTracker != null) {
            this.dbServiceTracker.close();
            this.dbServiceTracker = null;
        }
    }

    private synchronized void startDbStore() {
        try {
            this.store.start(this.dbService, this.dataServiceOptions.getStoreHousekeeperInterval(), this.dataServiceOptions.getStorePurgeAge(), this.dataServiceOptions.getStoreCapacity());
            List<DataMessage> inFlightMsgs = this.store.allInFlightMessagesNoPayload();
            this.inFlightMsgIds = new ConcurrentHashMap<DataTransportToken, Integer>();
            if (inFlightMsgs != null) {
                for (DataMessage message : inFlightMsgs) {
                    DataTransportToken token = new DataTransportToken(message.getPublishedMessageId(), message.getSessionId());
                    this.inFlightMsgIds.put(token, message.getId());
                    logger.debug("Restored in-fligh messages from store. Topic: {}, ID: {}, MQTT message ID: {}", new Object[]{message.getTopic(), message.getId(), message.getPublishedMessageId()});
                }
            }
        }
        catch (KuraStoreException e) {
            logger.error("Failed to start store", (Throwable)e);
        }
    }

    public synchronized void updated(Map<String, Object> properties) {
        logger.info("Updating {}...", properties.get("kura.service.pid"));
        this.stopConnectionMonitorTask();
        String oldDbServicePid = this.dataServiceOptions.getDbServiceInstancePid();
        this.dataServiceOptions = new DataServiceOptions(properties);
        this.createThrottle();
        String currentDbServicePid = this.dataServiceOptions.getDbServiceInstancePid();
        if (oldDbServicePid.equals(currentDbServicePid)) {
            if (this.dbService != null) {
                this.store.update(this.dataServiceOptions.getStoreHousekeeperInterval(), this.dataServiceOptions.getStorePurgeAge(), this.dataServiceOptions.getStoreCapacity());
            }
        } else {
            this.restartDbServiceTracker(currentDbServicePid);
        }
        if (!this.dataTransportService.isConnected()) {
            this.startConnectionMonitorTask();
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        logger.info("Deactivating {}...", (Object)this.dataServiceOptions.getKuraServicePid());
        this.stopConnectionMonitorTask();
        this.connectionMonitorExecutor.shutdownNow();
        this.congestionExecutor.shutdownNow();
        this.disconnect();
        try {
            Thread.sleep(1000L);
            this.publisherEnabled.set(false);
            this.signalPublisher();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.info("Interrupted", (Throwable)e);
        }
        this.publisherExecutor.shutdownNow();
        this.dataTransportService.removeDataTransportListener((DataTransportListener)this);
        this.store.stop();
        this.stopDbServiceTracker();
    }

    public void setDataTransportService(DataTransportService dataTransportService) {
        this.dataTransportService = dataTransportService;
    }

    public void unsetDataTransportService(DataTransportService dataTransportService) {
        this.dataTransportService = null;
    }

    public synchronized void setH2DbService(H2DbService dbService) {
        this.dbService = dbService;
        this.startDbStore();
        this.signalPublisher();
    }

    public synchronized void unsetH2DbService(H2DbService dbService) {
        this.dbService = null;
        this.disconnect();
        this.store.stop();
    }

    public void setCloudConnectionStatusService(CloudConnectionStatusService cloudConnectionStatusService) {
        this.cloudConnectionStatusService = cloudConnectionStatusService;
    }

    public void unsetCloudConnectionStatusService(CloudConnectionStatusService cloudConnectionStatusService) {
        this.cloudConnectionStatusService = null;
    }

    public void setWatchdogService(WatchdogService watchdogService) {
        this.watchdogService = watchdogService;
    }

    public void unsetWatchdogService(WatchdogService watchdogService) {
        this.watchdogService = null;
    }

    public void addDataServiceListener(DataServiceListener listener) {
        this.dataServiceListeners.add(listener);
    }

    public void removeDataServiceListener(DataServiceListener listener) {
        this.dataServiceListeners.remove(listener);
    }

    public void onConnectionEstablished(boolean newSession) {
        logger.info("Notified connected");
        this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.ON);
        if (newSession) {
            if (this.dataServiceOptions.isPublishInFlightMessages()) {
                logger.info("New session established. Unpublishing all in-flight messages. Disregarding the QoS level, this may cause duplicate messages.");
                try {
                    this.store.unpublishAllInFlighMessages();
                    this.inFlightMsgIds.clear();
                }
                catch (KuraStoreException e) {
                    logger.error("Failed to unpublish in-flight messages", (Throwable)e);
                }
            } else {
                logger.info("New session established. Dropping all in-flight messages.");
                try {
                    this.store.dropAllInFlightMessages();
                    this.inFlightMsgIds.clear();
                }
                catch (KuraStoreException e) {
                    logger.error("Failed to drop in-flight messages", (Throwable)e);
                }
            }
        }
        this.dataServiceListeners.onConnectionEstablished();
        this.signalPublisher();
    }

    public void onDisconnecting() {
        logger.info("Notified disconnecting");
        this.dataServiceListeners.onDisconnecting();
    }

    public void onDisconnected() {
        logger.info("Notified disconnected");
        this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.OFF);
        this.dataServiceListeners.onDisconnected();
    }

    public void onConfigurationUpdating(boolean wasConnected) {
        logger.info("Notified DataTransportService configuration updating...");
        this.stopConnectionMonitorTask();
        this.disconnect(0L);
    }

    public void onConfigurationUpdated(boolean wasConnected) {
        logger.info("Notified DataTransportService configuration updated.");
        boolean autoConnect = this.startConnectionMonitorTask();
        if (!autoConnect && wasConnected) {
            try {
                this.connect();
            }
            catch (KuraConnectException e) {
                logger.error("Error during re-connect after configuration update.", (Throwable)e);
            }
        }
    }

    public void onConnectionLost(Throwable cause) {
        logger.info("connectionLost");
        this.stopConnectionMonitorTask();
        this.startConnectionMonitorTask();
        this.dataServiceListeners.onConnectionLost(cause);
    }

    public void onMessageArrived(String topic, byte[] payload, int qos, boolean retained) {
        logger.debug("Message arrived on topic: {}", (Object)topic);
        this.dataServiceListeners.onMessageArrived(topic, payload, qos, retained);
        this.signalPublisher();
    }

    public synchronized void onMessageConfirmed(DataTransportToken token) {
        logger.debug("Confirmed message with MQTT message ID: {} on session ID: {}", (Object)token.getMessageId(), (Object)token.getSessionId());
        Integer messageId = this.inFlightMsgIds.remove(token);
        if (messageId == null) {
            logger.info("Confirmed message published with MQTT message ID: {} not tracked in the map of in-flight messages", (Object)token.getMessageId());
        } else {
            DataMessage confirmedMessage = null;
            try {
                logger.info("Confirmed message ID: {} to store", (Object)messageId);
                this.store.confirmed(messageId);
                confirmedMessage = this.store.get(messageId);
            }
            catch (KuraStoreException e) {
                logger.error("Cannot confirm message to store", (Throwable)e);
            }
            if (confirmedMessage != null) {
                String topic = confirmedMessage.getTopic();
                this.dataServiceListeners.onMessageConfirmed(messageId, topic);
            } else {
                logger.error("Confirmed Message with ID {} could not be loaded from the DataStore.", (Object)messageId);
            }
        }
        if (this.inFlightMsgIds.size() < this.dataServiceOptions.getMaxInFlightMessages()) {
            this.handleInFlightDecongestion();
        }
        this.signalPublisher();
    }

    public void connect() throws KuraConnectException {
        this.stopConnectionMonitorTask();
        if (this.dbService == null) {
            throw new KuraConnectException((Object)"H2DbService instance not attached, not connecting");
        }
        if (!this.dataTransportService.isConnected()) {
            this.dataTransportService.connect();
        }
    }

    public boolean isConnected() {
        return this.dataTransportService.isConnected();
    }

    public boolean isAutoConnectEnabled() {
        return this.dataServiceOptions.isAutoConnect();
    }

    public int getRetryInterval() {
        return this.dataServiceOptions.getConnectDelay();
    }

    public void disconnect(long quiesceTimeout) {
        this.stopConnectionMonitorTask();
        this.dataTransportService.disconnect(quiesceTimeout);
    }

    public void subscribe(String topic, int qos) throws KuraException {
        this.dataTransportService.subscribe(topic, qos);
    }

    public void unsubscribe(String topic) throws KuraException {
        this.dataTransportService.unsubscribe(topic);
    }

    public int publish(String topic, byte[] payload, int qos, boolean retain, int priority) throws KuraStoreException {
        logger.info("Storing message on topic: {}, priority: {}", (Object)topic, (Object)priority);
        DataMessage dataMsg = this.store.store(topic, payload, qos, retain, priority);
        logger.info("Stored message on topic: {}, priority: {}", (Object)topic, (Object)priority);
        this.signalPublisher();
        return dataMsg.getId();
    }

    public List<Integer> getUnpublishedMessageIds(String topicRegex) throws KuraStoreException {
        List<DataMessage> messages = this.store.allUnpublishedMessagesNoPayload();
        return this.buildMessageIds(messages, topicRegex);
    }

    public List<Integer> getInFlightMessageIds(String topicRegex) throws KuraStoreException {
        List<DataMessage> messages = this.store.allInFlightMessagesNoPayload();
        return this.buildMessageIds(messages, topicRegex);
    }

    public List<Integer> getDroppedInFlightMessageIds(String topicRegex) throws KuraStoreException {
        List<DataMessage> messages = this.store.allDroppedInFlightMessagesNoPayload();
        return this.buildMessageIds(messages, topicRegex);
    }

    private void signalPublisher() {
        this.lock.lock();
        this.notifyPending = true;
        this.lockCondition.signal();
        this.lock.unlock();
    }

    private boolean startConnectionMonitorTask() {
        if (this.connectionMonitorFuture != null && !this.connectionMonitorFuture.isDone()) {
            logger.error("Reconnect task already running");
            throw new IllegalStateException("Reconnect task already running");
        }
        boolean autoConnect = this.dataServiceOptions.isAutoConnect();
        int reconnectInterval = this.dataServiceOptions.getConnectDelay();
        if (autoConnect) {
            if (this.dataServiceOptions.isConnectionRecoveryEnabled()) {
                this.watchdogService.registerCriticalComponent((CriticalComponent)this);
                this.watchdogService.checkin((CriticalComponent)this);
                this.connectionAttempts = new AtomicInteger(0);
            }
            this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.SLOW_BLINKING);
            int maxDelay = reconnectInterval / 5;
            maxDelay = maxDelay > 0 ? maxDelay : 1;
            int initialDelay = new Random().nextInt(maxDelay);
            logger.info("Starting reconnect task with initial delay {}", (Object)initialDelay);
            this.connectionMonitorFuture = this.connectionMonitorExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName("DataServiceImpl:ReconnectTask:" + DataServiceImpl.this.dataServiceOptions.getKuraServicePid());
                    boolean connected = false;
                    try {
                        if (DataServiceImpl.this.dbService == null) {
                            logger.warn("H2DbService instance not attached, not connecting");
                            return;
                        }
                        try {
                            logger.info("Connecting...");
                            if (DataServiceImpl.this.dataTransportService.isConnected()) {
                                logger.info("Already connected. Reconnect task will be terminated.");
                            } else {
                                DataServiceImpl.this.dataTransportService.connect();
                                logger.info("Connected. Reconnect task will be terminated.");
                            }
                            connected = true;
                        }
                        catch (KuraConnectException e) {
                            logger.warn("Connect failed", (Throwable)e);
                            if (DataServiceImpl.this.dataServiceOptions.isConnectionRecoveryEnabled()) {
                                if (this.isAuthenticationException(e) || DataServiceImpl.this.connectionAttempts.getAndIncrement() < DataServiceImpl.this.dataServiceOptions.getRecoveryMaximumAllowedFailures()) {
                                    logger.info("Checkin done.");
                                    DataServiceImpl.this.watchdogService.checkin((CriticalComponent)DataServiceImpl.this);
                                } else {
                                    logger.info("Maximum number of connection attempts reached. Requested reboot...");
                                }
                            }
                            if (connected) {
                                DataServiceImpl.this.unregisterAsCriticalComponent();
                                throw new RuntimeException("Connected. Reconnect task will be terminated.");
                            }
                        }
                    }
                    finally {
                        if (connected) {
                            DataServiceImpl.this.unregisterAsCriticalComponent();
                            throw new RuntimeException("Connected. Reconnect task will be terminated.");
                        }
                    }
                }

                private boolean isAuthenticationException(KuraConnectException e) {
                    MqttException mqttException;
                    boolean authenticationException = false;
                    if (e.getCause() instanceof MqttException && ((mqttException = (MqttException)e.getCause()).getReasonCode() == 4 || mqttException.getReasonCode() == 2 || mqttException.getReasonCode() == 5)) {
                        logger.info("Authentication exception encountered.");
                        authenticationException = true;
                    }
                    return authenticationException;
                }
            }, initialDelay, reconnectInterval, TimeUnit.SECONDS);
        } else {
            this.cloudConnectionStatusService.updateStatus((CloudConnectionStatusComponent)this, CloudConnectionStatusEnum.OFF);
            this.unregisterAsCriticalComponent();
        }
        return autoConnect;
    }

    private void createThrottle() {
        if (this.dataServiceOptions.isRateLimitEnabled()) {
            int publishRate = this.dataServiceOptions.getRateLimitAverageRate();
            int burstLength = this.dataServiceOptions.getRateLimitBurstSize();
            long publishPeriod = this.dataServiceOptions.getRateLimitTimeUnit() / (long)publishRate;
            logger.info("Get Throttle with burst length {} and send a message every {} nanoseconds", (Object)burstLength, (Object)publishPeriod);
            this.throttle = new TokenBucket(burstLength, publishPeriod);
        }
    }

    private void stopConnectionMonitorTask() {
        if (this.connectionMonitorFuture != null && !this.connectionMonitorFuture.isDone()) {
            logger.info("Reconnect task running. Stopping it");
            this.connectionMonitorFuture.cancel(true);
        }
        this.unregisterAsCriticalComponent();
    }

    private void unregisterAsCriticalComponent() {
        this.watchdogService.unregisterCriticalComponent((CriticalComponent)this);
    }

    private void disconnect() {
        long millis = (long)this.dataServiceOptions.getDisconnectDelay() * 1000L;
        this.dataTransportService.disconnect(millis);
    }

    private void submitPublishingWork() {
        this.publisherEnabled.set(true);
        this.publisherExecutor.execute(new PublishManager());
    }

    private synchronized void publishInternal(DataMessage message) throws KuraException {
        String topic = message.getTopic();
        byte[] payload = message.getPayload();
        int qos = message.getQos();
        boolean retain = message.isRetain();
        int msgId = message.getId();
        logger.debug("Publishing message with ID: {} on topic: {}, priority: {}", new Object[]{msgId, topic, message.getPriority()});
        DataTransportToken token = this.dataTransportService.publish(topic, payload, qos, retain);
        if (token == null) {
            this.store.published(msgId);
            logger.debug("Published message with ID: {}", (Object)msgId);
        } else {
            Integer trackedMsgId = this.inFlightMsgIds.get(token);
            if (trackedMsgId != null) {
                logger.error("Token already tracked: {} - {}", (Object)token.getSessionId(), (Object)token.getMessageId());
            }
            this.inFlightMsgIds.put(token, msgId);
            this.store.published(msgId, token.getMessageId(), token.getSessionId());
            logger.debug("Published message with ID: {} and MQTT message ID: {}", (Object)msgId, (Object)token.getMessageId());
        }
    }

    private List<Integer> buildMessageIds(List<DataMessage> messages, String topicRegex) {
        Pattern topicPattern = Pattern.compile(topicRegex);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        if (messages != null) {
            for (DataMessage message : messages) {
                String topic = message.getTopic();
                if (!topicPattern.matcher(topic).matches()) continue;
                ids.add(message.getId());
            }
        }
        return ids;
    }

    private void handleInFlightDecongestion() {
        if (this.congestionFuture != null && !this.congestionFuture.isDone()) {
            this.congestionFuture.cancel(true);
        }
    }

    public int getNotificationPriority() {
        return 100;
    }

    public CloudConnectionStatusEnum getNotificationStatus() {
        return this.notificationStatus;
    }

    public void setNotificationStatus(CloudConnectionStatusEnum status) {
        this.notificationStatus = status;
    }

    public String getCriticalComponentName() {
        return "DataServiceImpl";
    }

    public int getCriticalComponentTimeout() {
        return this.dataServiceOptions.getCriticalComponentTimeout();
    }

    public Map<String, String> getConnectionInfo() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Broker URL", this.dataTransportService.getBrokerUrl());
        result.put("Account", this.dataTransportService.getAccountName());
        result.put("Username", this.dataTransportService.getUsername());
        result.put("Client ID", this.dataTransportService.getClientId());
        return result;
    }

    private final class PublishManager
    implements Runnable {
        private PublishManager() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("DataServiceImpl:Submit");
            while (DataServiceImpl.this.publisherEnabled.get()) {
                boolean messagePublished;
                long sleepingTime;
                block8: {
                    sleepingTime = -1L;
                    messagePublished = false;
                    if (DataServiceImpl.this.dataTransportService.isConnected()) {
                        try {
                            DataMessage message = DataServiceImpl.this.store.getNextMessage();
                            if (message == null) break block8;
                            this.checkInFlightMessages(message);
                            if (DataServiceImpl.this.dataServiceOptions.isRateLimitEnabled() && message.getPriority() >= 5) {
                                messagePublished = this.publishMessageTokenBucket(message);
                                sleepingTime = DataServiceImpl.this.throttle.getTokenWaitTime();
                                break block8;
                            }
                            this.publishMessageUnbound(message);
                            messagePublished = true;
                        }
                        catch (KuraNotConnectedException kuraNotConnectedException) {
                            logger.info("DataPublisherService is not connected");
                        }
                        catch (KuraTooManyInflightMessagesException kuraTooManyInflightMessagesException) {
                            logger.info("Too many in-flight messages");
                            this.handleInFlightCongestion();
                        }
                        catch (Exception e) {
                            logger.error("Probably an unrecoverable exception", (Throwable)e);
                        }
                    } else {
                        logger.info("DataPublisherService not connected");
                    }
                }
                if (messagePublished) continue;
                this.suspendPublisher(sleepingTime, TimeUnit.NANOSECONDS);
            }
            logger.debug("Exited publisher loop.");
        }

        private void checkInFlightMessages(DataMessage message) throws KuraTooManyInflightMessagesException {
            if (message.getQos() > 0 && DataServiceImpl.this.inFlightMsgIds.size() >= DataServiceImpl.this.dataServiceOptions.getMaxInFlightMessages()) {
                logger.warn("The configured maximum number of in-flight messages has been reached");
                throw new KuraTooManyInflightMessagesException((Object)"Too many in-flight messages");
            }
        }

        private void suspendPublisher(long timeout, TimeUnit timeUnit) {
            if (!DataServiceImpl.this.publisherEnabled.get()) {
                return;
            }
            try {
                try {
                    DataServiceImpl.this.lock.lock();
                    if (!DataServiceImpl.this.notifyPending) {
                        if (timeout == -1L) {
                            logger.debug("Suspending publishing thread indefinitely");
                            DataServiceImpl.this.lockCondition.await();
                        } else {
                            logger.debug("Suspending publishing thread for {} nanoseconds", (Object)timeout);
                            DataServiceImpl.this.lockCondition.await(timeout, timeUnit);
                        }
                    }
                    DataServiceImpl.this.notifyPending = false;
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    DataServiceImpl.this.lock.unlock();
                }
            }
            finally {
                DataServiceImpl.this.lock.unlock();
            }
        }

        private void publishMessageUnbound(DataMessage message) throws KuraException {
            DataServiceImpl.this.publishInternal(message);
            DataServiceImpl.this.dataServiceListeners.onMessagePublished(message.getId(), message.getTopic());
        }

        private boolean publishMessageTokenBucket(DataMessage message) throws KuraException {
            boolean tokenAvailable = DataServiceImpl.this.throttle.getToken();
            if (tokenAvailable) {
                this.publishMessageUnbound(message);
                return true;
            }
            return false;
        }

        private void handleInFlightCongestion() {
            int timeout = DataServiceImpl.this.dataServiceOptions.getInFlightMessagesCongestionTimeout();
            if (timeout != 0 && (DataServiceImpl.this.congestionFuture == null || DataServiceImpl.this.congestionFuture.isDone())) {
                logger.warn("In-flight message congestion timeout started");
                DataServiceImpl.this.congestionFuture = DataServiceImpl.this.congestionExecutor.schedule(() -> {
                    Thread.currentThread().setName("DataServiceImpl:InFlightCongestion");
                    logger.warn("In-flight message congestion timeout elapsed. Disconnecting and reconnecting again");
                    DataServiceImpl.this.disconnect();
                    DataServiceImpl.this.startConnectionMonitorTask();
                }, (long)timeout, TimeUnit.SECONDS);
            }
        }
    }
}

