/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.wires;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.configuration.Configurations;
import org.eclipse.kura.web.client.configuration.HasConfiguration;
import org.eclipse.kura.web.client.ui.ConfigurableComponentUi;
import org.eclipse.kura.web.client.ui.drivers.assets.AssetConfigurationUi;
import org.eclipse.kura.web.client.ui.drivers.assets.AssetModelImpl;
import org.eclipse.kura.web.client.ui.wires.WiresPanelUi;
import org.eclipse.kura.web.shared.AssetConstants;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;

public class ConfigurationAreaUi
extends Composite {
    private static ConfigurationAreaUiUiBinder uiBinder = (ConfigurationAreaUiUiBinder)GWT.create(ConfigurationAreaUiUiBinder.class);
    private ConfigurableComponentUi genericWireComponentUi;
    private AssetConfigurationUi assetWireComponentUi;
    @UiField
    TabListItem tab1NavTab;
    @UiField
    TabListItem tab2NavTab;
    @UiField
    TabPane tab1Pane;
    @UiField
    TabPane tab2Pane;

    public ConfigurationAreaUi(HasConfiguration hasConfiguration, Configurations configurations) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        if (!this.initFromExistingUi(hasConfiguration)) {
            this.createNewUi(hasConfiguration, configurations);
        }
        if (this.assetWireComponentUi != null) {
            this.tab1Pane.add((Widget)this.assetWireComponentUi);
            this.tab1NavTab.setText(this.assetWireComponentUi.getTitle());
            this.tab2NavTab.setVisible(true);
            this.tab2NavTab.setText(this.genericWireComponentUi.getTitle());
            this.tab2Pane.add((Widget)this.genericWireComponentUi);
        } else {
            this.tab2NavTab.setVisible(false);
            this.tab1Pane.add((Widget)this.genericWireComponentUi);
            this.tab1NavTab.setText(this.genericWireComponentUi.getTitle());
        }
    }

    private boolean initFromExistingUi(HasConfiguration hasConfiguration) {
        if (hasConfiguration instanceof AssetConfigurationUi) {
            this.assetWireComponentUi = (AssetConfigurationUi)hasConfiguration;
            this.genericWireComponentUi = (ConfigurableComponentUi)this.assetWireComponentUi.getAssociatedView();
            return true;
        }
        if (hasConfiguration instanceof ConfigurableComponentUi) {
            this.genericWireComponentUi = (ConfigurableComponentUi)hasConfiguration;
            return true;
        }
        return false;
    }

    private void createNewUi(HasConfiguration hasConfiguration, Configurations configurations) {
        GwtConfigComponent configuration = hasConfiguration.getConfiguration();
        String driverPid = configuration.getParameterValue(AssetConstants.ASSET_DRIVER_PROP.value());
        if (driverPid != null) {
            HasConfiguration driverConfiguration = configurations.getConfiguration(driverPid);
            if (driverConfiguration instanceof ConfigurableComponentUi) {
                this.genericWireComponentUi = (ConfigurableComponentUi)driverConfiguration;
            } else {
                this.genericWireComponentUi = new ConfigurableComponentUi(driverConfiguration.getConfiguration());
                this.genericWireComponentUi.setTitle("Driver - " + driverPid);
                this.genericWireComponentUi.renderForm();
            }
            AssetModelImpl assetModel = new AssetModelImpl(hasConfiguration.getConfiguration(), configurations.getChannelDescriptor(driverPid), configurations.getBaseChannelDescriptor());
            this.assetWireComponentUi = new AssetConfigurationUi(assetModel, (Widget)this.genericWireComponentUi, configurations);
            this.assetWireComponentUi.setTitle(String.valueOf(WiresPanelUi.getComponentLabel(configuration)) + " - " + configuration.getComponentId());
            this.assetWireComponentUi.renderForm();
        } else {
            this.genericWireComponentUi = new ConfigurableComponentUi(hasConfiguration.getConfiguration());
            this.genericWireComponentUi.setTitle(String.valueOf(WiresPanelUi.getComponentLabel(configuration)) + " - " + configuration.getComponentId());
            this.genericWireComponentUi.renderForm();
        }
    }

    public void setListener(HasConfiguration.Listener listener) {
        if (this.assetWireComponentUi != null) {
            this.assetWireComponentUi.setListener(listener);
        }
        this.genericWireComponentUi.setListener(listener);
    }

    static interface ConfigurationAreaUiUiBinder
    extends UiBinder<Widget, ConfigurationAreaUi> {
    }
}

