/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.chain;

import java.util.ArrayList;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationElement;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.element.IGenerationElementInnerConfiguration;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.conf.global.GenerationConfigurationRegistry;

public final class GenerationChainConfiguration {
    public static void configure(GenerationChain generationchain, boolean clean) {
        GenerationChainConfiguration.innerConfiguration(generationchain, clean);
        GenerationChainConfiguration.dependenciesConfiguration(generationchain);
    }

    private static void dependenciesConfiguration(GenerationChain generationchain) {
    }

    private static void innerConfiguration(GenerationChain generationchain, boolean clean) {
        ArrayList<GenerationElement> elementToRemove = new ArrayList<GenerationElement>();
        for (GenerationElement element : generationchain.getElements()) {
            IGenerationElementInnerConfiguration configuration = GenerationConfigurationRegistry.getInnerConfigurationFor(element);
            if (configuration == null) continue;
            if (configuration.isRelevant(generationchain, element)) {
                configuration.configure(element);
                continue;
            }
            if (!clean) continue;
            elementToRemove.add(element);
        }
        if (!elementToRemove.isEmpty()) {
            for (GenerationElement generationElement : elementToRemove) {
                GenerationChainConfiguration.removeGenerationElementFrom(generationchain, generationElement);
            }
        }
    }

    private static boolean removeGenerationElementFrom(GenerationChain generationchain, GenerationElement element) {
        boolean elementFound = false;
        boolean done = false;
        for (GenerationElement iElement : generationchain.getElements()) {
            if (iElement instanceof GenerationChain) {
                done = GenerationChainConfiguration.removeGenerationElementFrom((GenerationChain)iElement, element);
                if (!done) continue;
                return true;
            }
            if (!iElement.equals(element)) continue;
            elementFound = true;
            break;
        }
        if (elementFound) {
            generationchain.getElements().remove((Object)element);
            return true;
        }
        return false;
    }
}

