/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.grammarAccess;

import com.google.common.collect.Maps;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextRuntimeModule;
import org.eclipse.xtext.formatting.ILineSeparatorInformation;
import org.eclipse.xtext.generator.Naming;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.service.CompoundModule;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xtext.RuleNames;
import org.eclipse.xtext.xtext.generator.grammarAccess.GrammarAccessExtensions;

@Deprecated(forRemoval=true)
public class GrammarAccessUtil {
    private static Map<String, ISerializer> xtextSerializerByLineDelimiter = Maps.newHashMapWithExpectedSize((int)2);

    public static String getClassName(EObject obj) {
        return obj.eClass().getName();
    }

    private static List<String> getElementDescription(AbstractElement element) {
        ArrayList<String> result = new ArrayList<String>();
        AbstractElement container = element;
        while (container != null) {
            result.addAll(0, GrammarAccessUtil.getSingleElementDescription(container));
            container = container.eContainer() instanceof AbstractElement ? (AbstractElement)container.eContainer() : null;
        }
        return result;
    }

    private static List<String> getSingleElementDescription(AbstractElement ele) {
        if (ele instanceof Keyword) {
            return Collections.singletonList(((Keyword)ele).getValue());
        }
        if (ele instanceof Assignment) {
            return Collections.singletonList(((Assignment)ele).getFeature());
        }
        if (ele instanceof RuleCall) {
            return Collections.singletonList(((RuleCall)ele).getRule().getName());
        }
        if (ele instanceof Action) {
            Action a = (Action)ele;
            ArrayList<String> r = new ArrayList<String>();
            if (a.getType() != null && a.getType().getClassifier() != null) {
                r.add(a.getType().getClassifier().getName());
            }
            if (a.getFeature() != null && !"".equals(a.getFeature())) {
                r.add(a.getFeature());
            }
            return r;
        }
        if (ele instanceof CrossReference) {
            CrossReference cr = (CrossReference)ele;
            if (cr.getType() != null && cr.getType().getClassifier() != null) {
                return Collections.singletonList(cr.getType().getClassifier().getName());
            }
        } else if (ele instanceof EnumLiteralDeclaration) {
            EnumLiteralDeclaration decl = (EnumLiteralDeclaration)ele;
            return Collections.singletonList(decl.getEnumLiteral().getName());
        }
        return Collections.emptyList();
    }

    public static String serialize(EObject obj, String prefix) {
        return GrammarAccessUtil.serialize(obj, prefix, Strings.newLine());
    }

    public static String serialize(EObject obj, String prefix, String lineDelimiter) {
        ISerializer serializer = GrammarAccessUtil.getSerializer(lineDelimiter);
        String result = GrammarAccessExtensions.grammarFragmentToString((ISerializer)serializer, (EObject)obj, (String)prefix);
        return result;
    }

    private static ISerializer getSerializer(final String delimiter) {
        ISerializer result = xtextSerializerByLineDelimiter.get(delimiter);
        if (result != null) {
            return result;
        }
        ILineSeparatorInformation lineSeparatorInformation = new ILineSeparatorInformation(){

            public String getLineSeparator() {
                return delimiter;
            }
        };
        Injector injector = Guice.createInjector((Module[])new Module[]{new LineSeparatorModule(lineSeparatorInformation)});
        result = (ISerializer)injector.getInstance(ISerializer.class);
        xtextSerializerByLineDelimiter.put(delimiter, result);
        return result;
    }

    private static String getElementPath(AbstractElement ele) {
        AbstractElement obj = ele;
        StringBuffer buf = new StringBuffer();
        while (!(obj.eContainer() instanceof AbstractRule) && obj.eContainer() != null) {
            EObject tmp = obj.eContainer();
            buf.insert(0, tmp.eContents().indexOf((Object)obj));
            buf.insert(0, "_");
            obj = tmp;
        }
        return buf.toString();
    }

    private static String getElementTypeDescription(AbstractElement ele) {
        if (ele instanceof RuleCall) {
            AbstractRule r = ((RuleCall)ele).getRule();
            return r.eClass().getName() + "Call";
        }
        return ele.eClass().getName();
    }

    public static String getGrammarAccessFQName(Grammar grammar, Naming naming) {
        return naming.basePackageRuntime(grammar) + ".services." + GrammarUtil.getSimpleName((Grammar)grammar) + "GrammarAccess";
    }

    public static String getUniqueRuleName(AbstractRule rule) {
        String plainName = RuleNames.getRuleNames((AbstractRule)rule).getUniqueRuleName(rule);
        return GrammarAccessUtil.toJavaIdentifier(plainName, (Boolean)true);
    }

    public static String getUniqueElementName(AbstractElement ele) {
        try {
            if (ele == null) {
                return "null";
            }
            ArrayList<String> r = new ArrayList<String>();
            r.addAll(GrammarAccessUtil.getElementDescription(ele));
            r.add(GrammarAccessUtil.getElementTypeDescription(ele));
            r.add(GrammarAccessUtil.getElementPath(ele));
            return GrammarAccessUtil.toJavaIdentifier(r, true);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "failure";
        }
    }

    private static String toJavaIdentifier(List<String> text, boolean uppercaseFirst) {
        Iterator<String> i = text.iterator();
        StringBuffer b = new StringBuffer(GrammarAccessUtil.toJavaIdentifierSegment(i.next(), true, uppercaseFirst));
        while (i.hasNext()) {
            b.append(GrammarAccessUtil.toJavaIdentifierSegment(i.next(), false, true));
        }
        return b.toString();
    }

    private static String toJavaIdentifierSegmentInt(String text, boolean isFirst, boolean uppercaseFirst) {
        boolean start = isFirst;
        boolean up = true;
        StringBuffer r = new StringBuffer();
        for (char c : text.toCharArray()) {
            boolean valid = GrammarAccessUtil.isValidJavaLatinIdentifier(start, c);
            if (valid) {
                if (start) {
                    r.append(uppercaseFirst ? Character.toUpperCase(c) : Character.toLowerCase(c));
                } else {
                    r.append(up ? Character.toUpperCase(c) : c);
                }
                up = false;
                start = false;
                continue;
            }
            up = true;
        }
        return r.toString();
    }

    public static boolean isValidJavaLatinIdentifier(boolean start, char c) {
        boolean valid = c >= 'A' && c <= 'Z';
        valid = valid || c >= 'a' && c <= 'z';
        valid = valid || c == '\u00e4' || c == '\u00f6' || c == '\u00fc' || c == '\u00c4' || c == '\u00d6' || c == '\u00dc';
        boolean bl = valid = valid || c == '_';
        if (!start) {
            valid = valid || c >= '0' && c <= '9';
        }
        return valid;
    }

    private static String toJavaIdentifierSegment(String text, boolean isFirst, boolean uppercaseFirst) {
        String r = GrammarAccessUtil.toJavaIdentifierSegmentInt(text, isFirst, uppercaseFirst);
        if (r.length() > 0) {
            return r;
        }
        StringBuffer b = new StringBuffer();
        for (char c : text.toCharArray()) {
            String n = Character.getName(c);
            if (n == null) continue;
            b.append(n + " ");
        }
        return GrammarAccessUtil.toJavaIdentifierSegmentInt(b.toString().toLowerCase().trim(), isFirst, true);
    }

    public static String toJavaIdentifier(String text, Boolean uppercaseFirst) {
        try {
            return GrammarAccessUtil.toJavaIdentifierSegment(text, true, uppercaseFirst);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "%_FAILURE_(" + text + ")%";
        }
    }

    public static List<Grammar> getEffectivelyUsedGrammars(final Grammar grammar) {
        List allRules = GrammarUtil.allRules((Grammar)grammar);
        List _map = ListExtensions.map((List)allRules, (Functions.Function1)new Functions.Function1<AbstractRule, Grammar>(){

            public Grammar apply(AbstractRule it) {
                return GrammarUtil.getGrammar((EObject)it);
            }
        });
        Iterable filtered = IterableExtensions.filter((Iterable)_map, (Functions.Function1)new Functions.Function1<Grammar, Boolean>(){

            public Boolean apply(Grammar it) {
                return it != grammar;
            }
        });
        Set set = IterableExtensions.toSet((Iterable)filtered);
        return IterableExtensions.toList((Iterable)set);
    }

    protected static class LineSeparatorModule
    extends XtextRuntimeModule {
        private final ILineSeparatorInformation lineSeparatorInformation;

        protected LineSeparatorModule(ILineSeparatorInformation lineSeparatorInformation) {
            this.lineSeparatorInformation = lineSeparatorInformation;
        }

        public void configure(Binder binder) {
            CompoundModule compound = this.getBindings();
            compound.configure(binder);
        }

        public ILineSeparatorInformation bindILineSeparatorInformation() {
            return this.lineSeparatorInformation;
        }
    }
}

